/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.platform.utils.jdt;

import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class JavaProjectClassLoader
extends ClassLoader {
    private URLClassLoader delegate;

    public JavaProjectClassLoader(ClassLoader delegate, IProject project) {
        super(delegate);
        IJavaProject javaProject;
        if (project != null && (javaProject = JavaCore.create((IProject)project)).exists()) {
            try {
                IPath wsRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
                URL[] classPath = new URL[entries.length + 1];
                classPath[0] = wsRoot.append(javaProject.getOutputLocation()).toFile().toURL();
                int i = 0;
                while (i < entries.length) {
                    IClasspathEntry entry = entries[i];
                    classPath[1 + i] = (3 == entry.getEntryKind() ? wsRoot.append(entry.getPath()) : entry.getPath()).toFile().toURL();
                    ++i;
                }
                this.delegate = new URLClassLoader(classPath);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected URL findResource(String name) {
        URL result = null;
        if (this.delegate != null) {
            result = this.delegate.findResource(name);
        }
        return result;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> result = null;
        if (this.delegate != null) {
            try {
                result = this.delegate.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ClassNotFoundException(cnfe.getMessage());
            }
        }
        return result;
    }
}

