/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ProjectClassLoader
extends ClassLoader {
    private IProject project;
    private ClassLoader delegate;
    private String resource;

    public ProjectClassLoader(ClassLoader delegate, IProject project, String resource) {
        this.delegate = delegate;
        this.project = project;
        this.resource = resource;
    }

    @Override
    protected URL findResource(String name) {
        URL result = this.delegate.getResource(name);
        if (result == null && name.equals(this.resource)) {
            List classpath = this.resolveClasspath(this.project, new HashSet());
            URLClassLoader cl = new URLClassLoader(classpath.toArray(new URL[0]));
            result = cl.findResource(name);
        }
        return result;
    }

    private List resolveClasspath(IProject project, Set compareStrings) {
        ArrayList classpath = new ArrayList();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject.exists()) {
            IPath projectPath = project.getFullPath();
            IPath projectLocation = project.getLocation().removeLastSegments(projectPath.segmentCount());
            try {
                IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
                int i = 0;
                while (i < entries.length) {
                    if (entries[i].getEntryKind() == 2) {
                        classpath.addAll(this.resolveClasspath(this.findProject(entries[i].getPath()), compareStrings));
                    } else {
                        IPath entryPath = entries[i].getPath();
                        if (projectPath.isPrefixOf(entryPath)) {
                            entryPath = projectLocation.append(entryPath);
                        }
                        this.addClasspathEntry(classpath, compareStrings, entryPath);
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return classpath;
    }

    private void addClasspathEntry(List classpath, Set compareStrings, IPath entryPath) {
        try {
            URL newEntry = entryPath.toFile().toURL();
            String newEntryString = newEntry.toString();
            if (!compareStrings.contains(newEntryString)) {
                classpath.add(newEntry);
                compareStrings.add(newEntryString);
            }
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private IProject findProject(IPath path) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment());
    }
}

