/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.wst.modeling.app.jsf.generation;

import com.icesoft.faces.component.ext.HtmlPanelGrid;
import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.util.CoreUtils;
import com.icesoft.util.pooling.CSSNamePool;
import com.icesoft.util.pooling.StringInternMapLRU;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.engine.extensions.dms.data.DocumentType;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.JSF_Messages;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.generation.GenericDataMapping;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.generation.IppSystemPath;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.generation.ManualActivityJsfFormGenerator;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.generation.ManualActivityPath;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.generation.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.ui.common.form.Form;
import org.eclipse.stardust.ui.common.form.FormInput;
import org.eclipse.stardust.ui.common.form.Indent;
import org.eclipse.stardust.ui.common.form.InputController;
import org.eclipse.stardust.ui.common.form.InputControllerDataTypeAdapter;
import org.eclipse.stardust.ui.common.form.ListInputController;
import org.eclipse.stardust.ui.common.form.PrimitiveInputController;
import org.eclipse.stardust.ui.common.form.jsf.DocumentInputController;
import org.eclipse.stardust.ui.common.form.jsf.DocumentPath;
import org.eclipse.stardust.ui.common.form.jsf.JsfStructureContainer;
import org.eclipse.stardust.ui.common.form.jsf.PrimitiveInputControllerDataTypeAdapter;
import org.eclipse.stardust.ui.common.form.preferences.FormGenerationPreferences;
import org.eclipse.stardust.ui.common.introspection.Path;
import org.eclipse.stardust.ui.common.introspection.java.JavaPath;
import org.eclipse.stardust.ui.common.introspection.xsd.XsdPath;
import org.eclipse.stardust.ui.web.common.reflect.Reflect;

public class ManualActivityForm
extends Form {
    private List<GenericDataMapping> dataMappings;
    private String beanName;
    private FormGenerationPreferences genPrefs;
    private ManualActivityJsfFormGenerator formGenerator;

    public ManualActivityForm(List<GenericDataMapping> dataMappings, String beanName, FormGenerationPreferences genPrefs) {
        this.dataMappings = dataMappings;
        this.beanName = beanName;
        this.genPrefs = genPrefs;
        this.init();
    }

    private void init() {
        this.formGenerator = new ManualActivityJsfFormGenerator(this.genPrefs, this.beanName);
        this.generateForm();
    }

    private void generateForm() {
        this.setRootContainer(this.formGenerator.createRootComponent());
        Map inDataMappings = CollectionUtils.newMap();
        Map outDataMappings = CollectionUtils.newMap();
        this.sortInOutMappings(this.dataMappings, inDataMappings, outDataMappings);
        ManualActivityPath manualActivityPath = new ManualActivityPath("ManualActivity", false);
        for (GenericDataMapping genericDataMapping : this.dataMappings) {
            String id = genericDataMapping.getId();
            if (inDataMappings.containsKey(id)) {
                this.handleDataMapping(manualActivityPath, genericDataMapping, this.beanName, true, false);
                inDataMappings.remove(id);
                continue;
            }
            if (!outDataMappings.containsKey(id)) continue;
            this.handleDataMapping(manualActivityPath, genericDataMapping, this.beanName, false, this.isWriteOnly(genericDataMapping, this.dataMappings));
            outDataMappings.remove(id);
        }
        this.processManualActivityPath(manualActivityPath);
    }

    public String generateMarkup(Indent indent) {
        Reflect.setStaticFieldValue(Util.class, (String)"ignoreUserRoleTested", (Object)new Boolean(true));
        Reflect.setStaticFieldValue(Util.class, (String)"ignoreUserRole", (Object)new Boolean(true));
        Reflect.setStaticFieldValue(CoreUtils.class, (String)"portletEnvironment", (Object)new Boolean(false));
        Reflect.setStaticFieldValue(CoreUtils.class, (String)"renderPortletStyleClass", (Object)new Boolean(false));
        Reflect.setStaticFieldValue(CSSNamePool.class, (String)"pool", (Object)new StringInternMapLRU(null));
        HtmlPanelGrid rootComp = ((JsfStructureContainer)this.getRootContainer()).getRootGrid();
        String markup = this.formGenerator.generateMarkup((UIComponent)rootComp, indent);
        return markup;
    }

    public String generateMarkup() {
        return this.generateMarkup(new Indent());
    }

    private void handleDataMapping(ManualActivityPath manualActivityPath, GenericDataMapping dataMapping, String beanName, boolean readOnly, boolean writeOnly) {
        Path path = null;
        if (ModelUtils.isSystemDefinedData(dataMapping)) {
            path = this.createSystemDataMapping(dataMapping, manualActivityPath, readOnly);
        } else if (ModelUtils.isDMSType(dataMapping)) {
            path = this.createDMSDataMapping(dataMapping, manualActivityPath, writeOnly, readOnly);
        } else if (ModelUtils.isEnumerationType(dataMapping)) {
            path = this.createStructureDataMapping(dataMapping, manualActivityPath, readOnly);
        } else if (ModelUtils.isPrimitiveType(dataMapping)) {
            path = this.createPrimitiveDataMapping(dataMapping, manualActivityPath, readOnly);
        } else if (ModelUtils.isStructuredType(dataMapping)) {
            path = this.createStructureDataMapping(dataMapping, manualActivityPath, readOnly);
        }
        if (path != null) {
            manualActivityPath.getChildPaths().add(path);
        }
    }

    private void processManualActivityPath(ManualActivityPath manualActivityPath) {
        for (Path path : manualActivityPath.getChildPaths()) {
            if (path instanceof IppSystemPath) {
                this.handleSystemPath((IppSystemPath)path);
                continue;
            }
            if (path instanceof DocumentPath) {
                this.handleDocumentPath((DocumentPath)path);
                continue;
            }
            if (path.isEnumeration()) {
                this.handleEnumerationPath(path);
                continue;
            }
            if (path.isPrimitive()) {
                this.handlePrimitivePath(path);
                continue;
            }
            if (path.isList()) {
                this.handleListDataMapping(path);
                continue;
            }
            if (path.getChildPaths().size() <= 0) continue;
            this.handleStructureDataMapping(path);
        }
    }

    private boolean handleSystemPath(IppSystemPath systemPath) {
        PrimitiveInputController inputController = new PrimitiveInputController((Path)systemPath, (InputControllerDataTypeAdapter)new PrimitiveInputControllerDataTypeAdapter((Path)systemPath));
        FormInput input = null;
        if (systemPath.isEnumeration()) {
            input = this.formGenerator.addEnumerationInput(this.getRootContainer(), inputController);
        } else if (systemPath.isPrimitive()) {
            input = this.formGenerator.addPrimitiveInput(this.getRootContainer(), inputController);
        }
        if (input != null) {
            this.getRootContainer().getInputs().add(input);
            this.getFullPathInputControllerMap().put("/" + systemPath.getId(), inputController);
            this.getTopLevelInputControllerMap().put(systemPath.getId(), inputController);
            return true;
        }
        return false;
    }

    private boolean handlePrimitivePath(Path path) {
        PrimitiveInputController inputController = new PrimitiveInputController(path, (InputControllerDataTypeAdapter)new PrimitiveInputControllerDataTypeAdapter(path));
        FormInput input = this.formGenerator.addPrimitiveInput(this.getRootContainer(), inputController);
        this.getRootContainer().getInputs().add(input);
        this.getFullPathInputControllerMap().put("/" + path.getId(), inputController);
        this.getTopLevelInputControllerMap().put(path.getId(), inputController);
        return true;
    }

    private boolean handleEnumerationPath(Path path) {
        PrimitiveInputController inputController = new PrimitiveInputController(path, (InputControllerDataTypeAdapter)new PrimitiveInputControllerDataTypeAdapter(path));
        FormInput input = this.formGenerator.addEnumerationInput(this.getRootContainer(), inputController);
        this.getRootContainer().getInputs().add(input);
        this.getFullPathInputControllerMap().put("/" + path.getId(), inputController);
        this.getTopLevelInputControllerMap().put(path.getId(), inputController);
        return true;
    }

    private boolean handleStructureDataMapping(Path path) {
        this.getTopLevelInputControllerMap().put(path.getId(), this.formGenerator.generateStructurePanel(this.getFullPathInputControllerMap(), this.getRootContainer(), path));
        return true;
    }

    private boolean handleDocumentPath(DocumentPath documentPath) {
        DummyDocumentInputController docInputController = new DummyDocumentInputController(documentPath);
        this.formGenerator.addDocumentInput(this.getFullPathInputControllerMap(), this.getRootContainer(), (InputController)docInputController);
        this.getFullPathInputControllerMap().put("/" + documentPath.getId(), docInputController);
        this.getTopLevelInputControllerMap().put(documentPath.getId(), docInputController);
        return true;
    }

    private boolean handleListDataMapping(Path path) {
        ListInputController listInputController = new ListInputController(path);
        this.formGenerator.addListComponent(this.getRootContainer(), path);
        this.getFullPathInputControllerMap().put("/" + path.getId(), listInputController);
        this.getTopLevelInputControllerMap().put(path.getId(), listInputController);
        return true;
    }

    private void sortInOutMappings(List<GenericDataMapping> dataMappings, Map<String, GenericDataMapping> inDataMappings, Map<String, GenericDataMapping> outDataMappings) {
        for (GenericDataMapping genericDataMapping : dataMappings) {
            String id = genericDataMapping.getId();
            switch (genericDataMapping.getDataMapping().getDirection()) {
                case OUT_LITERAL: {
                    GenericDataMapping inDataMapping = inDataMappings.get(id);
                    if (inDataMapping != null) {
                        if (!inDataMapping.getMappedType().getMappedType().equals(genericDataMapping.getMappedType().getMappedType())) {
                            throw new RuntimeException(JSF_Messages.MSG_SameIdForDiffMappings);
                        }
                        inDataMappings.remove(inDataMapping.getId());
                    }
                    outDataMappings.put(id, genericDataMapping);
                    break;
                }
                case IN_LITERAL: {
                    GenericDataMapping outDataMapping = outDataMappings.get(id);
                    if (outDataMapping == null) {
                        inDataMappings.put(id, genericDataMapping);
                        break;
                    }
                    if (outDataMapping.getMappedType().getMappedType().equals(genericDataMapping.getMappedType().getMappedType())) break;
                    throw new RuntimeException(JSF_Messages.MSG_SameIdForDiffMappings);
                }
            }
        }
    }

    private Path createDMSDataMapping(GenericDataMapping dataMapping, ManualActivityPath maPath, boolean writeOnly, boolean readOnly) {
        TypedXPath path;
        if (ModelUtils.isDocumentType(dataMapping)) {
            if (!writeOnly) {
                DocumentType dummyDocumentType = null;
                return new DocumentPath((Path)maPath, dataMapping.getId(), dummyDocumentType, null, readOnly);
            }
        } else if (!ModelUtils.isFolderType(dataMapping) && (path = ModelUtils.getTypedXPath(dataMapping)) != null) {
            XsdPath docTypePath = null;
            if ("properties".equals(dataMapping.getDataMapping().getDataPath())) {
                if (path.getParentXPath() == null) {
                    docTypePath = new XsdPath((Path)maPath, path, dataMapping.getId(), readOnly);
                }
            } else if (dataMapping.getDataMapping().getDataPath().startsWith("properties/")) {
                docTypePath = new XsdPath((Path)maPath, path, dataMapping.getId(), readOnly);
            }
            if (docTypePath == null && ModelUtils.isPrimitiveType(dataMapping)) {
                docTypePath = this.createPrimitiveDataMapping(dataMapping, maPath, readOnly);
            }
            return docTypePath;
        }
        return null;
    }

    private Path createSystemDataMapping(GenericDataMapping dataMapping, ManualActivityPath maPath, boolean readOnly) {
        return new IppSystemPath(maPath, dataMapping.getId(), this.isReallyReadOnly(dataMapping, readOnly));
    }

    private Path createPrimitiveDataMapping(GenericDataMapping dataMapping, ManualActivityPath maPath, boolean readOnly) {
        return JavaPath.createFromClass((Path)maPath, (String)dataMapping.getId(), dataMapping.getMappedType().getMappedType(), (boolean)this.isReallyReadOnly(dataMapping, readOnly));
    }

    private Path createStructureDataMapping(GenericDataMapping dataMapping, ManualActivityPath maPath, boolean readOnly) {
        TypedXPath path = ModelUtils.getTypedXPath(dataMapping);
        if (path != null) {
            return new XsdPath((Path)maPath, path, dataMapping.getId(), readOnly);
        }
        return null;
    }

    private boolean isReallyReadOnly(GenericDataMapping dataMapping, boolean readOnly) {
        if (ModelUtils.isSystemDefinedReadOnlyData(dataMapping)) {
            return true;
        }
        if (ModelUtils.isDMSReadOnlyData(dataMapping)) {
            return true;
        }
        return readOnly;
    }

    private boolean isWriteOnly(GenericDataMapping dataMapping, List<GenericDataMapping> allMappings) {
        if (DirectionType.IN_LITERAL == dataMapping.getDataMapping().getDirection() || DirectionType.INOUT_LITERAL == dataMapping.getDataMapping().getDirection()) {
            return false;
        }
        if (DirectionType.OUT_LITERAL == dataMapping.getDataMapping().getDirection()) {
            for (GenericDataMapping dm : allMappings) {
                if (DirectionType.IN_LITERAL != dm.getDataMapping().getDirection() || !dm.getId().equals(dataMapping.getId())) continue;
                return false;
            }
        }
        return true;
    }

    public String getBeanName() {
        return this.beanName;
    }

    private class DummyDocumentInputController
    extends DocumentInputController {
        public DummyDocumentInputController(DocumentPath path) {
            super(path);
        }

        protected void viewDocument() {
        }

        protected void uploadDocument() {
        }

        public void deleteDocument() {
        }

        public boolean saveDocument() {
            return false;
        }

        public void closeDocument() {
        }
    }
}

