/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.wst.modeling.app.jsf.spi.context;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.ide.wst.modeling.app.jsf.JSF_Messages;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;

public class JSFValidator
implements IModelElementValidator {
    public Issue[] validate(IModelElement element) throws ValidationException {
        String className;
        List result = CollectionUtils.newList();
        String url = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"jsf:url");
        if (url == null) {
            result.add(Issue.warning((EObject)element, (String)JSF_Messages.MSG_JSF_No_url, (Object)"jsf:url"));
        }
        if ((className = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:className")) == null) {
            result.add(Issue.warning((EObject)element, (String)JSF_Messages.MSG_JSF_No_class, (Object)"carnot:engine:className"));
        } else {
            TypeFinder typeFinder = new TypeFinder((EObject)element);
            className = VariableContextHelper.getInstance().getContext((ModelType)element.eContainer().eContainer()).replaceAllVariablesByDefaultValue(className);
            TypeInfo type = typeFinder.findType(className);
            if (type == null) {
                result.add(Issue.warning((EObject)element, (String)MessageFormat.format(JSF_Messages.MSG_JSF_No_class_access, className), (Object)"carnot:engine:className"));
            } else {
                String methodName = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:methodName");
                if (methodName == null) {
                    result.add(Issue.warning((EObject)element, (String)JSF_Messages.MSG_JSF_No_method, (Object)"carnot:engine:methodName"));
                } else {
                    methodName = VariableContextHelper.getInstance().getContext((ModelType)element.eContainer().eContainer()).replaceAllVariablesByDefaultValue(methodName);
                    MethodInfo info = typeFinder.getMethod(type, methodName);
                    if (info == null) {
                        result.add(Issue.warning((EObject)element, (String)MessageFormat.format(JSF_Messages.MSG_JSF_No_method_access, methodName), (Object)"carnot:engine:methodName"));
                    }
                }
            }
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }
}

