/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages.visitors;

import java.util.Date;
import java.util.List;
import org.eclipse.stardust.ide.simulation.ui.SimulationConfiguration;
import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.distributions.AvailabilityConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.ProbabilityConfiguration;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AvailabilityCalendarUtility;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimeCalculator;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValue;
import org.eclipse.stardust.ide.simulation.ui.timeutils.TimestampValueList;
import org.eclipse.stardust.ide.simulation.ui.utils.ModelTraversalVisitor;
import org.eclipse.stardust.ide.simulation.ui.utils.ModelVisitor;
import org.eclipse.stardust.ide.simulation.ui.utils.SimulationModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;

public class UpdateSimulationIntervalVisitor
implements ModelVisitor {
    int configurationId;
    SimulationInterval oldInterval;
    SimulationInterval newInterval;
    long leftShift;
    long rightShift;
    long newRange;

    public UpdateSimulationIntervalVisitor(ModelType model, SimulationConfiguration simulationConfiguration, SimulationInterval oldInterval) {
        this.configurationId = simulationConfiguration.getId();
        this.newInterval = simulationConfiguration.getInterval();
        this.oldInterval = oldInterval;
        this.leftShift = this.newInterval.getStartDate().getTime() - this.oldInterval.getStartDate().getTime();
        this.rightShift = this.newInterval.getEndDate().getTime() - this.oldInterval.getEndDate().getTime();
        Date normalizedEnd = new TimeCalculator(this.newInterval.getEndDate()).moveToBeginOfDay().add(6, 1).toDate();
        this.newRange = normalizedEnd.getTime() - this.newInterval.getStartDate().getTime();
        new ModelTraversalVisitor(this, model);
    }

    @Override
    public void visit(ModelType model) {
    }

    @Override
    public void visit(ProcessDefinitionType element) {
        AvailabilityConfiguration configuration = new AvailabilityConfiguration(this.oldInterval);
        configuration.read((IExtensibleElement)element, this.configurationId);
        configuration.setYear(this.patch(configuration.getYear()));
        configuration.setCalendar(this.patchCalendar(configuration.getCalendar()));
        configuration.updateInterval(this.newInterval);
        configuration.write((IExtensibleElement)element, this.configurationId);
    }

    @Override
    public void visit(ActivityType element) {
    }

    @Override
    public void visit(ApplicationType element) {
        if (!element.isInteractive()) {
            AvailabilityConfiguration configuration = new AvailabilityConfiguration(this.oldInterval);
            configuration.read((IExtensibleElement)element, this.configurationId);
            configuration.setYear(this.patch(configuration.getYear()));
            configuration.setCalendar(this.patchCalendar(configuration.getCalendar()));
            configuration.updateInterval(this.newInterval);
            configuration.write((IExtensibleElement)element, this.configurationId);
        }
    }

    @Override
    public void visit(IModelParticipant element) {
        AvailabilityConfiguration configuration = new AvailabilityConfiguration(this.oldInterval);
        configuration.read((IExtensibleElement)element, this.configurationId);
        configuration.setYear(this.patch(configuration.getYear()));
        configuration.setCalendar(this.patchCalendar(configuration.getCalendar()));
        configuration.updateInterval(this.newInterval);
        configuration.write((IExtensibleElement)element, this.configurationId);
    }

    @Override
    public void visit(TransitionType element) {
        ProbabilityConfiguration configuration = new ProbabilityConfiguration(this.oldInterval, SimulationModelUtils.calculateDefaultProbability((IModelElement)element));
        configuration.read((IExtensibleElement)element, this.configurationId);
        configuration.setCurve(this.patch(configuration.getCurve()));
        configuration.updateInterval(this.newInterval);
        configuration.write((IExtensibleElement)element, this.configurationId);
    }

    @Override
    public void visit(DataType element) {
    }

    private TimestampValue[] patch(List oldValues) {
        TimestampValueList newValues = new TimestampValueList();
        if (oldValues.size() == 1) {
            TimestampValue oldPoint = (TimestampValue)oldValues.get(0);
            newValues.add(new TimestampValue(0L, oldPoint.getValue()));
            newValues.add(new TimestampValue(this.roundDate(this.newRange), oldPoint.getValue()));
        } else if (oldValues.size() > 1) {
            TimestampValue oldFirst = (TimestampValue)oldValues.get(0);
            TimestampValue oldLast = (TimestampValue)oldValues.get(oldValues.size() - 1);
            double leftMostValue = oldFirst.getValue();
            int i = 1;
            while (i < oldValues.size() - 1) {
                TimestampValue oldTV = (TimestampValue)oldValues.get(i);
                TimestampValue newTV = new TimestampValue(this.roundDate(oldTV.getTime() - this.leftShift), oldTV.getValue());
                if (newTV.getTime() < 0L) {
                    leftMostValue = oldTV.getValue();
                } else if (newTV.getTime() <= this.newRange) {
                    newValues.add(newTV);
                }
                ++i;
            }
            if (newValues.size() == 0 || newValues.getFirst().getTime() != 0L) {
                newValues.prepend(new TimestampValue(0L, leftMostValue));
            }
            if (newValues.getLast().getTime() < this.newRange) {
                if (this.rightShift < 0L) {
                    newValues.add(new TimestampValue(this.roundDate(this.newRange), newValues.getLast().getValue()));
                } else {
                    newValues.add(new TimestampValue(this.roundDate(this.newRange), oldLast.getValue()));
                }
            }
        }
        return newValues.toArray();
    }

    private TimestampValue[] patchCalendar(List oldValues) {
        if (this.leftShift == 0L && this.rightShift == 0L) {
            return oldValues.toArray(new TimestampValue[oldValues.size()]);
        }
        long oldOffset = this.oldInterval.getStartDate().getTime();
        long newOffset = this.newInterval.getStartDate().getTime();
        List newCalendarMaster = AvailabilityCalendarUtility.createAvailabilityCalendar(this.newInterval.getStartDate(), this.newInterval.getEndDate());
        TimestampValueList newValues = new TimestampValueList();
        int i = 0;
        while (i < newCalendarMaster.size()) {
            TimestampValue masterTV = (TimestampValue)newCalendarMaster.get(i);
            TimeCalculator masterTC = new TimeCalculator(masterTV.shift(newOffset));
            TimestampValue found = null;
            int j = 0;
            while (j < oldValues.size()) {
                TimestampValue oldTV = (TimestampValue)oldValues.get(j);
                TimeCalculator oldTC = new TimeCalculator(oldTV.shift(oldOffset));
                if (masterTC.get(6) == oldTC.get(6) && masterTC.get(1) == oldTC.get(1)) {
                    found = oldTV;
                    break;
                }
                ++j;
            }
            if (found != null) {
                newValues.add(new TimestampValue(masterTV.getTime(), found.getValue()));
            } else {
                newValues.add(masterTV);
            }
            ++i;
        }
        return newValues.toArray();
    }

    private long roundDate(long time) {
        long offset = this.newInterval.getStartDate().getTime();
        long t0 = new TimeCalculator(time + offset).moveToBeginOfDay().toLong() - offset;
        long t1 = new TimeCalculator(time + offset).moveToBeginOfDay().add(6, 1).toLong() - offset;
        long tm = (t0 + t1) / 2L;
        System.out.println(t0 - time);
        System.out.println(new TimeCalculator(time + offset).moveToBeginOfDay().toDate());
        return time <= tm ? t0 : t1;
    }
}

