/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.dataexporter;

import com.icesoft.faces.application.D2DViewHandler;
import com.icesoft.faces.component.commandsortheader.CommandSortHeader;
import com.icesoft.faces.component.dataexporter.CSVOutputHandler;
import com.icesoft.faces.component.dataexporter.ExcelOutputHandler;
import com.icesoft.faces.component.dataexporter.OutputTypeHandler;
import com.icesoft.faces.component.dataexporter.PDFOutputHandler;
import com.icesoft.faces.component.ext.RowSelector;
import com.icesoft.faces.component.ext.UIColumn;
import com.icesoft.faces.component.ext.UIColumns;
import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.component.outputresource.OutputResource;
import com.icesoft.faces.context.FileResource;
import com.icesoft.faces.context.Resource;
import com.icesoft.faces.context.ResourceRegistry;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.util.CoreUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UISelectBoolean;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataExporter
extends OutputResource {
    public static final String COMPONENT_FAMILY = "com.icesoft.faces.DataExporter";
    public static final String COMPONENT_TYPE = "com.icesoft.faces.DataExporter";
    public static final String DEFAULT_RENDERER_TYPE = "com.icesoft.faces.DataExporterRenderer";
    private final Log log = LogFactory.getLog((Class)DataExporter.class);
    private static final OutputTypeHandler NoopOutputHandler = new OutputTypeHandler("no-data"){

        public void writeHeaderCell(String text, int col) {
        }

        public void writeCell(Object output, int col, int row) {
        }

        public void flushFile() {
        }
    };
    private boolean readyToExport = false;
    private String _for;
    private String type;
    private String clickToCreateFileText;
    private String _origType;
    private transient OutputTypeHandler outputTypeHandler;
    private String _origFor;
    private transient OutputTypeHandler _origOutputTypeHandler;
    private transient int _origDataModelHash = 0;
    public static final String EXCEL_TYPE = "excel";
    public static final String CSV_TYPE = "csv";
    public static final String PDF_TYPE = "pdf";
    private Boolean ignorePagination;
    private Boolean renderLabelAsButton;
    private String styleClass;
    private String includeColumns;
    private int rows = Integer.MIN_VALUE;
    private int first = Integer.MIN_VALUE;
    private String popupBlockerLabel;
    private transient Object[] values;

    public String getFamily() {
        return "com.icesoft.faces.DataExporter";
    }

    public String getComponentType() {
        return "com.icesoft.faces.DataExporter";
    }

    public String getRendererType() {
        return DEFAULT_RENDERER_TYPE;
    }

    public UIData getUIData() {
        Object value;
        String forStr = this.getFor();
        UIData forComp = (UIData)D2DViewHandler.findComponent((String)forStr, (UIComponent)this);
        if (forComp == null) {
            throw new IllegalArgumentException("could not find UIData referenced by attribute @for = '" + forStr + "'");
        }
        if (!(forComp instanceof UIData)) {
            throw new IllegalArgumentException("uiComponent referenced by attribute @for = '" + forStr + "' must be of type " + UIData.class.getName() + ", not type " + forComp.getClass().getName());
        }
        if (this._origDataModelHash != 0 && this._origDataModelHash != forComp.getValue().hashCode()) {
            this.reset();
        }
        if (!this.isIgnorePagination() && (this.first != Integer.MIN_VALUE && this.first != forComp.getFirst() || this.rows != Integer.MIN_VALUE && this.rows != forComp.getRows())) {
            this.reset();
        }
        if (null != (value = forComp.getValue())) {
            this._origDataModelHash = forComp.getValue().hashCode();
        }
        return forComp;
    }

    private void reset() {
        this.readyToExport = false;
        this.resource = null;
    }

    public String getFor() {
        if (this._for != null) {
            if (!this._for.equals(this._origFor)) {
                this.reset();
            }
            this._origFor = this._for;
            return this._for;
        }
        ValueBinding vb = this.getValueBinding("for");
        String newFor = null;
        if (vb != null) {
            newFor = (String)vb.getValue(this.getFacesContext());
            if (newFor != null && !newFor.equals(this._origFor)) {
                this.reset();
            }
            this._origFor = newFor;
        }
        return newFor;
    }

    public void setFor(String forValue) {
        if (forValue != null && !forValue.equals(this._for)) {
            this.resource = null;
        }
        this._for = forValue;
    }

    public String getType() {
        if (this.type != null) {
            if (!this.type.equals(this._origType)) {
                this.reset();
            }
            this._origType = this.type;
            return this.type;
        }
        ValueBinding vb = this.getValueBinding("type");
        String newType = null;
        if (vb != null) {
            newType = (String)vb.getValue(this.getFacesContext());
            if (newType != null && !newType.equals(this._origType)) {
                this.reset();
            }
            this._origType = newType;
        }
        return newType;
    }

    public void setType(String type) {
        if (type != null && !type.equals(this.type)) {
            this.reset();
        }
        this.type = type;
    }

    public boolean isReadyToExport() {
        return this.readyToExport;
    }

    public void setReadyToExport(boolean readyToExport) {
        this.readyToExport = readyToExport;
    }

    public String getClickToCreateFileText() {
        if (this.clickToCreateFileText != null) {
            return this.clickToCreateFileText;
        }
        ValueBinding vb = this.getValueBinding("clickToCreateFileText");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setClickToCreateFileText(String clickToCreateFileText) {
        this.clickToCreateFileText = clickToCreateFileText;
    }

    public OutputTypeHandler getOutputTypeHandler() {
        ValueBinding vb = this.getValueBinding("outputTypeHandler");
        OutputTypeHandler newOutputHandler = null;
        if (vb != null) {
            newOutputHandler = (OutputTypeHandler)vb.getValue(this.getFacesContext());
            if (newOutputHandler != null && newOutputHandler != this._origOutputTypeHandler) {
                this.reset();
            }
            this._origOutputTypeHandler = newOutputHandler;
        }
        return newOutputHandler;
    }

    public void setOutputTypeHandler(OutputTypeHandler outputTypeHandler) {
        if (outputTypeHandler != null && outputTypeHandler != this.outputTypeHandler) {
            this.reset();
        }
        this.outputTypeHandler = outputTypeHandler;
    }

    public Object saveState(FacesContext context) {
        if (this.values == null) {
            this.values = new Object[14];
        }
        this.values[0] = super.saveState(context);
        this.values[1] = this._for;
        this.values[2] = this.type;
        this.values[3] = this.clickToCreateFileText;
        this.values[4] = this.readyToExport ? Boolean.TRUE : Boolean.FALSE;
        this.values[5] = this._origType;
        this.values[6] = this._origFor;
        this.values[7] = this.ignorePagination;
        this.values[8] = this.renderLabelAsButton;
        this.values[9] = this.styleClass;
        this.values[10] = this.includeColumns;
        this.values[11] = new Integer(this.rows);
        this.values[12] = new Integer(this.first);
        this.values[13] = this.popupBlockerLabel;
        return this.values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._for = (String)values[1];
        this.type = (String)values[2];
        this.clickToCreateFileText = (String)values[3];
        this.readyToExport = (Boolean)values[4];
        this._origType = (String)values[5];
        this._origFor = (String)values[6];
        this.ignorePagination = (Boolean)values[7];
        this.renderLabelAsButton = (Boolean)values[8];
        this.styleClass = (String)values[9];
        this.includeColumns = (String)values[10];
        this.rows = (Integer)values[11];
        this.first = (Integer)values[12];
        this.popupBlockerLabel = (String)values[13];
    }

    public String getLabel() {
        String label = super.getLabel();
        if (label == null && this.resource instanceof FileResource) {
            label = ((FileResource)this.resource).getFile().getName();
        }
        return label;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event != null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            String type = this.getType();
            UIData uiData = this.getUIData();
            final File output = this.createFile(facesContext, type, uiData);
            final FileResource fileResource = new FileResource(output);
            final ResourceRegistry resourceRegistry = (ResourceRegistry)FacesContext.getCurrentInstance();
            fileResource.onClose(new Runnable(){

                public void run() {
                    resourceRegistry.deregisterResource((Resource)fileResource);
                    output.delete();
                }
            });
            this.setResource((Resource)fileResource);
            this.getResource();
            JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)("Ice.DataExporters['" + this.getClientId(facesContext) + "'].url('" + this.getPath() + "');"));
        }
    }

    private File createFile(FacesContext fc, String type, UIData uiData) {
        OutputTypeHandler outputHandler = null;
        String path = CoreUtils.getRealPath((FacesContext)fc, (String)"/export");
        File exportDir = new File(path);
        if (!exportDir.exists()) {
            exportDir.mkdirs();
        }
        String pathWithoutExt = path + "/export_" + new Date().getTime();
        outputHandler = this.getOutputTypeHandler() != null ? this.getOutputTypeHandler() : (EXCEL_TYPE.equals(this.getType()) ? new ExcelOutputHandler(pathWithoutExt + ".xls", fc, uiData.getId()) : (CSV_TYPE.equals(this.getType()) ? new CSVOutputHandler(pathWithoutExt + ".csv") : (PDF_TYPE.equals(this.getType()) ? new PDFOutputHandler(pathWithoutExt + ".pdf", uiData.getId()) : NoopOutputHandler)));
        this.renderToHandler(outputHandler, uiData, fc);
        this.setMimeType(outputHandler.getMimeType());
        return outputHandler.getFile();
    }

    private String encodeParentAndChildrenAsString(FacesContext fc, UIComponent uic) {
        ValueBinding vb;
        Object value;
        StringBuffer str = new StringBuffer();
        if (!uic.isRendered()) {
            return str.toString();
        }
        if (uic instanceof CommandSortHeader && uic.getChildCount() > 0) {
            Iterator iter = uic.getChildren().iterator();
            while (iter.hasNext()) {
                UIComponent child = (UIComponent)iter.next();
                str.append(this.encodeParentAndChildrenAsString(fc, child));
            }
        }
        if ((value = uic.getAttributes().get("value")) == null && (vb = uic.getValueBinding("value")) != null) {
            value = vb.getValue(fc);
        }
        if (value != null) {
            Converter converter = null;
            if (uic instanceof ValueHolder) {
                converter = ((ValueHolder)uic).getConverter();
            }
            if (converter == null) {
                converter = FacesContext.getCurrentInstance().getApplication().createConverter(value.getClass());
            }
            if (converter != null) {
                str.append(converter.getAsString(FacesContext.getCurrentInstance(), uic, value));
            } else {
                str.append(value);
            }
        }
        if (uic instanceof UISelectBoolean || uic instanceof UISelectMany || uic instanceof UISelectOne || uic instanceof UICommand) {
            return str.toString();
        }
        if (uic.getChildCount() > 0) {
            Iterator iter = uic.getChildren().iterator();
            while (iter.hasNext()) {
                UIComponent child = (UIComponent)iter.next();
                str.append(this.encodeParentAndChildrenAsString(fc, child));
            }
        }
        return str.toString();
    }

    protected List getRenderedChildColumnsList(UIComponent component) {
        ArrayList<UIComponent> results = new ArrayList<UIComponent>();
        Iterator kids = component.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (kid instanceof UIColumn && kid.isRendered()) {
                results.add(kid);
                continue;
            }
            if (!(kid instanceof UIColumns)) continue;
            results.add(kid);
        }
        return results;
    }

    private void renderToHandler(OutputTypeHandler outputHandler, UIData uiData, FacesContext fc) {
        try {
            int rowIndex = 0;
            int numberOfRowsToDisplay = 0;
            if (!this.isIgnorePagination()) {
                rowIndex = uiData.getFirst();
                numberOfRowsToDisplay = uiData.getRows();
                this.first = rowIndex;
                this.rows = numberOfRowsToDisplay;
            }
            int countOfRowsDisplayed = 0;
            uiData.setRowIndex(rowIndex);
            String[] includeColumnsArray = null;
            String includeColumns = this.getIncludeColumns();
            if (includeColumns != null) {
                includeColumnsArray = includeColumns.split(",");
            }
            List columns = this.getRenderedChildColumnsList((UIComponent)uiData);
            this.processAllColumns(fc, outputHandler, columns, includeColumnsArray, -1, false);
            while (uiData.isRowAvailable() && (numberOfRowsToDisplay <= 0 || countOfRowsDisplayed < numberOfRowsToDisplay)) {
                this.processAllColumns(fc, outputHandler, columns, includeColumnsArray, countOfRowsDisplayed, false);
                ++countOfRowsDisplayed;
                uiData.setRowIndex(++rowIndex);
            }
            uiData.setRowIndex(-1);
            this.processAllColumns(fc, outputHandler, columns, includeColumnsArray, countOfRowsDisplayed, true);
            outputHandler.flushFile();
        }
        catch (Exception e) {
            this.log.error((Object)"renderToHandler()", (Throwable)e);
        }
    }

    public void addInfo() {
    }

    public void setIgnorePagination(boolean ignorePagination) {
        this.ignorePagination = new Boolean(ignorePagination);
    }

    public boolean isIgnorePagination() {
        if (this.ignorePagination != null) {
            return this.ignorePagination;
        }
        ValueBinding vb = this.getValueBinding("ignorePagination");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setRenderLabelAsButton(boolean renderLabelAsButton) {
        this.renderLabelAsButton = new Boolean(renderLabelAsButton);
    }

    public boolean isRenderLabelAsButton() {
        if (this.renderLabelAsButton != null) {
            return this.renderLabelAsButton;
        }
        ValueBinding vb = this.getValueBinding("renderLabelAsButton");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.styleClass, "iceDatExp", "styleClass");
    }

    protected void processAllColumns(FacesContext fc, OutputTypeHandler outputHandler, List columns, String[] includeColumnsArray, int countOfRowsDisplayed, boolean footer) {
        if (includeColumnsArray != null) {
            this.renderInUserDefinedOrder(fc, outputHandler, columns, includeColumnsArray, 0, countOfRowsDisplayed, footer);
        } else {
            int colIndex = 0;
            Iterator childColumns = columns.iterator();
            while (childColumns.hasNext()) {
                int colsSpecificLast;
                UIComponent nextColumn = (UIComponent)childColumns.next();
                if (nextColumn instanceof UIColumn) {
                    if (countOfRowsDisplayed == -1) {
                        this.processColumnHeader(fc, outputHandler, nextColumn, colIndex);
                    } else if (footer) {
                        this.processColumnFooter(fc, outputHandler, nextColumn, colIndex, countOfRowsDisplayed);
                    } else {
                        this.processColumn(fc, outputHandler, nextColumn, colIndex, countOfRowsDisplayed);
                    }
                    ++colIndex;
                    continue;
                }
                if (!(nextColumn instanceof UIColumns)) continue;
                UIColumns nextColumns = (UIColumns)nextColumn;
                int colsSpecificIndex = nextColumns.getFirst();
                int count = nextColumns.getRows();
                int n = colsSpecificLast = count == 0 ? 0x7FFFFFFE : colsSpecificIndex + count - 1;
                while (colsSpecificIndex <= colsSpecificLast) {
                    nextColumns.setRowIndex(colsSpecificIndex);
                    if (!nextColumns.isRowAvailable()) break;
                    if (countOfRowsDisplayed == -1) {
                        this.processColumnHeader(fc, outputHandler, nextColumn, colIndex);
                    } else if (footer) {
                        this.processColumnFooter(fc, outputHandler, nextColumn, colIndex, countOfRowsDisplayed);
                    } else {
                        this.processColumn(fc, outputHandler, nextColumn, colIndex, countOfRowsDisplayed);
                    }
                    ++colsSpecificIndex;
                    ++colIndex;
                }
                nextColumns.setRowIndex(-1);
            }
        }
    }

    protected void processColumnHeader(FacesContext fc, OutputTypeHandler outputHandler, UIComponent uiColumn, int colIndex) {
        String headerText;
        UIComponent headerComp = uiColumn.getFacet("header");
        if (headerComp != null && (headerText = this.encodeParentAndChildrenAsString(fc, headerComp)) != null) {
            outputHandler.writeHeaderCell(headerText, colIndex);
        }
    }

    protected void processColumnFooter(FacesContext fc, OutputTypeHandler outputHandler, UIComponent uiColumn, int colIndex, int countOfRowsDisplayed) {
        String output;
        UIComponent footerComp = uiColumn.getFacet("footer");
        if (footerComp != null && (output = this.encodeParentAndChildrenAsString(fc, footerComp)) != null) {
            outputHandler.writeFooterCell(output, colIndex, countOfRowsDisplayed);
        }
    }

    protected void processColumn(FacesContext fc, OutputTypeHandler outputHandler, UIComponent uiColumn, int colIndex, int countOfRowsDisplayed) {
        StringBuffer stringOutput = new StringBuffer();
        Iterator childrenOfThisColumn = uiColumn.getChildren().iterator();
        while (childrenOfThisColumn.hasNext()) {
            UIComponent nextChild = (UIComponent)childrenOfThisColumn.next();
            if (!nextChild.isRendered() || nextChild instanceof RowSelector) continue;
            stringOutput.append(this.encodeParentAndChildrenAsString(fc, nextChild));
            if (!childrenOfThisColumn.hasNext()) continue;
            stringOutput.append(' ');
        }
        outputHandler.writeCell(stringOutput.toString(), colIndex, countOfRowsDisplayed);
    }

    public String getIncludeColumns() {
        if (this.includeColumns != null) {
            return this.includeColumns;
        }
        ValueBinding vb = this.getValueBinding("includeColumns");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setIncludeColumns(String includeColumns) {
        this.includeColumns = includeColumns;
    }

    protected void renderInUserDefinedOrder(FacesContext fc, OutputTypeHandler outputHandler, List columns, String[] includeColumnsArray, int colIndex, int countOfRowsDisplayed, boolean footer) {
        UIComponent previousColumn = null;
        for (int i = 0; i < includeColumnsArray.length; ++i) {
            int userIndex = 0;
            try {
                userIndex = Integer.parseInt(includeColumnsArray[i].trim());
            }
            catch (Exception e) {
                this.log.error((Object)"renderInUserDefinedOrder() invalid column index ", (Throwable)e);
                continue;
            }
            Object nextColumn = null;
            int runningIndex = 0;
            for (int listIndex = 0; listIndex < columns.size(); ++listIndex) {
                int colsSpecificIndex;
                UIComponent runningComp = (UIComponent)columns.get(listIndex);
                if (runningComp instanceof UIColumn) {
                    if (runningIndex == userIndex) {
                        nextColumn = runningComp;
                        break;
                    }
                    ++runningIndex;
                    continue;
                }
                if (!(runningComp instanceof UIColumns)) continue;
                UIColumns runningCols = (UIColumns)runningComp;
                int runningColsSize = runningCols.getRows();
                if (runningColsSize != 0) {
                    if (userIndex >= runningIndex && userIndex < runningIndex + runningColsSize) {
                        colsSpecificIndex = userIndex - runningIndex + runningCols.getFirst();
                        runningIndex = userIndex;
                        runningCols.setRowIndex(colsSpecificIndex);
                        nextColumn = runningCols;
                        break;
                    }
                    runningIndex += runningColsSize;
                    continue;
                }
                colsSpecificIndex = runningCols.getFirst();
                while (true) {
                    runningCols.setRowIndex(colsSpecificIndex);
                    if (!runningCols.isRowAvailable()) break;
                    if (runningIndex == userIndex) {
                        nextColumn = runningCols;
                        break;
                    }
                    ++runningIndex;
                    ++colsSpecificIndex;
                }
                if (nextColumn != null) break;
                if (nextColumn != null || runningCols == previousColumn) continue;
                runningCols.setRowIndex(-1);
            }
            if (nextColumn == null) {
                this.log.info((Object)("[" + userIndex + "] is invalid column index. Column index is 0 based and should be less then from " + runningIndex));
                continue;
            }
            if (previousColumn != null && nextColumn != previousColumn && previousColumn instanceof UIColumns) {
                ((UIColumns)previousColumn).setRowIndex(-1);
            }
            previousColumn = nextColumn;
            if (countOfRowsDisplayed == -1) {
                this.processColumnHeader(fc, outputHandler, (UIComponent)nextColumn, colIndex);
            } else if (footer) {
                this.processColumnFooter(fc, outputHandler, (UIComponent)nextColumn, colIndex, countOfRowsDisplayed);
            } else {
                this.processColumn(fc, outputHandler, (UIComponent)nextColumn, colIndex, countOfRowsDisplayed);
            }
            ++colIndex;
        }
        if (previousColumn != null && previousColumn instanceof UIColumns) {
            ((UIColumns)previousColumn).setRowIndex(-1);
        }
    }

    public String getPopupBlockerLabel() {
        if (this.popupBlockerLabel != null) {
            return this.popupBlockerLabel;
        }
        ValueBinding vb = this.getValueBinding("popupBlockerLabel");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setPopupBlockerLabel(String popupBlockerLabel) {
        this.popupBlockerLabel = popupBlockerLabel;
    }
}

