/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.ext;

import com.icesoft.faces.component.ext.HtmlGraphicImage;
import com.icesoft.faces.context.Resource;
import com.icesoft.faces.context.ResourceRegistry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import javax.faces.context.FacesContext;

class ImageByteArrayResource
implements Resource,
Serializable {
    private Date lastModified = new Date(System.currentTimeMillis());
    private byte[] content;
    private String mimetype;
    private URI uri;

    public ImageByteArrayResource(FacesContext context, HtmlGraphicImage component) {
        this.mimetype = component.getMimeType();
        this.uri = ((ResourceRegistry)context).registerResource((Resource)this);
    }

    public String calculateDigest() {
        return String.valueOf(this.hashCode());
    }

    public Date lastModified() {
        return this.lastModified;
    }

    public InputStream open() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    public void withOptions(Resource.Options options) throws IOException {
        Date now = new Date();
        options.setExpiresBy(now);
        options.setLastModified(now);
        options.setMimeType(this.mimetype);
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public String getPath() {
        return this.uri.getPath() + "?" + this.content.hashCode();
    }
}

