/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.gmap;

import com.icesoft.faces.context.effects.JavascriptContext;
import java.io.IOException;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class GMapControl
extends UIPanel {
    public static final String COMPONENT_TYPE = "com.icesoft.faces.GMapControl";
    public static final String COMPONENT_FAMILY = "com.icesoft.faces.GMapControl";
    private String name;
    private String localName;
    private String position;
    private transient Object[] values;

    public GMapControl() {
        this.setRendererType(null);
    }

    public String getFamily() {
        return "com.icesoft.faces.GMapControl";
    }

    public String getComponentType() {
        return "com.icesoft.faces.GMapControl";
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        ValueBinding vb = this.getValueBinding("name");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "panControl";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPosition() {
        if (this.position != null) {
            return this.position;
        }
        ValueBinding vb = this.getValueBinding("position");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "G_ANCHOR_TOP_RIGHT";
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        String currentName = this.getName();
        String mapClientId = this.getParent().getClientId(context);
        if (!this.isRendered()) {
            this.removeControl(context, mapClientId);
            return;
        }
        if (this.localName != null && !this.localName.equalsIgnoreCase(currentName)) {
            this.removeControl(context, mapClientId);
        }
        this.localName = currentName;
        JavascriptContext.addJavascriptCall((FacesContext)context, (String)("Ice.GoogleMap.addControl('" + mapClientId + "', '" + currentName + "');"));
    }

    private void removeControl(FacesContext facesContext, String mapId) {
        JavascriptContext.addJavascriptCall((FacesContext)facesContext, (String)("Ice.GoogleMap.removeControl('" + mapId + "', '" + this.localName + "');"));
    }

    public void restoreState(FacesContext context, Object state) {
        this.values = (Object[])state;
        super.restoreState(context, this.values[0]);
        this.name = (String)this.values[1];
        this.localName = (String)this.values[2];
        this.position = (String)this.values[3];
    }

    public Object saveState(FacesContext context) {
        if (this.values == null) {
            this.values = new Object[4];
        }
        this.values[0] = super.saveState(context);
        this.values[1] = this.name;
        this.values[2] = this.localName;
        this.values[3] = this.position;
        return this.values;
    }
}

