/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.gmap;

import com.icesoft.faces.component.gmap.GMapLatLng;
import com.icesoft.faces.component.gmap.GMapLatLngs;
import com.icesoft.faces.context.effects.JavascriptContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class GMapMarker
extends UIPanel {
    public static final String COMPONENT_TYPE = "com.icesoft.faces.GMapMarker";
    public static final String COMPONENT_FAMILY = "com.icesoft.faces.GMapMarker";
    private Boolean draggable;
    private String longitude;
    private String latitude;
    private transient String oldLongitude;
    private transient String oldLatitude;
    private List point = new ArrayList();
    private transient Object[] values;

    public GMapMarker() {
        this.setRendererType(null);
    }

    public String getFamily() {
        return "com.icesoft.faces.GMapMarker";
    }

    public String getComponentType() {
        return "com.icesoft.faces.GMapMarker";
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.setRendererType(null);
        super.encodeBegin(context);
        String currentLat = this.getLatitude();
        String currentLon = this.getLongitude();
        if (currentLat != null && currentLon != null && currentLat.length() > 0 && currentLon.length() > 0) {
            if (!currentLat.equals(this.oldLatitude) || !currentLon.equals(this.oldLongitude)) {
                JavascriptContext.addJavascriptCall((FacesContext)context, (String)("Ice.GoogleMap.removeMarker('" + this.getParent().getClientId(context) + "', '" + this.getClientId(context) + "');"));
                JavascriptContext.addJavascriptCall((FacesContext)context, (String)("Ice.GoogleMap.addMarker('" + this.getParent().getClientId(context) + "', '" + this.getClientId(context) + "', " + "'new google.maps.Marker({map:map, position:new google.maps.LatLng(" + currentLat + "," + currentLon + "), draggable:" + this.isDraggable() + "})');"));
            }
            this.oldLatitude = currentLat;
            this.oldLongitude = currentLon;
        }
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (this.getChildCount() == 0) {
            return;
        }
        Iterator kids = this.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.encodeBegin(context);
            if (kid.getRendersChildren()) {
                kid.encodeChildren(context);
            }
            kid.encodeEnd(context);
            if (kid instanceof GMapLatLng) {
                String call = kid.getAttributes().get("latLngScript").toString();
                if (call.endsWith("changed") || !kid.isRendered() || !this.isRendered()) {
                    call = call.substring(0, call.length() - "changed".length());
                    JavascriptContext.addJavascriptCall((FacesContext)context, (String)("Ice.GoogleMap.removeMarker('" + this.getParent().getClientId(context) + "', '" + kid.getClientId(context) + "');"));
                }
                if (!kid.isRendered() || !this.isRendered()) continue;
                JavascriptContext.addJavascriptCall((FacesContext)context, (String)("Ice.GoogleMap.addMarker('" + this.getParent().getClientId(context) + "', '" + kid.getClientId(context) + "', 'new google.maps.Marker({map:map, position:" + call + ", draggable:true})');"));
                continue;
            }
            if (!(kid instanceof GMapLatLngs)) continue;
            Iterator it = this.point.iterator();
            while (it.hasNext()) {
                JavascriptContext.addJavascriptCall((FacesContext)context, (String)("Ice.GoogleMap.removeMarker('" + this.getParent().getClientId(context) + "', '" + it.next() + "');"));
            }
            this.point.clear();
            if (!kid.isRendered() || !this.isRendered()) continue;
            StringTokenizer st = new StringTokenizer(kid.getAttributes().get("latLngsScript").toString(), ";");
            while (st.hasMoreTokens()) {
                String[] scriptInfo = st.nextToken().split("kid-id");
                String call = scriptInfo[0];
                String latLngId = scriptInfo[1];
                this.point.add(latLngId);
                JavascriptContext.addJavascriptCall((FacesContext)context, (String)("Ice.GoogleMap.addMarker('" + this.getParent().getClientId(context) + "', '" + latLngId + "', 'new google.maps.Marker({map:map, position:" + call + ", draggable:true})');"));
            }
        }
    }

    public boolean isDraggable() {
        if (this.draggable != null) {
            return this.draggable;
        }
        ValueBinding vb = this.getValueBinding("draggable");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setDraggable(boolean draggable) {
        this.draggable = new Boolean(draggable);
    }

    public String getLongitude() {
        if (this.longitude != null) {
            return this.longitude;
        }
        ValueBinding vb = this.getValueBinding("longitude");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public String getLatitude() {
        if (this.latitude != null) {
            return this.latitude;
        }
        ValueBinding vb = this.getValueBinding("latitude");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public void restoreState(FacesContext context, Object state) {
        this.values = (Object[])state;
        super.restoreState(context, this.values[0]);
        this.latitude = (String)this.values[1];
        this.longitude = (String)this.values[2];
        this.draggable = (Boolean)this.values[3];
        this.point = (List)this.values[4];
    }

    public Object saveState(FacesContext context) {
        if (this.values == null) {
            this.values = new Object[5];
        }
        this.values[0] = super.saveState(context);
        this.values[1] = this.latitude;
        this.values[2] = this.longitude;
        this.values[3] = this.draggable;
        this.values[4] = this.point;
        return this.values;
    }

    public boolean isRendered() {
        boolean rendered = super.isRendered();
        if (!rendered) {
            Iterator kids = this.getChildren().iterator();
            FacesContext context = FacesContext.getCurrentInstance();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                if (kid instanceof GMapLatLng) {
                    JavascriptContext.addJavascriptCall((FacesContext)context, (String)("Ice.GoogleMap.removeMarker('" + this.getParent().getClientId(context) + "', '" + kid.getClientId(context) + "');"));
                    continue;
                }
                if (!(kid instanceof GMapLatLngs)) continue;
                Iterator it = this.point.iterator();
                while (it.hasNext()) {
                    JavascriptContext.addJavascriptCall((FacesContext)context, (String)("Ice.GoogleMap.removeMarker('" + this.getParent().getClientId(context) + "', '" + it.next() + "');"));
                }
            }
        }
        return rendered;
    }
}

