/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.ImageStream;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.graphics.ImagePool;
import org.icepdf.core.pobjects.graphics.ImageReference;

public class InlineImageStreamReference
extends ImageReference {
    private static final Logger logger = Logger.getLogger(InlineImageStreamReference.class.toString());

    public InlineImageStreamReference(ImageStream imageStream, Color fillColor, Resources resources) {
        super(imageStream, fillColor, resources);
        ImagePool imagePool = imageStream.getLibrary().getImagePool();
        if (useProxy && imagePool.get(this.reference) == null) {
            imagePool.execute(this);
        } else if (!useProxy && imagePool.get(this.reference) == null) {
            this.run();
        }
    }

    public int getWidth() {
        return this.imageStream.getWidth();
    }

    public int getHeight() {
        return this.imageStream.getHeight();
    }

    public BufferedImage getImage() {
        if (this.image == null) {
            this.image = this.createImage();
        }
        return this.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.lock.lock();
        try {
            this.image = this.imageStream.getImage(this.fillColor, this.resources);
        }
        catch (Throwable e) {
            logger.warning("Error loading image: " + this.imageStream.getPObjectReference() + " " + this.imageStream.toString());
        }
        finally {
            this.lock.unlock();
        }
    }
}

