/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.awt.geom.Rectangle2D;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Catalog;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.PTrailer;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.StateManager;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.fonts.Font;
import org.icepdf.core.pobjects.fonts.FontDescriptor;
import org.icepdf.core.pobjects.graphics.ICCBased;
import org.icepdf.core.pobjects.graphics.ImagePool;
import org.icepdf.core.pobjects.security.SecurityManager;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.LazyObjectLoader;

public class Library {
    private static final Logger log = Logger.getLogger(Library.class.toString());
    protected static ThreadPoolExecutor commonThreadPool;
    protected static int maxPoolThreads;
    private static final long KEEP_ALIVE_TIME = 10L;
    private LazyObjectLoader lazyObjectLoader;
    private ConcurrentHashMap<Reference, SoftReference<Object>> refs = new ConcurrentHashMap(1024);
    private ConcurrentHashMap<Reference, SoftReference<ICCBased>> lookupReference2ICCBased = new ConcurrentHashMap(256);
    private Catalog catalog;
    public SecurityManager securityManager;
    public StateManager stateManager;
    private boolean isEncrypted;
    private boolean isLinearTraversal;
    private ImagePool imagePool = new ImagePool();

    public void setLazyObjectLoader(LazyObjectLoader lol) {
        this.lazyObjectLoader = lol;
    }

    public PTrailer getTrailerByFilePosition(long position) {
        if (this.lazyObjectLoader == null) {
            return null;
        }
        return this.lazyObjectLoader.loadTrailer(position);
    }

    public Object getObject(Reference reference) {
        Object ob;
        while (true) {
            SoftReference<Object> obRef;
            Object object = ob = (obRef = this.refs.get(reference)) != null ? obRef.get() : null;
            if (ob == null && this.lazyObjectLoader != null) {
                ob = this.lazyObjectLoader.loadObject(reference);
            }
            if (ob instanceof PObject) {
                return ((PObject)ob).getObject();
            }
            if (!(ob instanceof Reference)) break;
            reference = (Reference)ob;
        }
        return ob;
    }

    private void printObjectDebug(Object ob) {
        if (ob == null) {
            log.finer("null object found");
        } else if (ob instanceof PObject) {
            PObject tmp = (PObject)ob;
            log.finer(tmp.getReference() + " " + tmp.toString());
        } else if (ob instanceof Dictionary) {
            Dictionary tmp = (Dictionary)ob;
            log.finer(tmp.getPObjectReference() + " " + tmp.toString());
        } else {
            log.finer(ob.getClass() + " " + ob.toString());
        }
    }

    public Object getObject(HashMap dictionaryEntries, Name key) {
        if (dictionaryEntries == null) {
            return null;
        }
        Object o = dictionaryEntries.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Reference) {
            o = this.getObject((Reference)o);
        }
        return o;
    }

    public boolean isReference(HashMap dictionaryEntries, Name key) {
        return dictionaryEntries != null && dictionaryEntries.get(key) instanceof Reference;
    }

    public Reference getReference(HashMap dictionaryEntries, Name key) {
        Object ref = dictionaryEntries.get(key);
        if (ref instanceof Reference) {
            return (Reference)ref;
        }
        return null;
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public void setStateManager(StateManager stateManager) {
        this.stateManager = stateManager;
    }

    public Object getObject(Object referenceObject) {
        if (referenceObject instanceof Reference) {
            return this.getObject((Reference)referenceObject);
        }
        return referenceObject;
    }

    public boolean isValidEntry(HashMap dictionaryEntries, Name key) {
        if (dictionaryEntries == null) {
            return false;
        }
        Object o = dictionaryEntries.get(key);
        return o != null && (!(o instanceof Reference) || this.isValidEntry((Reference)o));
    }

    public boolean isValidEntry(Reference reference) {
        SoftReference<Object> ob = this.refs.get(reference);
        return ob != null && ob.get() != null || this.lazyObjectLoader != null && this.lazyObjectLoader.haveEntry(reference);
    }

    public Number getNumber(HashMap dictionaryEntries, Name key) {
        Object o = this.getObject(dictionaryEntries, key);
        if (o instanceof Number) {
            return (Number)o;
        }
        return null;
    }

    public Boolean getBoolean(HashMap dictionaryEntries, Name key) {
        Object o = this.getObject(dictionaryEntries, key);
        if (o instanceof String) {
            return Boolean.valueOf((String)o);
        }
        return o instanceof Boolean && (Boolean)o != false;
    }

    public float getFloat(HashMap dictionaryEntries, Name key) {
        Number n = this.getNumber(dictionaryEntries, key);
        return n != null ? n.floatValue() : 0.0f;
    }

    public int getInt(HashMap dictionaryEntries, Name key) {
        Number n = this.getNumber(dictionaryEntries, key);
        return n != null ? n.intValue() : 0;
    }

    public long getLong(HashMap dictionaryEntries, Name key) {
        Number n = this.getNumber(dictionaryEntries, key);
        return n != null ? n.longValue() : 0L;
    }

    public Name getName(HashMap dictionaryEntries, Name key) {
        Object o = this.getObject(dictionaryEntries, key);
        if (o != null && o instanceof Name) {
            return (Name)o;
        }
        return null;
    }

    public String getString(HashMap dictionaryEntries, Name key) {
        Object o = this.getObject(dictionaryEntries, key);
        if (o != null) {
            if (o instanceof String) {
                return (String)o;
            }
            if (o instanceof StringObject) {
                return ((StringObject)o).getDecryptedLiteralString(this.securityManager);
            }
            if (o instanceof Name) {
                return ((Name)o).getName();
            }
        }
        return null;
    }

    public HashMap getDictionary(HashMap dictionaryEntries, Name key) {
        Object o = this.getObject(dictionaryEntries, key);
        if (o instanceof HashMap) {
            return (HashMap)o;
        }
        if (o instanceof List) {
            List v = (List)o;
            HashMap h1 = new HashMap();
            for (Object o1 : v) {
                if (!(o1 instanceof HashMap)) continue;
                h1.putAll((HashMap)o1);
            }
            return h1;
        }
        return null;
    }

    public List getArray(HashMap dictionaryEntries, Name key) {
        Object o = this.getObject(dictionaryEntries, key);
        if (o instanceof List) {
            return (List)o;
        }
        return null;
    }

    public Rectangle2D.Float getRectangle(HashMap dictionaryEntries, Name key) {
        List v = (List)this.getObject(dictionaryEntries, key);
        if (v != null) {
            return new PRectangle(v).toJava2dCoordinates();
        }
        return null;
    }

    public ICCBased getICCBased(Reference ref) {
        Object obj;
        ICCBased cs = null;
        SoftReference<ICCBased> csRef = this.lookupReference2ICCBased.get(ref);
        if (csRef != null) {
            cs = csRef.get();
        }
        if (cs == null && (obj = this.getObject(ref)) instanceof Stream) {
            Stream stream = (Stream)obj;
            cs = new ICCBased(this, stream);
            this.lookupReference2ICCBased.put(ref, new SoftReference<ICCBased>(cs));
        }
        return cs;
    }

    public Resources getResources(HashMap dictionaryEntries, Name key) {
        if (dictionaryEntries == null) {
            return null;
        }
        Object ob = dictionaryEntries.get(key);
        if (ob == null) {
            return null;
        }
        if (ob instanceof Resources) {
            return (Resources)ob;
        }
        if (ob instanceof Reference) {
            Reference reference = (Reference)ob;
            return this.getResources(reference);
        }
        if (ob instanceof HashMap) {
            HashMap ht = (HashMap)ob;
            Resources resources = new Resources(this, ht);
            dictionaryEntries.put(key, resources);
            return resources;
        }
        return null;
    }

    public Resources getResources(Reference reference) {
        Object object = this.getObject(reference);
        if (object instanceof Resources) {
            return (Resources)object;
        }
        if (object instanceof HashMap) {
            HashMap ht = (HashMap)object;
            Resources resources = new Resources(this, ht);
            this.addObject(resources, reference);
            return resources;
        }
        return null;
    }

    public void addObject(Object object, Reference objectReference) {
        this.refs.put(objectReference, new SoftReference<Object>(object));
    }

    public void removeObject(Reference objetReference) {
        if (objetReference != null) {
            this.refs.remove(objetReference);
        }
    }

    public Reference getObjectReference(HashMap dictionaryEntries, Name key) {
        if (dictionaryEntries == null) {
            return null;
        }
        Object o = dictionaryEntries.get(key);
        if (o == null) {
            return null;
        }
        Reference currentRef = null;
        while (o != null && o instanceof Reference) {
            currentRef = (Reference)o;
            o = this.getObject(currentRef);
        }
        return currentRef;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public void setEncrypted(boolean flag) {
        this.isEncrypted = flag;
    }

    public void setLinearTraversal() {
        this.isLinearTraversal = true;
    }

    public boolean isLinearTraversal() {
        return this.isLinearTraversal;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(Catalog c) {
        this.catalog = c;
    }

    public void disposeFontResources() {
        Set test = this.refs.keySet();
        for (Reference ref : test) {
            Object tmp;
            SoftReference<Object> reference = this.refs.get(ref);
            Object object = tmp = reference != null ? reference.get() : null;
            if (!(tmp instanceof Font) && !(tmp instanceof FontDescriptor)) continue;
            this.refs.remove(ref);
        }
    }

    public ImagePool getImagePool() {
        return this.imagePool;
    }

    public static void initializeThreadPool() {
        log.fine("Starting ICEpdf Thread Pool: " + maxPoolThreads + " threads.");
        commonThreadPool = new ThreadPoolExecutor(maxPoolThreads, maxPoolThreads, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        commonThreadPool.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable command) {
                Thread newThread = new Thread(command);
                newThread.setName("ICEpdf-thread-pool");
                newThread.setPriority(5);
                newThread.setDaemon(true);
                return newThread;
            }
        });
    }

    public static void shutdownThreadPool() {
        commonThreadPool.purge();
        commonThreadPool.shutdownNow();
    }

    public static void execute(Runnable runnable) {
        try {
            commonThreadPool.execute(runnable);
        }
        catch (RejectedExecutionException e) {
            log.severe("ICEpdf Common Thread Pool was shutdown!");
        }
    }

    static {
        try {
            maxPoolThreads = Defs.intProperty("org.icepdf.core.library.threadPoolSize", 4);
            if (maxPoolThreads < 1) {
                maxPoolThreads = 4;
            }
        }
        catch (NumberFormatException e) {
            log.warning("Error reading buffered scale factor");
        }
        log.fine("Starting ICEpdf Thread Pool: " + maxPoolThreads + " threads.");
        Library.initializeThreadPool();
    }
}

