/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.util.Defs;

public class ImagePool {
    private static final Logger log = Logger.getLogger(ImagePool.class.toString());
    private final Map<Reference, BufferedImage> fCache = Collections.synchronizedMap(new WeakHashMap(50));
    private static boolean enabled = Defs.booleanProperty("org.icepdf.core.views.imagePoolEnabled", true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Reference ref, BufferedImage image) {
        if (enabled) {
            Map<Reference, BufferedImage> map = this.fCache;
            synchronized (map) {
                this.fCache.put(new Reference(ref.getObjectNumber(), ref.getGenerationNumber()), image);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage get(Reference ref) {
        if (enabled) {
            Map<Reference, BufferedImage> map = this.fCache;
            synchronized (map) {
                return this.fCache.get(ref);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Reference ref) {
        if (enabled) {
            Map<Reference, BufferedImage> map = this.fCache;
            synchronized (map) {
                return this.fCache.containsKey(ref);
            }
        }
        return false;
    }
}

