/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.icepdf.core.pobjects.ImageStream;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.graphics.CachedImageReference;
import org.icepdf.core.pobjects.graphics.ImageReference;
import org.icepdf.core.pobjects.graphics.ImageStreamReference;
import org.icepdf.core.pobjects.graphics.ScaledImageReference;

class MipMappedImageReference
extends ImageReference {
    private ArrayList<ImageReference> images = new ArrayList();

    protected MipMappedImageReference(ImageStream imageStream, Color fillColor, Resources resources, int imageIndex, Page page) {
        super(imageStream, fillColor, resources, imageIndex, page);
        CachedImageReference imageReference = new ImageStreamReference(imageStream, fillColor, resources, imageIndex, page);
        this.images.add(imageReference);
        int width = ((ImageReference)imageReference).getWidth();
        int height = ((ImageReference)imageReference).getHeight();
        useProxy = false;
        while (width > 20 && height > 20) {
            imageReference = new ScaledImageReference(imageReference, fillColor, resources, width /= 2, height /= 2, imageIndex, page);
            this.images.add(imageReference);
        }
    }

    public int getWidth() {
        return this.images.get(0).getWidth();
    }

    public int getHeight() {
        return this.images.get(0).getHeight();
    }

    public BufferedImage getImage() {
        return this.images.get(0).getImage();
    }

    public void drawImage(Graphics2D aG, int aX, int aY, int aW, int aH) {
        ImageReference imageReference = this.chooseImage(aG, aX, aY, aW, aH);
        imageReference.drawImage(aG, aX, aY, aW, aH);
    }

    private ImageReference chooseImage(Graphics2D aG, int aX, int aY, int aW, int aH) {
        Point2D.Double in = new Point2D.Double(aX, aY);
        Point2D.Double p1 = new Point2D.Double();
        Point2D.Double p2 = new Point2D.Double();
        aG.getTransform().transform(in, p1);
        in.x = aW;
        aG.getTransform().transform(in, p2);
        int distSq1 = (int)Math.round(p1.distanceSq(p2));
        in.x = aX;
        in.y = aH;
        aG.getTransform().transform(in, p2);
        int distSq2 = (int)Math.round(p1.distanceSq(p2));
        int maxDistSq = Math.max(distSq1, distSq2);
        int level = 0;
        ImageReference image = this.images.get(level);
        int width = image.getWidth();
        int height = image.getHeight();
        while (level < this.images.size() - 1 && width * width / 4 > maxDistSq && height * height / 4 > maxDistSq) {
            image = this.images.get(level++);
            width = image.getWidth();
            height = image.getHeight();
        }
        return image;
    }

    public BufferedImage call() {
        return null;
    }
}

