/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics.RasterOps;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class DecodeRasterOp
implements RasterOp {
    private static final float NORMAL_DECODE_CEIL = 0.003921569f;
    private RenderingHints hints = null;
    private float[] decode;

    public DecodeRasterOp(float[] decode, RenderingHints hints) {
        this.hints = hints;
        this.decode = decode;
    }

    private static boolean isNormalDecode(float[] decode) {
        int max = decode.length;
        for (int i = 0; i < max; i += 2) {
            if (decode[i] == 0.0f && decode[i + 1] == 0.003921569f) continue;
            return false;
        }
        return true;
    }

    public WritableRaster filter(Raster src, WritableRaster dest) {
        if (DecodeRasterOp.isNormalDecode(this.decode)) {
            return (WritableRaster)src;
        }
        if (dest == null) {
            dest = src.createCompatibleWritableRaster();
        }
        byte[] srcPixels = ((DataBufferByte)src.getDataBuffer()).getData();
        byte[] destPixels = ((DataBufferByte)dest.getDataBuffer()).getData();
        int bands = src.getNumBands();
        for (int pixel = 0; pixel < srcPixels.length; pixel += bands) {
            for (int i = 0; i < bands; ++i) {
                destPixels[pixel + i] = DecodeRasterOp.normalizeComponents(srcPixels[pixel + i], this.decode, i);
            }
        }
        return dest;
    }

    public Rectangle2D getBounds2D(Raster src) {
        return null;
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster();
    }

    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = (Point2D)srcPt.clone();
        } else {
            dstPt.setLocation(srcPt);
        }
        return dstPt;
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    private static byte normalizeComponents(byte pixels, float[] decode, int i) {
        return (byte)(decode[i * 2] * 255.0f + (float)(pixels & 0xFF) * (decode[i * 2 + 1] * 255.0f));
    }
}

