/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.menubar;

import com.icesoft.faces.component.CSS_DEFAULT;
import com.icesoft.faces.component.InvalidComponentTypeException;
import com.icesoft.faces.component.ext.HtmlCommandLink;
import com.icesoft.faces.component.ext.HtmlGraphicImage;
import com.icesoft.faces.component.ext.HtmlOutputText;
import com.icesoft.faces.component.menubar.MenuBar;
import com.icesoft.faces.component.menubar.MenuItem;
import com.icesoft.faces.component.menubar.MenuItemBase;
import com.icesoft.faces.component.menubar.MenuItemRendererBase;
import com.icesoft.faces.component.menubar.MenuItemSeparator;
import com.icesoft.faces.component.menubar.MenuItems;
import com.icesoft.faces.component.menupopup.MenuPopup;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.util.CoreUtils;
import com.icesoft.util.pooling.ClientIdPool;
import java.beans.Beans;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class MenuItemRenderer
extends MenuItemRendererBase {
    private static final String HIDDEN_FIELD_NAME = "cl";
    private static final String SUB = "_sub";
    private static final String KEYWORD_NULL = "null";
    private static final String KEYWORD_THIS = "this";
    private static final String DEFAULT_IMAGEDIR = "/xmlhttp/css/xp/css-images/";
    private static final String SUBMENU_IMAGE = "submenu.gif";
    private static final String LINK_SUFFIX = "link";
    private static final String GROUP_SUFFIX = "grp";
    private static final String INDICATOR_SUFFIX = "ind";
    private static final String ICON_SUFFIX = "icn";
    private static final String OUTPUT_SUFFIX = "out";

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        String hiddenFieldName;
        MenuItemRenderer.validateParameters((FacesContext)facesContext, (UIComponent)uiComponent, null);
        if (MenuItemRenderer.isStatic((UIComponent)uiComponent)) {
            return;
        }
        String componentId = uiComponent.getClientId(facesContext);
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String hiddenFieldNameInRequestMap = (String)requestParameterMap.get(hiddenFieldName = MenuItemRenderer.deriveCommonHiddenFieldName(facesContext, (UIComponent)((MenuItem)uiComponent)));
        if (hiddenFieldNameInRequestMap == null || hiddenFieldNameInRequestMap.equals("")) {
            return;
        }
        String commandLinkClientId = componentId + ":" + LINK_SUFFIX;
        if (hiddenFieldNameInRequestMap.equals(commandLinkClientId)) {
            ActionEvent actionEvent = new ActionEvent(uiComponent);
            uiComponent.queueEvent((FacesEvent)actionEvent);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Element masterDiv;
        String style;
        Element topLevelDiv;
        if (!uiComponent.isRendered()) {
            return;
        }
        if (!(uiComponent.getParent() instanceof MenuBar) && !(uiComponent.getParent() instanceof MenuItems)) {
            throw new InvalidComponentTypeException("MenuBar expected as parent of top-level MenuItem");
        }
        uiComponent.setId(uiComponent.getId());
        MenuBar menuComponent = null;
        if (uiComponent.getParent() instanceof MenuBar) {
            menuComponent = (MenuBar)uiComponent.getParent();
        } else if (uiComponent.getParent().getParent() instanceof MenuBar) {
            menuComponent = (MenuBar)uiComponent.getParent().getParent();
        } else {
            throw new InvalidComponentTypeException("Expecting MenuBar");
        }
        boolean vertical = menuComponent.getOrientation().equalsIgnoreCase("vertical");
        MenuItemRenderer.validateParameters((FacesContext)facesContext, (UIComponent)uiComponent, (Class)MenuItemBase.class);
        DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        String clientId = uiComponent.getClientId(facesContext);
        if (!domContext.isInitialized()) {
            topLevelDiv = domContext.createRootElement("div");
            topLevelDiv.setAttribute("id", clientId);
        }
        topLevelDiv = (Element)domContext.getRootNode();
        String rootItemSubClass = CSS_DEFAULT.MENU_BAR_ITEM_STYLE;
        if (vertical) {
            rootItemSubClass = CSS_DEFAULT.MENU_BAR_VERTICAL_SUFFIX_STYLE + rootItemSubClass;
        }
        String qualifiedName = ((MenuItem)uiComponent).getUserDefinedStyleClass(menuComponent.getItemStyleClass(), rootItemSubClass);
        String call = null;
        if (uiComponent.getChildCount() > 0) {
            topLevelDiv.setAttribute("class", CoreUtils.addPortletStyleClassToQualifiedClass((String)qualifiedName, (String)rootItemSubClass, (String)"portlet-menu-cascade-item"));
            String displayEvent = "onmouseover";
            if (vertical) {
                String supermenu = menuComponent.getClientId(facesContext);
                Element parentNode = (Element)topLevelDiv.getParentNode();
                if (parentNode.getAttribute("name").equals("TOP_LEVEL_SUBMENU")) {
                    supermenu = supermenu + SUB;
                }
                call = "Ice.Menu.hideOrphanedMenusNotRelatedTo(this);" + this.expand(supermenu, clientId + SUB, KEYWORD_THIS) + "";
            } else {
                call = "Ice.Menu.hideOrphanedMenusNotRelatedTo(this);" + this.expand(KEYWORD_THIS, clientId + SUB, KEYWORD_NULL) + "";
            }
            if (menuComponent instanceof MenuPopup) {
                topLevelDiv.setAttribute(displayEvent, call);
            }
        } else {
            topLevelDiv.setAttribute("class", CoreUtils.addPortletStyleClassToQualifiedClass((String)qualifiedName, (String)rootItemSubClass, (String)"portlet-menu-item"));
            if (menuComponent instanceof MenuPopup) {
                topLevelDiv.setAttribute("onmouseover", "Ice.Menu.hideOrphanedMenusNotRelatedTo(this);");
            }
        }
        if (menuComponent instanceof MenuPopup) {
            if (((MenuPopup)menuComponent).getHideOn() != null) {
                if (((MenuPopup)menuComponent).getHideOn().equals("mouseout")) {
                    topLevelDiv.setAttribute("onmouseout", "Ice.Menu.removeHoverClasses(this);Ice.Menu.hideOnMouseOut('" + menuComponent.getClientId(facesContext) + "',event);");
                } else {
                    topLevelDiv.setAttribute("onmouseout", "Ice.Menu.removeHoverClasses(this);");
                }
            } else {
                topLevelDiv.setAttribute("onmouseout", "Ice.Menu.removeHoverClasses(this);");
            }
        } else if (!menuComponent.isDisplayOnClick()) {
            topLevelDiv.setAttribute("onmouseout", "Ice.Menu.hideOnMouseOut('" + menuComponent.getClientId(facesContext) + "',event);");
        }
        String title = ((MenuItem)uiComponent).getTitle();
        if (title != null && title.length() > 0) {
            topLevelDiv.setAttribute("title", title);
        }
        if ((style = ((MenuItem)uiComponent).getStyle()) != null && style.length() > 0) {
            topLevelDiv.setAttribute("style", style);
        }
        DOMContext.removeChildren((Node)topLevelDiv);
        String topLevelMenuId = menuComponent.getClientId(facesContext);
        for (masterDiv = topLevelDiv; masterDiv != null && !masterDiv.getAttribute("id").equals(topLevelMenuId); masterDiv = (Element)masterDiv.getParentNode()) {
        }
        this.renderAnchor(facesContext, domContext, (MenuItem)uiComponent, topLevelDiv, menuComponent, vertical);
        if (menuComponent.getStyleClass().startsWith("iceMnuPop")) {
            Element anch = (Element)topLevelDiv.getChildNodes().item(0);
            String onclick = anch.getAttribute("onclick");
            onclick = onclick.replaceAll("return false;", "Ice.Menu.hideAll(); return false;");
            anch.setAttribute("onclick", onclick);
            anch.setAttribute("onfocus", "this.parentNode.onmouseover();");
        }
        if (uiComponent.getChildCount() > 0 && ((MenuItem)uiComponent).isChildrenMenuItem()) {
            this.renderChildrenRecursive(facesContext, menuComponent, uiComponent, vertical, masterDiv);
        }
    }

    private String expand(String supermenu, String submenu, String submenuDiv) {
        if (!supermenu.equalsIgnoreCase(KEYWORD_NULL) && !supermenu.equalsIgnoreCase(KEYWORD_THIS)) {
            supermenu = "$('" + supermenu + "')";
        }
        if (!submenu.equalsIgnoreCase(KEYWORD_NULL) && !submenu.equalsIgnoreCase(KEYWORD_THIS)) {
            submenu = "$('" + submenu + "')";
        }
        if (!submenuDiv.equalsIgnoreCase(KEYWORD_NULL) && !submenuDiv.equalsIgnoreCase(KEYWORD_THIS)) {
            submenuDiv = "$('" + submenuDiv + "')";
        }
        return "Ice.Menu.show(" + supermenu + "," + submenu + "," + submenuDiv + ");";
    }

    protected static String deriveCommonHiddenFieldName(FacesContext facesContext, UIComponent uiComponent) {
        if (Beans.isDesignTime()) {
            return "";
        }
        UIComponent parentNamingContainer = MenuItemRenderer.findForm((UIComponent)uiComponent);
        String parentClientId = parentNamingContainer.getClientId(facesContext);
        String hiddenFieldName = parentClientId + ':' + "_id" + HIDDEN_FIELD_NAME;
        return hiddenFieldName;
    }

    private Element makeTopLevelAnchor(FacesContext facesContext, MenuItem menuItem, MenuBar menuBar, boolean vertical) {
        String icon;
        DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)menuItem);
        Element anchor = domContext.createElement("a");
        if (!menuItem.isDisabled()) {
            String onclick;
            String target;
            String link = menuItem.getLink();
            if (link != null && link.length() > 0) {
                anchor.setAttribute("href", link);
            }
            if ((target = menuItem.getTarget()) != null && target.length() > 0) {
                anchor.setAttribute("target", target);
            }
            if ((onclick = menuItem.getOnclick()) != null && onclick.length() > 0) {
                anchor.setAttribute("onclick", onclick);
            }
            if (!(menuItem.isLinkSpecified() || onclick != null && onclick.length() != 0)) {
                anchor.setAttribute("onclick", "return Ice.Menu.cancelEvent(event);");
            }
        }
        if (vertical && menuItem.getChildCount() > 0 && menuItem.isChildrenMenuItem()) {
            Element subImg = domContext.createElement("img");
            subImg.setAttribute("src", CoreUtils.resolveResourceURL((FacesContext)facesContext, (String)this.getSubMenuImage(menuBar)));
            subImg.setAttribute("style", "border:none;");
            subImg.setAttribute("class", menuBar.getSubMenuIndicatorStyleClass());
            subImg.setAttribute("alt", "");
            anchor.appendChild(subImg);
        }
        if (!menuBar.getNoIcons().equalsIgnoreCase("true") && (icon = menuItem.getSpecifiedIcon()) != null && icon.length() > 0) {
            Element iconImg = domContext.createElement("img");
            iconImg.setAttribute("src", CoreUtils.resolveResourceURL((FacesContext)facesContext, (String)icon));
            iconImg.setAttribute("style", "border:none;");
            iconImg.setAttribute("class", menuItem.getUserDefinedStyleClass(menuBar.getItemImageStyleClass(), (vertical ? CSS_DEFAULT.MENU_BAR_VERTICAL_SUFFIX_STYLE : "") + CSS_DEFAULT.MENU_BAR_ITEM_STYLE + CSS_DEFAULT.MENU_ITEM_IMAGE_STYLE));
            String alt = menuItem.getAlt();
            if (alt != null && alt.length() > 0) {
                iconImg.setAttribute("alt", alt);
            }
            anchor.appendChild(iconImg);
        }
        Element span = domContext.createElement("span");
        if (!menuItem.isDisabled()) {
            anchor.setAttribute("class", "iceLink");
        } else {
            anchor.setAttribute("class", "iceLink-dis");
        }
        span.setAttribute("class", menuItem.getUserDefinedStyleClass(menuBar.getItemLabelStyleClass(), (vertical ? CSS_DEFAULT.MENU_BAR_VERTICAL_SUFFIX_STYLE : "") + CSS_DEFAULT.MENU_BAR_ITEM_LABEL_STYLE));
        anchor.appendChild(span);
        Text text = domContext.createTextNode(menuItem.getValue().toString());
        span.appendChild(text);
        return anchor;
    }

    private Element makeAnchor(FacesContext facesContext, DOMContext domContext, MenuItem menuItem, MenuBar menuBar) {
        String icon;
        Element anchor = domContext.createElement("a");
        if (!menuItem.isDisabled()) {
            String onclick;
            String target;
            String link = menuItem.getLink();
            if (link != null && link.length() > 0) {
                anchor.setAttribute("href", link);
            }
            if ((target = menuItem.getTarget()) != null && target.length() > 0) {
                anchor.setAttribute("target", target);
            }
            if ((onclick = menuItem.getOnclick()) != null && onclick.length() > 0) {
                anchor.setAttribute("onclick", onclick);
            }
            if (!(menuItem.isLinkSpecified() || onclick != null && onclick.length() != 0)) {
                anchor.setAttribute("onclick", "return Ice.Menu.cancelEvent(event);");
            }
        }
        anchor.setAttribute("id", ClientIdPool.get((String)(menuItem.getClientId(facesContext) + ":" + LINK_SUFFIX)));
        if (menuItem.getChildCount() > 0 && menuItem.isChildrenMenuItem()) {
            Element subImg = domContext.createElement("img");
            subImg.setAttribute("src", CoreUtils.resolveResourceURL((FacesContext)facesContext, (String)this.getSubMenuImage(menuBar)));
            subImg.setAttribute("style", "border:none;");
            subImg.setAttribute("class", menuBar.getSubMenuIndicatorStyleClass());
            subImg.setAttribute("alt", "");
            anchor.appendChild(subImg);
        }
        if (!menuBar.getNoIcons().equalsIgnoreCase("true") && (icon = menuItem.getIcon()) != null && icon.length() > 0) {
            Element iconImg = domContext.createElement("img");
            iconImg.setAttribute("src", CoreUtils.resolveResourceURL((FacesContext)facesContext, (String)icon));
            iconImg.setAttribute("style", "border:none;");
            iconImg.setAttribute("class", menuItem.getImageStyleClass());
            String alt = menuItem.getAlt();
            if (alt != null && alt.length() > 0) {
                iconImg.setAttribute("alt", alt);
            }
            anchor.appendChild(iconImg);
        }
        Element span = domContext.createElement("span");
        if (!menuItem.isDisabled()) {
            anchor.setAttribute("class", "iceLink");
        } else {
            anchor.setAttribute("class", "iceLink-dis");
        }
        span.setAttribute("class", menuItem.getLabelStyleClass());
        anchor.appendChild(span);
        Text text = domContext.createTextNode(menuItem.getValue().toString());
        span.appendChild(text);
        return anchor;
    }

    private void renderChildrenRecursive(FacesContext facesContext, MenuBar menuComponent, UIComponent uiComponent, boolean vertical, Element masterDiv) {
        UIComponent nextSubMenuItem;
        int childIndex;
        if (!uiComponent.isRendered()) {
            return;
        }
        DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        Element submenuDiv = domContext.createElement("div");
        String subMenuDivId = uiComponent.getClientId(facesContext) + SUB;
        submenuDiv.setAttribute("id", subMenuDivId);
        submenuDiv.setAttribute("class", menuComponent.getSubMenuStyleClass());
        submenuDiv.setAttribute("style", "display:none");
        masterDiv.appendChild(submenuDiv);
        boolean disabled = false;
        Boolean disObj = (Boolean)uiComponent.getAttributes().get("disabled");
        if (disObj != null && disObj.booleanValue()) {
            disabled = true;
        }
        for (childIndex = 0; childIndex < uiComponent.getChildCount(); ++childIndex) {
            nextSubMenuItem = (UIComponent)uiComponent.getChildren().get(childIndex);
            if (nextSubMenuItem instanceof MenuItem) {
                this.renderSubMenuItem(facesContext, domContext, (MenuItem)nextSubMenuItem, menuComponent, disabled, vertical, submenuDiv, subMenuDivId);
                continue;
            }
            if (nextSubMenuItem instanceof MenuItems) {
                this.renderSubMenuItems(facesContext, domContext, (MenuItems)nextSubMenuItem, menuComponent, disabled, vertical, submenuDiv, subMenuDivId);
                continue;
            }
            if (!(nextSubMenuItem instanceof MenuItemSeparator)) continue;
            this.renderSubMenuItemSeparator(domContext, (MenuItemSeparator)nextSubMenuItem, submenuDiv);
        }
        for (childIndex = 0; childIndex < uiComponent.getChildCount(); ++childIndex) {
            MenuItems mis;
            List kids;
            nextSubMenuItem = (UIComponent)uiComponent.getChildren().get(childIndex);
            if (nextSubMenuItem instanceof MenuItem) {
                MenuItem mi = (MenuItem)nextSubMenuItem;
                if (!mi.isChildrenMenuItem()) continue;
                this.renderChildrenRecursive(facesContext, menuComponent, (UIComponent)mi, vertical, masterDiv);
                continue;
            }
            if (!(nextSubMenuItem instanceof MenuItems) || (kids = (mis = (MenuItems)nextSubMenuItem).prepareChildren()) == null) continue;
            for (int kidIndex = 0; kidIndex < kids.size(); ++kidIndex) {
                MenuItem mi;
                UIComponent nextKid = (UIComponent)kids.get(kidIndex);
                if (!(nextKid instanceof MenuItem) || !(mi = (MenuItem)nextKid).isChildrenMenuItem()) continue;
                this.renderChildrenRecursive(facesContext, menuComponent, (UIComponent)mi, vertical, masterDiv);
            }
        }
    }

    private void renderSubMenuItemSeparator(DOMContext domContext, MenuItemSeparator nextSubMenuItem, Element submenuDiv) {
        if (!nextSubMenuItem.isRendered()) {
            return;
        }
        Element subMenuItemDiv = domContext.createElement("div");
        submenuDiv.appendChild(subMenuItemDiv);
        this.renderSeparatorDiv(domContext, subMenuItemDiv, nextSubMenuItem);
    }

    private void renderSubMenuItems(FacesContext facesContext, DOMContext domContext, MenuItems nextSubMenuItems, MenuBar menuComponent, boolean disabled, boolean vertical, Element submenuDiv, String subMenuDivId) {
        List children = nextSubMenuItems.prepareChildren();
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                MenuItemBase mib = (MenuItemBase)((Object)children.get(i));
                if (mib instanceof MenuItem) {
                    this.renderSubMenuItem(facesContext, domContext, (MenuItem)mib, menuComponent, disabled, vertical, submenuDiv, subMenuDivId);
                    continue;
                }
                if (!(mib instanceof MenuItemSeparator)) continue;
                this.renderSubMenuItemSeparator(domContext, (MenuItemSeparator)mib, submenuDiv);
            }
        }
    }

    private void renderSubMenuItem(FacesContext facesContext, DOMContext domContext, MenuItem nextSubMenuItem, MenuBar menuComponent, boolean disabled, boolean vertical, Element submenuDiv, String subMenuDivId) {
        String style;
        if (!nextSubMenuItem.isRendered()) {
            return;
        }
        nextSubMenuItem.setId(nextSubMenuItem.getId());
        String call = null;
        Element subMenuItemDiv = domContext.createElement("div");
        submenuDiv.appendChild(subMenuItemDiv);
        String qualifiedName = nextSubMenuItem.getStyleClass();
        String subMenuItemClientId = nextSubMenuItem.getClientId(facesContext);
        subMenuItemDiv.setAttribute("id", subMenuItemClientId);
        if (nextSubMenuItem.isChildrenMenuItem()) {
            call = "Ice.Menu.hideOrphanedMenusNotRelatedTo(this);" + this.expand(subMenuDivId, subMenuItemClientId + SUB, KEYWORD_THIS) + "";
            subMenuItemDiv.setAttribute("class", CoreUtils.addPortletStyleClassToQualifiedClass((String)qualifiedName, (String)qualifiedName, (String)"portlet-menu-cascade-item"));
            subMenuItemDiv.setAttribute("onmouseover", call);
        } else {
            subMenuItemDiv.setAttribute("class", CoreUtils.addPortletStyleClassToQualifiedClass((String)qualifiedName, (String)qualifiedName, (String)"portlet-menu-item"));
            subMenuItemDiv.setAttribute("onmouseover", "Ice.Menu.hideOrphanedMenusNotRelatedTo(this);");
        }
        if (menuComponent instanceof MenuPopup) {
            if (((MenuPopup)menuComponent).getHideOn() != null) {
                if (((MenuPopup)menuComponent).getHideOn().equals("mouseout")) {
                    subMenuItemDiv.setAttribute("onmouseout", "Ice.Menu.removeHoverClasses(this);Ice.Menu.hideOnMouseOut('" + menuComponent.getClientId(facesContext) + "',event);");
                } else {
                    subMenuItemDiv.setAttribute("onmouseout", "Ice.Menu.removeHoverClasses(this);");
                }
            } else {
                subMenuItemDiv.setAttribute("onmouseout", "Ice.Menu.removeHoverClasses(this);");
            }
        } else if (!menuComponent.isDisplayOnClick()) {
            subMenuItemDiv.setAttribute("onmouseout", "Ice.Menu.hideOnMouseOut('" + menuComponent.getClientId(facesContext) + "',event);");
        }
        String title = nextSubMenuItem.getTitle();
        if (title != null && title.length() > 0) {
            subMenuItemDiv.setAttribute("title", title);
        }
        if ((style = nextSubMenuItem.getStyle()) != null && style.length() > 0) {
            subMenuItemDiv.setAttribute("style", style);
        }
        if (disabled) {
            nextSubMenuItem.setDisabled(disabled);
        }
        this.renderAnchor(facesContext, domContext, nextSubMenuItem, subMenuItemDiv, menuComponent, vertical);
        Element anch = (Element)subMenuItemDiv.getChildNodes().item(0);
        if (call != null) {
            anch.setAttribute("onfocus", "if( $('" + subMenuItemDiv.getAttribute("id") + "_sub').style.display == 'none') { " + call + "}");
        }
        if (menuComponent.getStyleClass().startsWith("iceMnuPop")) {
            String onclick = anch.getAttribute("onclick");
            onclick = onclick.replaceAll("return false;", "Ice.Menu.hideAll(); return false;");
            anch.setAttribute("onclick", onclick);
        }
    }

    private void renderAnchor(FacesContext facesContext, DOMContext domContext, MenuItem nextSubMenuItem, Element subMenuItemDiv, MenuBar menuComponent, boolean vertical) {
        if (!nextSubMenuItem.isRendered()) {
            return;
        }
        if (nextSubMenuItem.getParent() instanceof MenuBar || nextSubMenuItem.getParent() instanceof MenuItems && nextSubMenuItem.getParent().getParent() instanceof MenuBar) {
            if (nextSubMenuItem.hasActionOrActionListener()) {
                HtmlCommandLink link = new HtmlCommandLink();
                if (nextSubMenuItem.isDisabled()) {
                    link.setDisabled(true);
                } else {
                    ActionListener[] actionListeners;
                    MethodBinding actionListener;
                    MethodBinding action = nextSubMenuItem.getAction();
                    if (action != null) {
                        link.setAction(action);
                    }
                    if ((actionListener = nextSubMenuItem.getActionListener()) != null) {
                        link.setActionListener(actionListener);
                    }
                    if ((actionListeners = nextSubMenuItem.getActionListeners()) != null) {
                        for (int i = 0; i < actionListeners.length; ++i) {
                            link.removeActionListener(actionListeners[i]);
                            link.addActionListener(actionListeners[i]);
                        }
                    }
                }
                link.setOnclick(nextSubMenuItem.getOnclick());
                link.setValue(nextSubMenuItem.getValue());
                link.setParent((UIComponent)nextSubMenuItem);
                link.setId(LINK_SUFFIX);
                Node lastCursorParent = domContext.getCursorParent();
                domContext.setCursorParent((Node)subMenuItemDiv);
                this.addChildrenToLink(link, nextSubMenuItem, menuComponent, true, !vertical);
                nextSubMenuItem.addParameter((UIComponent)link);
                try {
                    MenuItemRenderer.encodeParentAndChildren((FacesContext)facesContext, (UIComponent)link);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                domContext.setCursorParent(lastCursorParent);
            } else {
                Element anchor = this.makeTopLevelAnchor(facesContext, nextSubMenuItem, menuComponent, vertical);
                subMenuItemDiv.appendChild(anchor);
            }
        } else if (nextSubMenuItem.hasActionOrActionListener()) {
            HtmlCommandLink link = new HtmlCommandLink();
            if (nextSubMenuItem.isDisabled()) {
                link.setDisabled(true);
            } else {
                ActionListener[] actionListeners;
                MethodBinding actionListener;
                MethodBinding action = nextSubMenuItem.getAction();
                if (action != null) {
                    link.setAction(action);
                }
                if ((actionListener = nextSubMenuItem.getActionListener()) != null) {
                    link.setActionListener(actionListener);
                }
                if ((actionListeners = nextSubMenuItem.getActionListeners()) != null) {
                    for (int i = 0; i < actionListeners.length; ++i) {
                        link.removeActionListener(actionListeners[i]);
                        link.addActionListener(actionListeners[i]);
                    }
                }
            }
            link.setOnclick(nextSubMenuItem.getOnclick());
            link.setValue(nextSubMenuItem.getValue());
            link.setParent((UIComponent)nextSubMenuItem);
            link.setId(LINK_SUFFIX);
            Node lastCursorParent = domContext.getCursorParent();
            domContext.setCursorParent((Node)subMenuItemDiv);
            this.addChildrenToLink(link, nextSubMenuItem, menuComponent, false, !vertical);
            nextSubMenuItem.addParameter((UIComponent)link);
            try {
                MenuItemRenderer.encodeParentAndChildren((FacesContext)facesContext, (UIComponent)link);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            domContext.setCursorParent(lastCursorParent);
        } else {
            Element anchor = this.makeAnchor(facesContext, domContext, nextSubMenuItem, menuComponent);
            subMenuItemDiv.appendChild(anchor);
        }
    }

    private void addChildrenToLink(HtmlCommandLink link, MenuItem nextSubMenuItem, MenuBar menuComponent, boolean topLevel, boolean horizontal) {
        if (!(topLevel && horizontal || nextSubMenuItem.getChildCount() <= 0 || !nextSubMenuItem.isChildrenMenuItem())) {
            HtmlGraphicImage image = new HtmlGraphicImage();
            image.setId(INDICATOR_SUFFIX);
            image.setUrl(this.getSubMenuImage(menuComponent));
            image.setStyle("border:none;");
            image.setStyleClass(menuComponent.getSubMenuIndicatorStyleClass());
            link.getChildren().add(image);
        }
        if (!menuComponent.getNoIcons().equalsIgnoreCase("true")) {
            String icon = null;
            icon = topLevel ? nextSubMenuItem.getSpecifiedIcon() : nextSubMenuItem.getIcon();
            if (icon != null && icon.length() > 0) {
                HtmlGraphicImage image = new HtmlGraphicImage();
                image.setId(ICON_SUFFIX);
                image.setUrl(icon);
                image.setStyle("border:none;");
                image.setStyleClass(nextSubMenuItem.getImageStyleClass());
                String alt = nextSubMenuItem.getAlt();
                if (alt != null && alt.length() > 0) {
                    image.setAlt(alt);
                }
                link.getChildren().add(image);
            }
        }
        HtmlOutputText outputText = new HtmlOutputText();
        outputText.setId(OUTPUT_SUFFIX);
        outputText.setValue(link.getValue());
        outputText.setStyleClass(nextSubMenuItem.getLabelStyleClass());
        link.setValue("");
        link.getChildren().add(outputText);
    }

    private void renderSeparatorDiv(DOMContext domContext, Element parent, MenuItemSeparator menuItemSeparator) {
        Element hr = domContext.createElement("hr");
        parent.setAttribute("class", menuItemSeparator.getStyleClass());
        parent.appendChild(hr);
    }

    private String getSubMenuImage(MenuBar menuComponent) {
        String customPath = null;
        customPath = menuComponent.getImageDir();
        if (customPath != null) {
            return customPath + SUBMENU_IMAGE;
        }
        return "/xmlhttp/css/xp/css-images/submenu.gif";
    }

    protected String getTextValue(UIComponent component) {
        if (component instanceof MenuItem) {
            return ((MenuItem)component).getValue().toString();
        }
        return null;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    private void examineRequest(FacesContext facesContext, UIComponent uiComponent, Map requestParameterMap, String hiddenFieldName, String hiddenValue) {
        Iterator entries = requestParameterMap.entrySet().iterator();
        System.out.println("decoding " + ((MenuItem)uiComponent).getValue());
        System.out.println("request map");
        while (entries.hasNext()) {
            Map.Entry next = entries.next();
            if (next.getKey().toString().equals("rand")) continue;
            System.out.println("[" + next.getKey().toString() + "=" + next.getValue() + "]");
        }
        System.out.println("looking for hidden field [" + hiddenFieldName + "]");
        System.out.println("client id = [" + uiComponent.getClientId(facesContext));
        System.out.println("################################################ QUEUEING for hidden field [" + hiddenValue + "]");
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DOMContext domContext = DOMContext.getDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        super.encodeEnd(facesContext, uiComponent);
    }
}

