/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.icepdf.core.io.BitStream;
import org.icepdf.core.io.SeekableInputConstrainedWrapper;
import org.icepdf.core.pobjects.ImageUtility;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.filters.CCITTFax;
import org.icepdf.core.pobjects.filters.CCITTFaxDecoder;
import org.icepdf.core.pobjects.graphics.DeviceCMYK;
import org.icepdf.core.pobjects.graphics.DeviceGray;
import org.icepdf.core.pobjects.graphics.DeviceRGB;
import org.icepdf.core.pobjects.graphics.ICCBased;
import org.icepdf.core.pobjects.graphics.Indexed;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.pobjects.graphics.Separation;
import org.icepdf.core.tag.Tagger;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;

public class ImageStream
extends Stream {
    private static final Logger logger = Logger.getLogger(ImageStream.class.toString());
    public static final Name TYPE_VALUE = new Name("Image");
    public static final Name BITSPERCOMPONENT_KEY = new Name("BitsPerComponent");
    public static final Name BPC_KEY = new Name("BPC");
    public static final Name DECODE_KEY = new Name("Decode");
    public static final Name D_KEY = new Name("D");
    public static final Name SMASK_KEY = new Name("SMask");
    public static final Name MASK_KEY = new Name("Mask");
    public static final Name JBIG2GLOBALS_KEY = new Name("JBIG2Globals");
    public static final Name DECODEPARMS_KEY = new Name("DecodeParms");
    public static final Name DP_KEY = new Name("DP");
    public static final Name K_KEY = new Name("K");
    public static final Name ENCODEDBYTEALIGN_KEY = new Name("EncodedByteAlign");
    public static final Name COLUMNS_KEY = new Name("Columns");
    public static final Name ROWS_KEY = new Name("Rows");
    public static final Name BLACKIS1_KEY = new Name("BlackIs1");
    protected static final String[] CCITTFAX_DECODE_FILTERS = new String[]{"CCITTFaxDecode", "/CCF", "CCF"};
    protected static final String[] DCT_DECODE_FILTERS = new String[]{"DCTDecode", "/DCT", "DCT"};
    protected static final String[] JBIG2_DECODE_FILTERS = new String[]{"JBIG2Decode"};
    protected static final String[] JPX_DECODE_FILTERS = new String[]{"JPXDecode"};
    private static double pageRatio = Defs.sysPropertyDouble("org.icepdf.core.pageRatio", 0.7071917808219178);
    private static boolean forceJaiccittfax = Defs.sysPropertyBoolean("org.icepdf.core.ccittfax.jai", false);
    private int width;
    private int height;

    public ImageStream(Library l, HashMap h, SeekableInputConstrainedWrapper streamInputWrapper) {
        super(l, h, streamInputWrapper);
        this.init();
    }

    public ImageStream(Library l, HashMap h, byte[] rawBytes) {
        super(l, h, rawBytes);
        this.init();
    }

    public void init() {
        this.width = this.library.getInt(this.entries, WIDTH_KEY);
        this.height = this.library.getInt(this.entries, HEIGHT_KEY);
        if (this.height == 0) {
            this.height = (int)(1.0 / pageRatio * (double)this.width);
        } else if (this.width == 0) {
            this.width = (int)(pageRatio * (double)this.height);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public BufferedImage getImage(Color fill, Resources resources) {
        int i;
        int j;
        if (Tagger.tagging) {
            Tagger.tagImage("Filter=" + this.getNormalisedFilterNames());
        }
        PColorSpace colourSpace = null;
        Object o = this.library.getObject(this.entries, COLORSPACE_KEY);
        if (resources != null) {
            colourSpace = resources.getColorSpace(o);
        }
        if (colourSpace == null) {
            colourSpace = new DeviceGray(this.library, null);
            if (Tagger.tagging) {
                Tagger.tagImage("ColorSpace_Implicit_DeviceGray");
            }
        }
        if (Tagger.tagging) {
            Tagger.tagImage("ColorSpace=" + colourSpace.getDescription());
        }
        boolean imageMask = this.isImageMask();
        if (Tagger.tagging) {
            Tagger.tagImage("ImageMask=" + imageMask);
        }
        int bitsPerComponent = this.library.getInt(this.entries, BITSPERCOMPONENT_KEY);
        if (imageMask && bitsPerComponent == 0) {
            bitsPerComponent = 1;
            if (Tagger.tagging) {
                Tagger.tagImage("BitsPerComponent_Implicit_1");
            }
        }
        if (Tagger.tagging) {
            Tagger.tagImage("BitsPerComponent=" + bitsPerComponent);
        }
        int colorSpaceCompCount = colourSpace.getNumComponents();
        int maxValue = (int)Math.pow(2.0, bitsPerComponent) - 1;
        float[] decode = new float[2 * colorSpaceCompCount];
        List decodeVec = (List)this.library.getObject(this.entries, DECODE_KEY);
        if (decodeVec == null) {
            j = 0;
            for (i = 0; i < colorSpaceCompCount; ++i) {
                decode[j++] = 0.0f;
                decode[j++] = 1.0f / (float)maxValue;
            }
            if (Tagger.tagging) {
                Tagger.tagImage("Decode_Implicit_01");
            }
        } else {
            j = 0;
            for (i = 0; i < colorSpaceCompCount; ++i) {
                float Dmin = ((Number)decodeVec.get(j)).floatValue();
                float Dmax = ((Number)decodeVec.get(j + 1)).floatValue();
                decode[j++] = Dmin;
                decode[j++] = (Dmax - Dmin) / (float)maxValue;
            }
        }
        if (Tagger.tagging) {
            Tagger.tagImage("Decode=" + Arrays.toString(decode));
        }
        BufferedImage smaskImage = null;
        BufferedImage maskImage = null;
        int[] maskMinRGB = null;
        int[] maskMaxRGB = null;
        int maskMinIndex = -1;
        int maskMaxIndex = -1;
        Object smaskObj = this.library.getObject(this.entries, SMASK_KEY);
        Object maskObj = this.library.getObject(this.entries, MASK_KEY);
        if (smaskObj instanceof Stream) {
            ImageStream smaskStream;
            if (Tagger.tagging) {
                Tagger.tagImage("SMaskStream");
            }
            if ((smaskStream = (ImageStream)smaskObj).isImageSubtype()) {
                smaskImage = smaskStream.getImage(fill, resources);
            }
        }
        if (smaskImage != null && Tagger.tagging) {
            Tagger.tagImage("SMaskImage");
        }
        if (maskObj != null && smaskImage == null) {
            if (maskObj instanceof Stream) {
                ImageStream maskStream;
                if (Tagger.tagging) {
                    Tagger.tagImage("MaskStream");
                }
                if ((maskStream = (ImageStream)maskObj).isImageSubtype() && (maskImage = maskStream.getImage(fill, resources)) != null && Tagger.tagging) {
                    Tagger.tagImage("MaskImage");
                }
            } else if (maskObj instanceof List) {
                if (Tagger.tagging) {
                    Tagger.tagImage("MaskVector");
                }
                List maskVector = (List)maskObj;
                int[] maskMinOrigCompsInt = new int[colorSpaceCompCount];
                int[] maskMaxOrigCompsInt = new int[colorSpaceCompCount];
                for (int i2 = 0; i2 < colorSpaceCompCount; ++i2) {
                    if (i2 * 2 < maskVector.size()) {
                        maskMinOrigCompsInt[i2] = ((Number)maskVector.get(i2 * 2)).intValue();
                    }
                    if (i2 * 2 + 1 >= maskVector.size()) continue;
                    maskMaxOrigCompsInt[i2] = ((Number)maskVector.get(i2 * 2 + 1)).intValue();
                }
                if (colourSpace instanceof Indexed) {
                    Indexed icolourSpace = (Indexed)colourSpace;
                    Color[] colors = icolourSpace.accessColorTable();
                    if (colors != null && maskMinOrigCompsInt.length >= 1 && maskMaxOrigCompsInt.length >= 1) {
                        maskMinIndex = maskMinOrigCompsInt[0];
                        maskMaxIndex = maskMaxOrigCompsInt[0];
                        if (maskMinIndex >= 0 && maskMinIndex < colors.length && maskMaxIndex >= 0 && maskMaxIndex < colors.length) {
                            Color minColor = colors[maskMinOrigCompsInt[0]];
                            Color maxColor = colors[maskMaxOrigCompsInt[0]];
                            maskMinRGB = new int[]{minColor.getRed(), minColor.getGreen(), minColor.getBlue()};
                            maskMaxRGB = new int[]{maxColor.getRed(), maxColor.getGreen(), maxColor.getBlue()};
                        }
                    }
                } else {
                    PColorSpace.reverseInPlace(maskMinOrigCompsInt);
                    PColorSpace.reverseInPlace(maskMaxOrigCompsInt);
                    float[] maskMinOrigComps = new float[colorSpaceCompCount];
                    float[] maskMaxOrigComps = new float[colorSpaceCompCount];
                    colourSpace.normaliseComponentsToFloats(maskMinOrigCompsInt, maskMinOrigComps, (1 << bitsPerComponent) - 1);
                    colourSpace.normaliseComponentsToFloats(maskMaxOrigCompsInt, maskMaxOrigComps, (1 << bitsPerComponent) - 1);
                    Color minColor = colourSpace.getColor(maskMinOrigComps);
                    Color maxColor = colourSpace.getColor(maskMaxOrigComps);
                    PColorSpace.reverseInPlace(maskMinOrigComps);
                    PColorSpace.reverseInPlace(maskMaxOrigComps);
                    maskMinRGB = new int[]{minColor.getRed(), minColor.getGreen(), minColor.getBlue()};
                    maskMaxRGB = new int[]{maxColor.getRed(), maxColor.getGreen(), maxColor.getBlue()};
                }
            }
        }
        BufferedImage img = this.getImage(colourSpace, fill, this.width, this.height, colorSpaceCompCount, bitsPerComponent, imageMask, decode, smaskImage, maskImage, maskMinRGB, maskMaxRGB, maskMinIndex, maskMaxIndex);
        if (Tagger.tagging) {
            Tagger.endImage(this.pObjectReference);
        }
        return img;
    }

    private BufferedImage getImage(PColorSpace colourSpace, Color fill, int width, int height, int colorSpaceCompCount, int bitsPerComponent, boolean imageMask, float[] decode, BufferedImage sMaskImage, BufferedImage maskImage, int[] maskMinRGB, int[] maskMaxRGB, int maskMinIndex, int maskMaxIndex) {
        byte[] data;
        BufferedImage decodedImage = null;
        if (this.shouldUseDCTDecode()) {
            if (Tagger.tagging) {
                Tagger.tagImage("DCTDecode");
            }
            decodedImage = this.dctDecode(width, height, colourSpace, bitsPerComponent, decode);
        } else if (this.shouldUseJBIG2Decode()) {
            if (Tagger.tagging) {
                Tagger.tagImage("JBIG2Decode");
            }
            decodedImage = this.jbig2Decode(width, height, colourSpace, bitsPerComponent);
        } else if (this.shouldUseJPXDecode()) {
            if (Tagger.tagging) {
                Tagger.tagImage("JPXDecode");
            }
            decodedImage = this.jpxDecode(width, height, colourSpace, bitsPerComponent, decode);
        } else {
            data = this.getDecodedStreamBytes(width * height * colourSpace.getNumComponents() * bitsPerComponent / 8);
            int dataLength = data.length;
            if (this.shouldUseCCITTFaxDecode()) {
                if (Tagger.tagging) {
                    Tagger.tagImage("CCITTFaxDecode");
                }
                try {
                    if (forceJaiccittfax) {
                        throw new Throwable("Forcing CCITTFAX decode via JAI");
                    }
                    data = this.ccittFaxDecode(data, width, height);
                    dataLength = data.length;
                }
                catch (Throwable e) {
                    if (Tagger.tagging) {
                        Tagger.tagImage("CCITTFaxDecode JAI");
                    }
                    decodedImage = CCITTFax.attemptDeriveBufferedImageFromBytes(this, this.library, this.entries, fill);
                }
            }
            try {
                decodedImage = ImageUtility.makeImageWithRasterFromBytes(colourSpace, fill, width, height, colorSpaceCompCount, bitsPerComponent, imageMask, decode, sMaskImage, maskImage, maskMinRGB, maskMaxRGB, maskMinIndex, maskMaxIndex, data, dataLength);
                if (decodedImage != null) {
                    return decodedImage;
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Error building image raster.", e);
            }
        }
        if (decodedImage == null) {
            data = this.getDecodedStreamBytes(width * height * colourSpace.getNumComponents() * bitsPerComponent / 8);
            decodedImage = this.parseImage(width, height, colourSpace, imageMask, fill, bitsPerComponent, decode, data);
        }
        if (imageMask) {
            decodedImage = ImageUtility.applyExplicitMask(decodedImage, fill);
        }
        if (sMaskImage != null) {
            decodedImage = ImageUtility.applyExplicitSMask(decodedImage, sMaskImage);
        }
        if (maskImage != null) {
            decodedImage = ImageUtility.applyExplicitMask(decodedImage, maskImage);
        }
        return decodedImage;
    }

    private BufferedImage dctDecode(int width, int height, PColorSpace colourSpace, int bitspercomponent, float[] decode) {
        BufferedImage tmpImage;
        ByteArrayInputStream input = this.getDecodedByteArrayInputStream();
        int MAX_BYTES_TO_READ_FOR_ENCODING = 2048;
        BufferedInputStream bufferedInput = new BufferedInputStream(input, 2048);
        bufferedInput.mark(2048);
        int jpegEncoding = 0;
        try {
            byte[] data = new byte[2048];
            int dataRead = bufferedInput.read(data);
            bufferedInput.reset();
            if (dataRead > 0) {
                jpegEncoding = ImageUtility.getJPEGEncoding(data, dataRead);
            }
        }
        catch (IOException ioe) {
            logger.log(Level.FINE, "Problem determining JPEG type: ", ioe);
        }
        if (Tagger.tagging) {
            Tagger.tagImage("DCTDecode_JpegEncoding=" + ImageUtility.JPEG_ENC_NAMES[jpegEncoding]);
        }
        if ((tmpImage = null) == null) {
            try {
                WritableRaster wr;
                JPEGImageDecoder imageDecoder = JPEGCodec.createJPEGDecoder((InputStream)bufferedInput);
                Raster r = imageDecoder.decodeAsRaster();
                WritableRaster writableRaster = wr = r instanceof WritableRaster ? (WritableRaster)r : r.createCompatibleWritableRaster();
                if (jpegEncoding == 1 && bitspercomponent == 8) {
                    ImageUtility.alterRasterRGB2PColorSpace(wr, colourSpace);
                    tmpImage = ImageUtility.makeRGBtoRGBABuffer(wr, width, height);
                } else if (jpegEncoding == 2 && bitspercomponent == 8) {
                    tmpImage = ImageUtility.alterRasterCMYK2BGRA(wr);
                } else if (jpegEncoding == 3 && bitspercomponent == 8) {
                    tmpImage = ImageUtility.alterRasterYCbCr2RGBA(wr, decode);
                } else if (jpegEncoding == 4 && bitspercomponent == 8) {
                    ImageUtility.alterRasterYCCK2CMYK(wr, decode);
                    tmpImage = ImageUtility.alterRasterCMYK2BGRA(wr);
                } else if (jpegEncoding == 5 && bitspercomponent == 8) {
                    if (!(colourSpace instanceof DeviceGray || colourSpace instanceof ICCBased || colourSpace instanceof Indexed)) {
                        if (Tagger.tagging) {
                            Tagger.tagImage("DCTDecode_JpegSubEncoding=Y");
                        }
                        ImageUtility.alterRasterY2Gray(wr, decode);
                    }
                    tmpImage = ImageUtility.makeGrayBufferedImage(wr);
                } else if (imageDecoder.getJPEGDecodeParam().getEncodedColorID() == 7) {
                    if (Tagger.tagging) {
                        Tagger.tagImage("DCTDecode_JpegSubEncoding=YCbCrA");
                    }
                    ImageUtility.alterRasterYCbCrA2RGBA(wr);
                    tmpImage = ImageUtility.makeRGBABufferedImage(wr);
                } else {
                    if (Tagger.tagging) {
                        Tagger.tagImage("DCTDecode_JpegSubEncoding=YCbCr");
                    }
                    ImageUtility.alterRasterYCbCr2RGBA(wr, decode);
                    tmpImage = ImageUtility.makeRGBBufferedImage(wr);
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Problem loading JPEG image via JPEGImageDecoder: ", e);
            }
            if (tmpImage != null && Tagger.tagging) {
                Tagger.tagImage("HandledBy=DCTDecode_SunJPEGImageDecoder");
            }
        }
        try {
            bufferedInput.close();
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error closing image stream.", e);
        }
        if (tmpImage == null) {
            try {
                Class<?> roClass;
                Method roGetAsBufferedImage;
                Object javax_media_jai_RenderedOp_op = null;
                try {
                    input = this.getDecodedByteArrayInputStream();
                    Class<?> ssClass = Class.forName("com.sun.media.jai.codec.SeekableStream");
                    Method ssWrapInputStream = ssClass.getMethod("wrapInputStream", InputStream.class, Boolean.TYPE);
                    Object com_sun_media_jai_codec_SeekableStream_s = ssWrapInputStream.invoke(null, input, Boolean.TRUE);
                    ParameterBlock pb = new ParameterBlock();
                    pb.add(com_sun_media_jai_codec_SeekableStream_s);
                    Class<?> jaiClass = Class.forName("javax.media.jai.JAI");
                    Method jaiCreate = jaiClass.getMethod("create", String.class, ParameterBlock.class);
                    javax_media_jai_RenderedOp_op = jaiCreate.invoke(null, "jpeg", pb);
                }
                catch (Exception e) {
                    logger.warning("Could not load JAI");
                }
                if (!(javax_media_jai_RenderedOp_op == null || jpegEncoding == 2 && bitspercomponent == 8 || jpegEncoding == 4 && bitspercomponent == 8 || (tmpImage = (BufferedImage)(roGetAsBufferedImage = (roClass = Class.forName("javax.media.jai.RenderedOp")).getMethod("getAsBufferedImage", new Class[0])).invoke(javax_media_jai_RenderedOp_op, new Object[0])) == null || !Tagger.tagging)) {
                    Tagger.tagImage("HandledBy=DCTDecode_JAI");
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Problem loading JPEG image via JAI: ", e);
            }
            try {
                ((InputStream)input).close();
            }
            catch (IOException e) {
                logger.log(Level.FINE, "Problem closing image stream. ", e);
            }
        }
        if (tmpImage == null) {
            try {
                Image img;
                byte[] data = this.getDecodedStreamBytes(width * height * colourSpace.getNumComponents() * bitspercomponent / 8);
                if (data != null && (img = Toolkit.getDefaultToolkit().createImage(data)) != null) {
                    tmpImage = ImageUtility.makeRGBABufferedImageFromImage(img);
                    if (Tagger.tagging) {
                        Tagger.tagImage("HandledBy=DCTDecode_ToolkitCreateImage");
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Problem loading JPEG image via Toolkit: ", e);
            }
        }
        return tmpImage;
    }

    private BufferedImage jbig2Decode(int width, int height, PColorSpace colourSpace, int bitspercomponent) {
        BufferedImage tmpImage = null;
        try {
            Class<?> jbig2DecoderClass = Class.forName("org.jpedal.jbig2.JBIG2Decoder");
            Constructor<?> jbig2DecoderClassConstructor = jbig2DecoderClass.getDeclaredConstructor(new Class[0]);
            Object jbig2Decoder = jbig2DecoderClassConstructor.newInstance(new Object[0]);
            HashMap decodeParms = this.library.getDictionary(this.entries, DECODEPARMS_KEY);
            if (decodeParms != null) {
                byte[] globals;
                Stream globalsStream = null;
                Object jbigGlobals = this.library.getObject(decodeParms, JBIG2GLOBALS_KEY);
                if (jbigGlobals instanceof Stream) {
                    globalsStream = (Stream)jbigGlobals;
                }
                if (globalsStream != null && (globals = globalsStream.getDecodedStreamBytes(0)) != null && globals.length > 0) {
                    Class[] partypes = new Class[]{byte[].class};
                    Object[] arglist = new Object[]{globals};
                    Method setGlobalData = jbig2DecoderClass.getMethod("setGlobalData", partypes);
                    setGlobalData.invoke(jbig2Decoder, arglist);
                }
            }
            byte[] data = this.getDecodedStreamBytes(width * height * colourSpace.getNumComponents() * bitspercomponent / 8);
            Class[] argTypes = new Class[]{byte[].class};
            Object[] arglist = new Object[]{data};
            Method decodeJBIG2 = jbig2DecoderClass.getMethod("decodeJBIG2", argTypes);
            decodeJBIG2.invoke(jbig2Decoder, arglist);
            Method cleanupPostDecode = jbig2DecoderClass.getMethod("cleanupPostDecode", new Class[0]);
            cleanupPostDecode.invoke(jbig2Decoder, new Object[0]);
            argTypes = new Class[]{Integer.TYPE};
            arglist = new Object[]{0};
            Method getPageAsBufferedImage = jbig2DecoderClass.getMethod("getPageAsBufferedImage", argTypes);
            tmpImage = (BufferedImage)getPageAsBufferedImage.invoke(jbig2Decoder, arglist);
        }
        catch (ClassNotFoundException e) {
            logger.warning("JBIG2 image library could not be found");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Problem loading JBIG2 image: ", e);
        }
        return tmpImage;
    }

    private BufferedImage jpxDecode(int width, int height, PColorSpace colourSpace, int bitsPerComponent, float[] decode) {
        BufferedImage tmpImage = null;
        try {
            WritableRaster wr;
            Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("JPEG2000");
            if (!iterator.hasNext()) {
                logger.info("ImageIO missing required plug-in to read JPEG 2000 images. You can download the JAI ImageIO Tools from: https://jai-imageio.dev.java.net/");
                return null;
            }
            byte[] data = this.getDecodedStreamBytes(width * height * colourSpace.getNumComponents() * bitsPerComponent / 8);
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(data));
            tmpImage = ImageIO.read(imageInputStream);
            if (colourSpace instanceof ICCBased) {
                ICCBased iccBased = (ICCBased)colourSpace;
                if (iccBased.getAlternate() != null) {
                    colourSpace = iccBased.getAlternate();
                } else {
                    ColorSpace cs = iccBased.getColorSpace();
                    ColorConvertOp cco = new ColorConvertOp(cs, null);
                    tmpImage = cco.filter(tmpImage, null);
                }
            }
            if (colourSpace instanceof DeviceRGB && bitsPerComponent == 8) {
                wr = tmpImage.getRaster();
                ImageUtility.alterRasterRGB2PColorSpace(wr, colourSpace);
                tmpImage = ImageUtility.makeRGBBufferedImage(wr);
            } else {
                if (colourSpace instanceof DeviceCMYK && bitsPerComponent == 8) {
                    wr = tmpImage.getRaster();
                    tmpImage = ImageUtility.alterRasterCMYK2BGRA(wr);
                    return tmpImage;
                }
                if (colourSpace instanceof DeviceGray && bitsPerComponent == 8) {
                    wr = tmpImage.getRaster();
                    tmpImage = ImageUtility.makeGrayBufferedImage(wr);
                } else if (colourSpace instanceof Separation) {
                    wr = tmpImage.getRaster();
                    ImageUtility.alterRasterY2Gray(wr, decode);
                } else if (colourSpace instanceof Indexed) {
                    tmpImage = ImageUtility.applyIndexColourModel(tmpImage, width, height, colourSpace, bitsPerComponent);
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Problem loading JPEG2000 image: ", e);
        }
        return tmpImage;
    }

    private byte[] ccittFaxDecode(byte[] streamData, int width, int height) {
        HashMap decodeParms = this.library.getDictionary(this.entries, DECODEPARMS_KEY);
        float k = this.library.getFloat(decodeParms, K_KEY);
        boolean blackIs1 = this.getBlackIs1(this.library, decodeParms);
        boolean encodedByteAlign = false;
        Object encodedByteAlignObject = this.library.getObject(decodeParms, ENCODEDBYTEALIGN_KEY);
        if (encodedByteAlignObject instanceof Boolean) {
            encodedByteAlign = (Boolean)encodedByteAlignObject;
        }
        int columns = this.library.getInt(decodeParms, COLUMNS_KEY);
        int rows = this.library.getInt(decodeParms, ROWS_KEY);
        if (columns == 0) {
            columns = width;
        }
        if (rows == 0) {
            rows = height;
        }
        int size = rows * (columns + 7 >> 3);
        byte[] decodedStreamData = new byte[size];
        CCITTFaxDecoder decoder = new CCITTFaxDecoder(1, columns, rows);
        decoder.setAlign(encodedByteAlign);
        try {
            if (k == 0.0f) {
                decoder.decodeT41D(decodedStreamData, streamData, 0, rows);
            } else if (k > 0.0f) {
                decoder.decodeT42D(decodedStreamData, streamData, 0, rows);
            } else if (k < 0.0f) {
                decoder.decodeT6(decodedStreamData, streamData, 0, rows);
            }
        }
        catch (Exception e) {
            logger.warning("Error decoding CCITTFax image k: " + k);
            decoder.decodeT6(decodedStreamData, streamData, 0, rows);
        }
        if (!blackIs1) {
            for (int i = 0; i < decodedStreamData.length; ++i) {
                decodedStreamData[i] = ~decodedStreamData[i];
            }
        }
        return decodedStreamData;
    }

    private BufferedImage parseImage(int width, int height, PColorSpace colorSpace, boolean imageMask, Color fill, int bitsPerColour, float[] decode, byte[] baCCITTFaxData) {
        BitStream in;
        if (Tagger.tagging) {
            Tagger.tagImage("HandledBy=ParseImage");
        }
        int[] imageBits = new int[width];
        int fillRGB = fill.getRGB();
        int colorSpaceCompCount = colorSpace.getNumComponents();
        boolean isDeviceRGB = colorSpace instanceof DeviceRGB;
        boolean isDeviceGray = colorSpace instanceof DeviceGray;
        int maxColourValue = (1 << bitsPerColour) - 1;
        int[] f = new int[colorSpaceCompCount];
        float[] ff = new float[colorSpaceCompCount];
        float imageMaskValue = decode[0];
        BufferedImage bim = new BufferedImage(width, height, 2);
        if (baCCITTFaxData != null) {
            in = new BitStream(new ByteArrayInputStream(baCCITTFaxData));
        } else {
            ByteArrayInputStream dataInput = this.getDecodedByteArrayInputStream();
            if (dataInput == null) {
                return null;
            }
            in = new BitStream(dataInput);
        }
        try {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (imageMask) {
                        int bit = in.getBits(bitsPerColour);
                        imageBits[x] = bit = (float)bit == imageMaskValue ? fillRGB : 0;
                        continue;
                    }
                    int red = 255;
                    int blue = 255;
                    int green = 255;
                    int alpha = 255;
                    if (colorSpaceCompCount == 1) {
                        int bit = in.getBits(bitsPerColour);
                        if (decode != null && decode[0] > decode[1]) {
                            int n = bit = bit == maxColourValue ? 0 : maxColourValue;
                        }
                        if (isDeviceGray) {
                            if (bitsPerColour == 1) {
                                bit = ImageUtility.GRAY_1_BIT_INDEX_TO_RGB[bit];
                            } else if (bitsPerColour == 2) {
                                bit = ImageUtility.GRAY_2_BIT_INDEX_TO_RGB[bit];
                            } else if (bitsPerColour == 4) {
                                bit = ImageUtility.GRAY_4_BIT_INDEX_TO_RGB[bit];
                            } else if (bitsPerColour == 8) {
                                bit = bit << 24 | bit << 16 | bit << 8 | bit;
                            }
                            imageBits[x] = bit;
                            continue;
                        }
                        f[0] = bit;
                        colorSpace.normaliseComponentsToFloats(f, ff, maxColourValue);
                        Color color = colorSpace.getColor(ff);
                        imageBits[x] = color.getRGB();
                        continue;
                    }
                    if (colorSpaceCompCount == 3) {
                        if (isDeviceRGB) {
                            red = in.getBits(bitsPerColour);
                            green = in.getBits(bitsPerColour);
                            blue = in.getBits(bitsPerColour);
                            imageBits[x] = alpha << 24 | red << 16 | green << 8 | blue;
                            continue;
                        }
                        for (int i = 0; i < colorSpaceCompCount; ++i) {
                            f[i] = in.getBits(bitsPerColour);
                        }
                        PColorSpace.reverseInPlace(f);
                        colorSpace.normaliseComponentsToFloats(f, ff, maxColourValue);
                        Color color = colorSpace.getColor(ff);
                        imageBits[x] = color.getRGB();
                        continue;
                    }
                    if (colorSpaceCompCount == 4) {
                        for (int i = 0; i < colorSpaceCompCount; ++i) {
                            f[i] = in.getBits(bitsPerColour);
                            if (!(decode[0] > decode[1])) continue;
                            f[i] = maxColourValue - f[i];
                        }
                        PColorSpace.reverseInPlace(f);
                        colorSpace.normaliseComponentsToFloats(f, ff, maxColourValue);
                        Color color = colorSpace.getColor(ff);
                        imageBits[x] = color.getRGB();
                        continue;
                    }
                    imageBits[x] = alpha << 24 | red << 16 | green << 8 | blue;
                }
                bim.setRGB(0, y, width, 1, imageBits, 0, 1);
            }
            in.close();
        }
        catch (IOException e) {
            logger.log(Level.FINE, "Error parsing image.", e);
        }
        return bim;
    }

    public boolean getBlackIs1(Library library, HashMap decodeParmsDictionary) {
        Object blackIs1Obj = library.getObject(decodeParmsDictionary, BLACKIS1_KEY);
        if (blackIs1Obj != null) {
            if (blackIs1Obj instanceof Boolean) {
                return (Boolean)blackIs1Obj;
            }
            if (blackIs1Obj instanceof String) {
                String blackIs1String = (String)blackIs1Obj;
                if (blackIs1String.equalsIgnoreCase("true")) {
                    return true;
                }
                if (blackIs1String.equalsIgnoreCase("t")) {
                    return true;
                }
                if (blackIs1String.equals("1")) {
                    return true;
                }
                if (blackIs1String.equalsIgnoreCase("false")) {
                    return false;
                }
                if (blackIs1String.equalsIgnoreCase("f")) {
                    return false;
                }
                if (blackIs1String.equals("0")) {
                    return false;
                }
            }
        }
        return false;
    }

    private boolean containsFilter(String[] searchFilterNames) {
        List<String> filterNames = this.getFilterNames();
        if (filterNames == null) {
            return false;
        }
        for (String filterName1 : filterNames) {
            String filterName = filterName1.toString();
            for (String search : searchFilterNames) {
                if (!search.equals(filterName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isImageMask() {
        return this.library.getBoolean(this.entries, IMAGEMASK_KEY);
    }

    private boolean shouldUseCCITTFaxDecode() {
        return this.containsFilter(CCITTFAX_DECODE_FILTERS);
    }

    private boolean shouldUseDCTDecode() {
        return this.containsFilter(DCT_DECODE_FILTERS);
    }

    private boolean shouldUseJBIG2Decode() {
        return this.containsFilter(JBIG2_DECODE_FILTERS);
    }

    private boolean shouldUseJPXDecode() {
        return this.containsFilter(JPX_DECODE_FILTERS);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Image stream= ");
        sb.append(this.entries);
        if (this.getPObjectReference() != null) {
            sb.append("  ");
            sb.append(this.getPObjectReference());
        }
        return sb.toString();
    }
}

