/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.util.Library;

public class Lab
extends PColorSpace {
    public static final Name LAB_KEY = new Name("Lab");
    public static final Name WHITE_POINT_KEY = new Name("WhitePoint");
    public static final Name RANGE_KEY = new Name("Range");
    private float[] whitePoint = new float[]{0.95047f, 1.0f, 1.08883f};
    private float[] blackPoint = new float[]{0.0f, 0.0f, 0.0f};
    private float[] range = new float[]{-100.0f, 100.0f, -100.0f, 100.0f};
    private float lBase;
    private float lSpread;
    private float aBase;
    private float aSpread;
    private float bBase;
    private float bSpread;
    private float xBase;
    private float xSpread;
    private float yBase;
    private float ySpread;
    private float zBase;
    private float zSpread;

    Lab(Library l, HashMap h) {
        super(l, h);
        List v = (List)l.getObject(h, WHITE_POINT_KEY);
        if (v != null) {
            this.whitePoint[0] = ((Number)v.get(0)).floatValue();
            this.whitePoint[1] = ((Number)v.get(1)).floatValue();
            this.whitePoint[2] = ((Number)v.get(2)).floatValue();
        }
        if ((v = (List)l.getObject(h, RANGE_KEY)) != null) {
            this.range[0] = ((Number)v.get(0)).floatValue();
            this.range[1] = ((Number)v.get(1)).floatValue();
            this.range[2] = ((Number)v.get(2)).floatValue();
            this.range[3] = ((Number)v.get(3)).floatValue();
        }
        this.lBase = 0.0f;
        this.lSpread = 100.0f;
        this.aBase = this.range[0];
        this.aSpread = this.range[1] - this.aBase;
        this.bBase = this.range[2];
        this.bSpread = this.range[3] - this.bBase;
        this.xBase = this.blackPoint[0];
        this.xSpread = this.whitePoint[0] - this.xBase;
        this.yBase = this.blackPoint[1];
        this.ySpread = this.whitePoint[1] - this.yBase;
        this.zBase = this.blackPoint[2];
        this.zSpread = this.whitePoint[2] - this.zBase;
    }

    public int getNumComponents() {
        return 3;
    }

    private double g(double x) {
        x = x < (double)0.2069f ? 0.12842 * (x - 0.13793) : x * x * x;
        return x;
    }

    private double gg(double r) {
        r = r > 0.0031308 ? 1.055 * Math.pow(r, 0.4166666666666667) - 0.055 : (r *= 12.92);
        return r;
    }

    public void normaliseComponentsToFloats(int[] in, float[] out, float maxval) {
        super.normaliseComponentsToFloats(in, out, maxval);
        out[2] = this.lBase + this.lSpread * out[2];
        out[1] = this.aBase + this.aSpread * out[1];
        out[0] = this.bBase + this.bSpread * out[0];
    }

    public Color getColor(float[] f) {
        double cie_b = f[0];
        double cie_a = f[1];
        double cie_L = f[2];
        double var_Y = (cie_L + 16.0) / 116.0;
        double var_X = var_Y + cie_a * 0.002;
        double var_Z = var_Y - cie_b * 0.005;
        double X = this.g(var_X);
        double Y = this.g(var_Y);
        double Z = this.g(var_Z);
        X = (double)this.xBase + X * (double)this.xSpread;
        Y = (double)this.yBase + Y * (double)this.ySpread;
        Z = (double)this.zBase + Z * (double)this.zSpread;
        X = Math.max(0.0, Math.min(1.0, X));
        Y = Math.max(0.0, Math.min(1.0, Y));
        Z = Math.max(0.0, Math.min(1.0, Z));
        double r = X * 3.241 + Y * -1.5374 + Z * -0.4986;
        double g = X * -0.9692 + Y * 1.876 + Z * 0.0416;
        double b = X * 0.0556 + Y * -0.204 + Z * 1.057;
        r = this.gg(r);
        g = this.gg(g);
        b = this.gg(b);
        int ir = (int)(r * 255.0);
        int ig = (int)(g * 255.0);
        int ib = (int)(b * 255.0);
        ir = Math.max(0, Math.min(255, ir));
        ig = Math.max(0, Math.min(255, ig));
        ib = Math.max(0, Math.min(255, ib));
        return new Color(ir, ig, ib);
    }
}

