/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.functions.Function;
import org.icepdf.core.pobjects.graphics.DeviceN;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.pobjects.graphics.ShadingPattern;
import org.icepdf.core.pobjects.graphics.batik.ext.awt.LinearGradientPaint;
import org.icepdf.core.pobjects.graphics.batik.ext.awt.MultipleGradientPaint;
import org.icepdf.core.util.Library;

public class ShadingType2Pattern
extends ShadingPattern {
    private static final Logger logger = Logger.getLogger(ShadingType2Pattern.class.toString());
    protected Function[] function;
    protected List<Float> domain;
    protected List coords;
    protected List<Boolean> extend;
    private LinearGradientPaint linearGradientPaint;

    public ShadingType2Pattern(Library library, HashMap entries) {
        super(library, entries);
    }

    public synchronized void init() {
        Point2D.Float endPoint;
        if (this.inited) {
            return;
        }
        if (this.shading == null) {
            this.shading = this.library.getDictionary(this.entries, SHADING_KEY);
        }
        this.shadingType = this.library.getInt(this.shading, SHADING_TYPE_KEY);
        this.bBox = this.library.getRectangle(this.shading, BBOX_KEY);
        this.colorSpace = PColorSpace.getColorSpace(this.library, this.library.getObject(this.shading, COLORSPACE_KEY));
        Object tmp = this.library.getObject(this.shading, BACKGROUND_KEY);
        if (tmp != null && tmp instanceof List) {
            this.background = (List)tmp;
        }
        this.antiAlias = this.library.getBoolean(this.shading, ANTIALIAS_KEY);
        tmp = this.library.getObject(this.shading, DOMAIN_KEY);
        if (tmp instanceof List) {
            this.domain = (List)tmp;
        } else {
            this.domain = new ArrayList<Float>(2);
            this.domain.add(new Float(0.0));
            this.domain.add(new Float(1.0));
        }
        tmp = this.library.getObject(this.shading, COORDS_KEY);
        if (tmp instanceof List) {
            this.coords = (List)tmp;
        }
        if ((tmp = this.library.getObject(this.shading, EXTEND_KEY)) instanceof List) {
            this.extend = (List)tmp;
        } else {
            this.extend = new ArrayList<Boolean>(2);
            this.extend.add(false);
            this.extend.add(false);
        }
        tmp = this.library.getObject(this.shading, FUNCTION_KEY);
        if (tmp != null) {
            if (!(tmp instanceof List)) {
                this.function = new Function[]{Function.getFunction(this.library, tmp)};
            } else {
                List functionTemp = (List)tmp;
                this.function = new Function[functionTemp.size()];
                for (int i = 0; i < functionTemp.size(); ++i) {
                    this.function[i] = Function.getFunction(this.library, functionTemp.get(i));
                }
            }
        }
        float t0 = this.domain.get(0).floatValue();
        float t1 = this.domain.get(1).floatValue();
        Point2D.Float startPoint = new Point2D.Float(((Number)this.coords.get(0)).floatValue(), ((Number)this.coords.get(1)).floatValue());
        if (startPoint.equals(endPoint = new Point2D.Float(((Number)this.coords.get(2)).floatValue(), ((Number)this.coords.get(3)).floatValue()))) {
            endPoint.x += 1.0f;
        }
        int numberOfPoints = 10;
        Color[] colors = this.calculateColorPoints(numberOfPoints, startPoint, endPoint, t0, t1);
        float[] dist = this.calculateDomainEntries(numberOfPoints, t0, t1);
        this.linearGradientPaint = new LinearGradientPaint(startPoint, endPoint, dist, colors, MultipleGradientPaint.NO_CYCLE, MultipleGradientPaint.LINEAR_RGB, this.matrix);
        this.inited = true;
    }

    protected Color[] calculateColorPoints(int numberOfPoints, Point2D.Float startPoint, Point2D.Float endPoint, float t0, float t1) {
        Color[] color;
        float m = (startPoint.y - endPoint.y) / (startPoint.x - endPoint.x);
        float b = startPoint.y - m * startPoint.x;
        if (!Float.isInfinite(m)) {
            float xDiff = (endPoint.x - startPoint.x) / (float)numberOfPoints;
            float xOffset = startPoint.x;
            color = new Color[numberOfPoints + 1];
            int max = color.length;
            for (int i = 0; i < max; ++i) {
                Point2D.Float point = new Point2D.Float(xOffset, m * xOffset + b);
                color[i] = this.calculateColour(this.colorSpace, point, startPoint, endPoint, t0, t1);
                xOffset += xDiff;
            }
        } else {
            float yDiff = (endPoint.y - startPoint.y) / (float)numberOfPoints;
            float yOffset = startPoint.y;
            color = new Color[numberOfPoints + 1];
            int max = color.length;
            for (int i = 0; i < max; ++i) {
                Point2D.Float point = new Point2D.Float(0.0f, yOffset);
                color[i] = this.calculateColour(this.colorSpace, point, startPoint, endPoint, t0, t1);
                yOffset += yDiff;
            }
        }
        return color;
    }

    protected float[] calculateDomainEntries(int numberOfPoints, float t0, float t1) {
        float offset = 1.0f / (float)numberOfPoints;
        float[] domainEntries = new float[numberOfPoints + 1];
        domainEntries[0] = t0;
        int max = domainEntries.length;
        for (int i = 1; i < max; ++i) {
            domainEntries[i] = domainEntries[i - 1] + offset;
        }
        domainEntries[domainEntries.length - 1] = t1;
        return domainEntries;
    }

    private Color calculateColour(PColorSpace colorSpace, Point2D.Float xy, Point2D.Float point1, Point2D.Float point2, float t0, float t1) {
        float xPrime = this.linearMapping(xy, point1, point2);
        float t = this.parametrixValue(xPrime, t0, t1, this.extend);
        float[] input = new float[]{t};
        if (this.function != null) {
            float[] output;
            int length = this.function.length;
            if (length == 1) {
                output = this.function[0].calculate(input);
            } else {
                output = new float[length];
                for (int i = 0; i < length; ++i) {
                    output[i] = this.function[i].calculate(input)[0];
                }
            }
            if (output != null) {
                if (!(colorSpace instanceof DeviceN)) {
                    output = PColorSpace.reverse(output);
                }
                return colorSpace.getColor(output);
            }
            return null;
        }
        logger.fine("Error processing Shading Type 2 Pattern.");
        return null;
    }

    private float linearMapping(Point2D.Float xy, Point2D.Float point1, Point2D.Float point2) {
        float x = xy.x;
        float y = xy.y;
        float x0 = point1.x;
        float y0 = point1.y;
        float x1 = point2.x;
        float y1 = point2.y;
        float top = (x1 - x0) * (x - x0) + (y1 - y0) * (y - y0);
        float bottom = (x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0);
        int map = (int)(top / bottom * 100.0f);
        return (float)map / 100.0f;
    }

    private float parametrixValue(float linearMapping, float t0, float t1, List extended) {
        if (linearMapping < 0.0f && ((Boolean)extended.get(0)).booleanValue()) {
            return t0;
        }
        if (linearMapping > 1.0f && ((Boolean)extended.get(1)).booleanValue()) {
            return t1;
        }
        return t0 + (t1 - t0) * linearMapping;
    }

    public Paint getPaint() {
        this.init();
        return this.linearGradientPaint;
    }

    public String toString() {
        return super.toString() + "\n                    domain: " + this.domain + "\n                    coords: " + this.coords + "\n                    extend: " + this.extend + "\n                 function: " + this.function;
    }
}

