/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.adapters.history;

import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.stem.adapters.history.HistoryExtendedListener;
import org.eclipse.stem.adapters.history.HistoryProvider;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.ResettableAdapter;
import org.eclipse.stem.core.model.ModelFactory;
import org.eclipse.stem.core.model.STEMTime;

public class HistoryProviderAdapter
extends AdapterImpl
implements HistoryProvider,
ResettableAdapter {
    private List<HistoryExtendedListener> extensionListeners = new CopyOnWriteArrayList<HistoryExtendedListener>();
    private int earliestCycleNumber = 0;

    public Identifiable getInstance(STEMTime sTEMTime) {
        return (Identifiable)this.getTarget();
    }

    public Identifiable[] getAllHistoricInstances() {
        return new Identifiable[0];
    }

    public Identifiable[] getHistoricInstances(STEMTime[] sTEMTimeArray) {
        return new Identifiable[sTEMTimeArray.length];
    }

    public STEMTime[] getAllHistoricTimeValues() {
        return new STEMTime[0];
    }

    public int getEarliestCycleNumber() {
        return this.earliestCycleNumber;
    }

    public void reset() {
        this.fireHistoryExtended();
    }

    public STEMTime getEarliestTimeValue() {
        STEMTime sTEMTime = ModelFactory.eINSTANCE.createSTEMTime();
        sTEMTime.setTime(new Date());
        return sTEMTime;
    }

    public boolean isAdapterForType(Object object) {
        return object == HistoryProvider.class;
    }

    public void addExtensionListener(HistoryExtendedListener historyExtendedListener) {
        this.extensionListeners.add(historyExtendedListener);
    }

    public void removeExtensionListener(HistoryExtendedListener historyExtendedListener) {
        this.extensionListeners.remove(historyExtendedListener);
    }

    protected void fireHistoryExtended() {
        for (HistoryExtendedListener historyExtendedListener : this.extensionListeners) {
            historyExtendedListener.historyExtended(this);
        }
    }
}

