/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.stem.core.CorePlugin;
import org.eclipse.stem.core.STEMXMIResourceFactoryImpl;
import org.eclipse.stem.core.common.Identifiable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utility {
    private static final Map<String, String> EMF_SAVE_OPTIONS = new HashMap<String, String>();

    static {
        EMF_SAVE_OPTIONS.put("ENCODING", "UTF-8");
    }

    public static Identifiable getIdentifiable(URI uRI) {
        Identifiable identifiable = null;
        try {
            ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
            resourceSetImpl.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
            resourceSetImpl.getResourceFactoryRegistry().getProtocolToFactoryMap().put("platform", new XMIResourceFactoryImpl());
            Resource resource = resourceSetImpl.getResource(uRI, true);
            identifiable = (Identifiable)resource.getContents().get(0);
        }
        catch (Exception exception) {
            CorePlugin.logError("The serialized instance of an Identifiable at \"" + uRI.toString() + "\" was not found or was of the wrong format", exception);
            identifiable = null;
        }
        return identifiable;
    }

    public static void serializeIdentifiable(Identifiable identifiable, URI uRI) throws IOException {
        ArrayList<Identifiable> arrayList = new ArrayList<Identifiable>();
        arrayList.add(identifiable);
        Utility.serializeIdentifiables(arrayList, uRI);
    }

    public static void serializeIdentifiables(List<Identifiable> list, URI uRI) throws IOException {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", STEMXMIResourceFactoryImpl.INSTANCE);
        Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap().put("platform", STEMXMIResourceFactoryImpl.INSTANCE);
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        resourceSetImpl.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", STEMXMIResourceFactoryImpl.INSTANCE);
        resourceSetImpl.getResourceFactoryRegistry().getProtocolToFactoryMap().put("platform", STEMXMIResourceFactoryImpl.INSTANCE);
        Resource resource = resourceSetImpl.createResource(uRI);
        for (Identifiable identifiable : list) {
            resource.getContents().add((Object)identifiable);
        }
        resource.save(EMF_SAVE_OPTIONS);
    }

    public static int keyLevel(String string) {
        if (string.equalsIgnoreCase("ZZZ")) {
            return -1;
        }
        int n = 0;
        int n2 = 0;
        int n3 = string.indexOf("-");
        while (n3 > 0) {
            ++n;
            n3 = string.substring(n2 += n3 + 1).indexOf("-");
        }
        return n;
    }
}

