/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.experiment.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.common.impl.IdentifiableImpl;
import org.eclipse.stem.core.experiment.Experiment;
import org.eclipse.stem.core.experiment.ExperimentPackage;
import org.eclipse.stem.core.modifier.Modifier;
import org.eclipse.stem.core.scenario.Scenario;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExperimentImpl
extends IdentifiableImpl
implements Experiment {
    protected EList<Modifier> modifiers;
    protected static final boolean COMPLETE_EDEFAULT = false;
    protected Scenario scenario;
    private static int experimentCounter = 0;

    protected ExperimentImpl() {
        this.setURI(STEMURI.createURI("experiment/" + Integer.toString(experimentCounter++)));
        this.setTypeURI(STEMURI.EXPERIMENT_TYPE_URI);
    }

    @Override
    protected EClass eStaticClass() {
        return ExperimentPackage.Literals.EXPERIMENT;
    }

    @Override
    public EList<Modifier> getModifiers() {
        if (this.modifiers == null) {
            this.modifiers = new EObjectResolvingEList(Modifier.class, (InternalEObject)this, 3);
        }
        return this.modifiers;
    }

    @Override
    public List<String> getModificationSummary() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Modifier modifier : this.getModifiers()) {
            arrayList.addAll(modifier.getModificationSummary());
        }
        return arrayList;
    }

    @Override
    public boolean isComplete() {
        boolean bl = true;
        for (Modifier modifier : this.getModifiers()) {
            if (modifier.isComplete()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    @Override
    public Scenario getScenario() {
        if (this.scenario != null && this.scenario.eIsProxy()) {
            InternalEObject internalEObject = (InternalEObject)this.scenario;
            this.scenario = (Scenario)this.eResolveProxy(internalEObject);
            if (this.scenario != internalEObject && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)internalEObject, (Object)this.scenario));
            }
        }
        return this.scenario;
    }

    public Scenario basicGetScenario() {
        return this.scenario;
    }

    @Override
    public void setScenario(Scenario scenario) {
        Scenario scenario2 = this.scenario;
        this.scenario = scenario;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)scenario2, (Object)this.scenario));
        }
    }

    @Override
    public List<String> getParameterSummary() {
        return this.getModificationSummary();
    }

    @Override
    public Scenario updateScenario() {
        Identifiable identifiable2;
        Modifier modifier = (Modifier)this.getModifiers().get(0);
        if (!modifier.isComplete()) {
            modifier.updateScenario(this.getScenario());
        } else {
            for (Identifiable identifiable2 : this.getModifiers()) {
                if (identifiable2.isComplete()) {
                    identifiable2.reset();
                    identifiable2.updateScenario(this.getScenario());
                    continue;
                }
                identifiable2.updateScenario(this.getScenario());
                break;
            }
        }
        identifiable2 = this.getScenario();
        identifiable2.setProgress(0.0);
        return identifiable2;
    }

    @Override
    public Scenario initScenario() {
        int n = 1;
        while (n < this.getModifiers().size()) {
            ((Modifier)this.getModifiers().get(n)).updateScenario(this.getScenario());
            ++n;
        }
        return this.getScenario();
    }

    @Override
    public boolean sane() {
        boolean bl = super.sane();
        assert (bl);
        boolean bl2 = bl = this.getScenario() == null || this.getScenario().sane();
        assert (bl);
        for (Modifier modifier : this.getModifiers()) {
            bl = modifier.sane();
            assert (bl);
        }
        return bl;
    }

    @Override
    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 3: {
                return this.getModifiers();
            }
            case 4: {
                return this.isComplete() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                if (bl) {
                    return this.getScenario();
                }
                return this.basicGetScenario();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    @Override
    public void eSet(int n, Object object) {
        switch (n) {
            case 3: {
                this.getModifiers().clear();
                this.getModifiers().addAll((Collection)object);
                return;
            }
            case 5: {
                this.setScenario((Scenario)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    @Override
    public void eUnset(int n) {
        switch (n) {
            case 3: {
                this.getModifiers().clear();
                return;
            }
            case 5: {
                this.setScenario(null);
                return;
            }
        }
        super.eUnset(n);
    }

    @Override
    public boolean eIsSet(int n) {
        switch (n) {
            case 3: {
                return this.modifiers != null && !this.modifiers.isEmpty();
            }
            case 4: {
                return this.isComplete();
            }
            case 5: {
                return this.scenario != null;
            }
        }
        return super.eIsSet(n);
    }
}

