/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.graph.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.impl.IdentifiableImpl;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.core.graph.GraphFactory;
import org.eclipse.stem.core.graph.GraphPackage;
import org.eclipse.stem.core.graph.Node;

public class EdgeImpl
extends IdentifiableImpl
implements Edge {
    static int edgeCounter = 0;
    protected Node a;
    protected static final URI NODE_AURI_EDEFAULT = null;
    protected URI nodeAURI = NODE_AURI_EDEFAULT;
    protected Node b;
    protected static final URI NODE_BURI_EDEFAULT = null;
    protected URI nodeBURI = NODE_BURI_EDEFAULT;
    protected EdgeLabel label;
    protected static final boolean DIRECTED_EDEFAULT = false;
    protected boolean directed = false;

    protected EdgeImpl() {
        this.setURI(STEMURI.createURI("edge/" + Integer.toString(edgeCounter++)));
        this.setTypeURI(STEMURI.EDGE_TYPE_URI);
    }

    public static Edge createEdge(Node node, Node node2) {
        return EdgeImpl.createEdge(node, node2, false, null);
    }

    public static Edge createEdge(Node node, Node node2, URI uRI) {
        return EdgeImpl.createEdge(node, node2, false, uRI);
    }

    public static Edge createEdge(Node node, Node node2, boolean bl) {
        return EdgeImpl.createEdge(node, node2, bl, null);
    }

    public static Edge createEdge(Node node, Node node2, boolean bl, URI uRI) {
        Edge edge = EdgeImpl.createEdge(node.getURI(), node2.getURI(), bl, uRI);
        edge.setA(node);
        edge.setB(node2);
        node.getEdges().add((Object)edge);
        node2.getEdges().add((Object)edge);
        return edge;
    }

    public static Edge createEdge(URI uRI, URI uRI2) {
        return EdgeImpl.createEdge(uRI, uRI2, false, null);
    }

    public static Edge createEdge(URI uRI, URI uRI2, URI uRI3) {
        return EdgeImpl.createEdge(uRI, uRI2, false, uRI3);
    }

    public static Edge createEdge(URI uRI, URI uRI2, boolean bl) {
        return EdgeImpl.createEdge(uRI, uRI2, bl, null);
    }

    public static Edge createEdge(URI uRI, URI uRI2, boolean bl, URI uRI3) {
        Edge edge = GraphFactory.eINSTANCE.createEdge();
        edge.setNodeAURI(uRI);
        edge.setNodeBURI(uRI2);
        edge.setDirected(bl);
        if (uRI3 != null) {
            edge.setURI(uRI3);
        }
        return edge;
    }

    protected EClass eStaticClass() {
        return GraphPackage.Literals.EDGE;
    }

    public Node getA() {
        if (this.a != null && this.a.eIsProxy()) {
            InternalEObject internalEObject = (InternalEObject)this.a;
            this.a = (Node)this.eResolveProxy(internalEObject);
            if (this.a != internalEObject && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)internalEObject, (Object)this.a));
            }
        }
        return this.a;
    }

    public Node basicGetA() {
        return this.a;
    }

    public void setA(Node node) {
        Node node2 = this.a;
        this.a = node;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)node2, (Object)this.a));
        }
    }

    public URI getNodeAURI() {
        return this.nodeAURI;
    }

    public void setNodeAURI(URI uRI) {
        URI uRI2 = this.nodeAURI;
        this.nodeAURI = uRI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)uRI2, (Object)this.nodeAURI));
        }
    }

    public Node getB() {
        if (this.b != null && this.b.eIsProxy()) {
            InternalEObject internalEObject = (InternalEObject)this.b;
            this.b = (Node)this.eResolveProxy(internalEObject);
            if (this.b != internalEObject && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)internalEObject, (Object)this.b));
            }
        }
        return this.b;
    }

    public Node basicGetB() {
        return this.b;
    }

    public void setB(Node node) {
        Node node2 = this.b;
        this.b = node;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)node2, (Object)this.b));
        }
    }

    public URI getNodeBURI() {
        return this.nodeBURI;
    }

    public void setNodeBURI(URI uRI) {
        URI uRI2 = this.nodeBURI;
        this.nodeBURI = uRI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)uRI2, (Object)this.nodeBURI));
        }
    }

    public EdgeLabel getLabel() {
        return this.label;
    }

    public NotificationChain basicSetLabel(EdgeLabel edgeLabel, NotificationChain notificationChain) {
        EdgeLabel edgeLabel2 = this.label;
        this.label = edgeLabel;
        if (this.eNotificationRequired()) {
            ENotificationImpl eNotificationImpl = new ENotificationImpl((InternalEObject)this, 1, 7, (Object)edgeLabel2, (Object)edgeLabel);
            if (notificationChain == null) {
                notificationChain = eNotificationImpl;
            } else {
                notificationChain.add((Notification)eNotificationImpl);
            }
        }
        return notificationChain;
    }

    public void setLabel(EdgeLabel edgeLabel) {
        if (edgeLabel != this.label) {
            NotificationChain notificationChain = null;
            if (this.label != null) {
                notificationChain = ((InternalEObject)this.label).eInverseRemove((InternalEObject)this, 6, EdgeLabel.class, notificationChain);
            }
            if (edgeLabel != null) {
                notificationChain = ((InternalEObject)edgeLabel).eInverseAdd((InternalEObject)this, 6, EdgeLabel.class, notificationChain);
            }
            if ((notificationChain = this.basicSetLabel(edgeLabel, notificationChain)) != null) {
                notificationChain.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)edgeLabel, (Object)edgeLabel));
        }
    }

    public boolean isDirected() {
        return this.directed;
    }

    public void setDirected(boolean bl) {
        boolean bl2 = this.directed;
        this.directed = bl;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, bl2, this.directed));
        }
    }

    public Node getOtherNode(Node node) {
        assert (this.getA().equals(node) || this.getB().equals(node));
        return this.getA().equals(node) ? this.getB() : this.getA();
    }

    public boolean isDirectedAt(Node node) {
        return this.isDirected() && (this.b != null && this.b.equals(node) || this.b == null && this.nodeBURI.equals((Object)node.getURI()));
    }

    public NotificationChain eInverseAdd(InternalEObject internalEObject, int n, NotificationChain notificationChain) {
        switch (n) {
            case 7: {
                if (this.label != null) {
                    notificationChain = ((InternalEObject)this.label).eInverseRemove((InternalEObject)this, -8, null, notificationChain);
                }
                return this.basicSetLabel((EdgeLabel)internalEObject, notificationChain);
            }
        }
        return super.eInverseAdd(internalEObject, n, notificationChain);
    }

    public NotificationChain eInverseRemove(InternalEObject internalEObject, int n, NotificationChain notificationChain) {
        switch (n) {
            case 7: {
                return this.basicSetLabel(null, notificationChain);
            }
        }
        return super.eInverseRemove(internalEObject, n, notificationChain);
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 3: {
                if (bl) {
                    return this.getA();
                }
                return this.basicGetA();
            }
            case 4: {
                return this.getNodeAURI();
            }
            case 5: {
                if (bl) {
                    return this.getB();
                }
                return this.basicGetB();
            }
            case 6: {
                return this.getNodeBURI();
            }
            case 7: {
                return this.getLabel();
            }
            case 8: {
                return this.isDirected() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 3: {
                this.setA((Node)object);
                return;
            }
            case 4: {
                this.setNodeAURI((URI)object);
                return;
            }
            case 5: {
                this.setB((Node)object);
                return;
            }
            case 6: {
                this.setNodeBURI((URI)object);
                return;
            }
            case 7: {
                this.setLabel((EdgeLabel)object);
                return;
            }
            case 8: {
                this.setDirected((Boolean)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 3: {
                this.setA(null);
                return;
            }
            case 4: {
                this.setNodeAURI(NODE_AURI_EDEFAULT);
                return;
            }
            case 5: {
                this.setB(null);
                return;
            }
            case 6: {
                this.setNodeBURI(NODE_BURI_EDEFAULT);
                return;
            }
            case 7: {
                this.setLabel(null);
                return;
            }
            case 8: {
                this.setDirected(false);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 3: {
                return this.a != null;
            }
            case 4: {
                return NODE_AURI_EDEFAULT == null ? this.nodeAURI != null : !NODE_AURI_EDEFAULT.equals((Object)this.nodeAURI);
            }
            case 5: {
                return this.b != null;
            }
            case 6: {
                return NODE_BURI_EDEFAULT == null ? this.nodeBURI != null : !NODE_BURI_EDEFAULT.equals((Object)this.nodeBURI);
            }
            case 7: {
                return this.label != null;
            }
            case 8: {
                return this.directed;
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(this.a != null ? this.a : (this.nodeAURI != null ? this.nodeAURI.toString() : "null"));
        stringBuffer.append(this.directed ? " -> " : " -- ");
        stringBuffer.append(this.b != null ? this.b : (this.nodeBURI != null ? this.nodeBURI.toString() : "null"));
        return stringBuffer.toString();
    }

    public boolean sane() {
        boolean bl = super.sane();
        boolean bl2 = bl = bl && this.nodeAURI != null;
        assert (bl);
        boolean bl3 = bl = bl && this.nodeBURI != null;
        assert (bl);
        boolean bl4 = bl = bl && this.label != null;
        assert (bl);
        if (this.a != null) {
            boolean bl5 = bl = bl && this.a.getEdges().contains((Object)this);
            assert (bl);
            boolean bl6 = bl = bl && this.nodeAURI.equals((Object)this.a.getURI());
            assert (bl);
        }
        if (this.b != null) {
            boolean bl7 = bl = bl && this.b.getEdges().contains((Object)this);
            assert (bl);
            boolean bl8 = bl = bl && this.nodeBURI.equals((Object)this.b.getURI());
            assert (bl);
        }
        boolean bl9 = bl = bl && (this.a == null && this.b == null || this.a != null && this.b != null);
        assert (bl);
        boolean bl10 = bl = bl && this.label.getURIOfIdentifiableToBeLabeled() != null;
        assert (bl);
        boolean bl11 = bl = bl && this.label.getURIOfIdentifiableToBeLabeled().equals((Object)this.getURI());
        assert (bl);
        boolean bl12 = bl = bl && this.label.sane();
        assert (bl);
        return bl;
    }
}

