/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.graph.impl;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.common.impl.IdentifiableImpl;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.GraphPackage;
import org.eclipse.stem.core.graph.Label;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.graph.UnresolvedIdentifiable;
import org.eclipse.stem.core.graph.impl.URIToEdgeMapEntryImpl;
import org.eclipse.stem.core.graph.impl.URIToLabelMapEntryImpl;
import org.eclipse.stem.core.graph.impl.URIToNodeLabelMapEntryImpl;
import org.eclipse.stem.core.graph.impl.URIToNodeMapEntryImpl;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.STEMTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphImpl
extends IdentifiableImpl
implements Graph {
    static int graphCounter = 0;
    protected EMap<URI, Edge> edges;
    protected EMap<URI, Node> nodes;
    protected EMap<URI, Label> graphLabels;
    protected EMap<URI, NodeLabel> nodeLabels;
    protected EList<DynamicLabel> dynamicLabels;
    protected static final int NUM_EDGES_EDEFAULT = 0;
    protected static final int NUM_NODES_EDEFAULT = 0;
    protected static final int NUM_GRAPH_LABELS_EDEFAULT = 0;
    protected static final int NUM_NODE_LABELS_EDEFAULT = 0;
    protected static final int NUM_DYNAMIC_LABELS_EDEFAULT = 0;
    protected EList<UnresolvedIdentifiable> unresolvedIdentifiables;
    protected EList<Decorator> decorators;
    protected STEMTime time;

    protected GraphImpl() {
        this.setURI(STEMURI.createURI("graph/" + Integer.toString(graphCounter++)));
        this.setTypeURI(STEMURI.GRAPH_TYPE_URI);
    }

    @Override
    protected EClass eStaticClass() {
        return GraphPackage.Literals.GRAPH;
    }

    @Override
    public void setURI(URI uRI) {
        super.setURI(uRI);
        for (Label label : this.getGraphLabels().values()) {
            label.setURIOfIdentifiableToBeLabeled(uRI);
        }
    }

    @Override
    public EMap<URI, Edge> getEdges() {
        if (this.edges == null) {
            this.edges = new EcoreEMap(GraphPackage.Literals.URI_TO_EDGE_MAP_ENTRY, URIToEdgeMapEntryImpl.class, (InternalEObject)this, 3);
        }
        return this.edges;
    }

    @Override
    public EMap<URI, Node> getNodes() {
        if (this.nodes == null) {
            this.nodes = new EcoreEMap(GraphPackage.Literals.URI_TO_NODE_MAP_ENTRY, URIToNodeMapEntryImpl.class, (InternalEObject)this, 4);
        }
        return this.nodes;
    }

    @Override
    public EList<DynamicLabel> getDynamicLabels() {
        if (this.dynamicLabels == null) {
            this.dynamicLabels = new EObjectResolvingEList(DynamicLabel.class, (InternalEObject)this, 7);
        }
        return this.dynamicLabels;
    }

    @Override
    public EMap<URI, Label> getGraphLabels() {
        if (this.graphLabels == null) {
            this.graphLabels = new EcoreEMap(GraphPackage.Literals.URI_TO_LABEL_MAP_ENTRY, URIToLabelMapEntryImpl.class, (InternalEObject)this, 5);
        }
        return this.graphLabels;
    }

    @Override
    public EList<UnresolvedIdentifiable> getUnresolvedIdentifiables() {
        if (this.unresolvedIdentifiables == null) {
            this.unresolvedIdentifiables = new EObjectContainmentEList(UnresolvedIdentifiable.class, (InternalEObject)this, 13);
        }
        return this.unresolvedIdentifiables;
    }

    @Override
    public EList<Decorator> getDecorators() {
        if (this.decorators == null) {
            this.decorators = new EObjectContainmentWithInverseEList(Decorator.class, (InternalEObject)this, 14, 4);
        }
        return this.decorators;
    }

    @Override
    public STEMTime getTime() {
        return this.time;
    }

    public NotificationChain basicSetTime(STEMTime sTEMTime, NotificationChain notificationChain) {
        STEMTime sTEMTime2 = this.time;
        this.time = sTEMTime;
        if (this.eNotificationRequired()) {
            ENotificationImpl eNotificationImpl = new ENotificationImpl((InternalEObject)this, 1, 15, (Object)sTEMTime2, (Object)sTEMTime);
            if (notificationChain == null) {
                notificationChain = eNotificationImpl;
            } else {
                notificationChain.add((Notification)eNotificationImpl);
            }
        }
        return notificationChain;
    }

    @Override
    public void setTime(STEMTime sTEMTime) {
        if (sTEMTime != this.time) {
            NotificationChain notificationChain = null;
            if (this.time != null) {
                notificationChain = ((InternalEObject)this.time).eInverseRemove((InternalEObject)this, -16, null, notificationChain);
            }
            if (sTEMTime != null) {
                notificationChain = ((InternalEObject)sTEMTime).eInverseAdd((InternalEObject)this, -16, null, notificationChain);
            }
            if ((notificationChain = this.basicSetTime(sTEMTime, notificationChain)) != null) {
                notificationChain.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)sTEMTime, (Object)sTEMTime));
        }
    }

    @Override
    public EList<NodeLabel> getNodeLabelsByTypeURI(URI uRI) {
        BasicEList basicEList = new BasicEList();
        for (NodeLabel nodeLabel : this.getNodeLabels().values()) {
            if (!nodeLabel.getTypeURI().equals((Object)uRI)) continue;
            basicEList.add((Object)nodeLabel);
        }
        ECollections.sort((EList)basicEList, (Comparator)new Comparator<NodeLabel>(){

            @Override
            public int compare(NodeLabel nodeLabel, NodeLabel nodeLabel2) {
                return nodeLabel.getURI().toString().compareTo(nodeLabel2.getURI().toString());
            }
        });
        return basicEList;
    }

    @Override
    public EMap<URI, NodeLabel> getNodeLabels() {
        if (this.nodeLabels == null) {
            this.nodeLabels = new EcoreEMap(GraphPackage.Literals.URI_TO_NODE_LABEL_MAP_ENTRY, URIToNodeLabelMapEntryImpl.class, (InternalEObject)this, 6);
        }
        return this.nodeLabels;
    }

    @Override
    public int getNumEdges() {
        return this.edges == null ? 0 : this.getEdges().size();
    }

    @Override
    public int getNumNodes() {
        return this.nodes == null ? 0 : this.getNodes().size();
    }

    @Override
    public int getNumGraphLabels() {
        return this.graphLabels == null ? 0 : this.getGraphLabels().size();
    }

    @Override
    public int getNumNodeLabels() {
        return this.nodeLabels == null ? 0 : this.getNodeLabels().size();
    }

    @Override
    public int getNumDynamicLabels() {
        return this.dynamicLabels == null ? 0 : this.getDynamicLabels().size();
    }

    @Override
    public void addGraph(Graph graph) {
        this.getEdges().addAll(graph.getEdges());
        this.getNodes().addAll(graph.getNodes());
        this.getNodeLabels().addAll(graph.getNodeLabels());
        this.getDecorators().addAll(graph.getDecorators());
        for (Label label : graph.getGraphLabels().values()) {
            label.setURIOfIdentifiableToBeLabeled(this.getURI());
            this.putGraphLabel(label);
        }
        this.getDynamicLabels().addAll(graph.getDynamicLabels());
        this.getUnresolvedIdentifiables().addAll(graph.getUnresolvedIdentifiables());
    }

    @Override
    public void putEdge(Edge edge) {
        this.getEdges().put((Object)edge.getURI(), (Object)edge);
        EdgeLabel edgeLabel = edge.getLabel();
        if (edgeLabel instanceof DynamicLabel) {
            this.addDynamicLabel((DynamicLabel)((Object)edgeLabel));
        }
    }

    @Override
    public Edge getEdge(URI uRI) {
        return (Edge)this.getEdges().get((Object)uRI);
    }

    @Override
    public void putNode(Node node) {
        this.getNodes().put((Object)node.getURI(), (Object)node);
        for (NodeLabel nodeLabel : node.getLabels()) {
            this.putNodeLabel(nodeLabel);
        }
    }

    @Override
    public Node getNode(URI uRI) {
        return (Node)this.getNodes().get((Object)uRI);
    }

    @Override
    public void putNodeLabel(NodeLabel nodeLabel) {
        this.getNodeLabels().put((Object)nodeLabel.getURI(), (Object)nodeLabel);
        if (nodeLabel instanceof DynamicLabel) {
            this.addDynamicLabel((DynamicLabel)((Object)nodeLabel));
        }
    }

    @Override
    public NodeLabel getNodeLabel(URI uRI) {
        return (NodeLabel)this.getNodeLabels().get((Object)uRI);
    }

    @Override
    public void putGraphLabel(Label label) {
        this.getGraphLabels().put((Object)label.getURI(), (Object)label);
        if (label instanceof DynamicLabel) {
            this.addDynamicLabel((DynamicLabel)label);
        }
    }

    @Override
    public Label getGraphLabel(URI uRI) {
        return (Label)this.getGraphLabels().get((Object)uRI);
    }

    @Override
    public void addDynamicLabel(DynamicLabel dynamicLabel) {
        this.getDynamicLabels().add((Object)dynamicLabel);
    }

    @Override
    public void switchToNextValue(STEMTime sTEMTime) {
        for (DynamicLabel dynamicLabel : this.getDynamicLabels()) {
            dynamicLabel.switchToNextValue();
        }
        this.setTime((STEMTime)EcoreUtil.copy((EObject)sTEMTime));
    }

    public NotificationChain eInverseAdd(InternalEObject internalEObject, int n, NotificationChain notificationChain) {
        switch (n) {
            case 14: {
                return ((InternalEList)this.getDecorators()).basicAdd((Object)internalEObject, notificationChain);
            }
        }
        return super.eInverseAdd(internalEObject, n, notificationChain);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("\"" + this.dublinCore.getTitle() + "\",\n");
        stringBuilder.append(this.getNumNodes() > 0 ? String.valueOf(this.getNumNodes()) + " Nodes\n" : "");
        stringBuilder.append(this.getNumEdges() > 0 ? String.valueOf(this.getNumEdges()) + " Edges\n" : "");
        stringBuilder.append(this.getNumNodeLabels() > 0 ? String.valueOf(this.getNumNodeLabels()) + " Node Labels " : "");
        stringBuilder.append(this.getNumGraphLabels() > 0 ? String.valueOf(this.getNumGraphLabels()) + " Graph Labels\n" : "");
        stringBuilder.append(this.getNumDynamicLabels() > 0 ? String.valueOf(this.getNumDynamicLabels()) + " Dynamic Labels\n" : "");
        return stringBuilder.toString();
    }

    @Override
    public boolean sane() {
        Identifiable identifiable2;
        Iterator iterator;
        boolean bl = super.sane();
        int n = 0;
        int n2 = 0;
        if (this.nodes != null) {
            iterator = this.getNodes().values().iterator();
            while (iterator.hasNext() && bl) {
                identifiable2 = (Node)iterator.next();
                boolean bl2 = bl = bl && identifiable2.sane();
                assert (bl);
                n += identifiable2.getLabels().size();
                for (Label label : identifiable2.getLabels()) {
                    if (label instanceof DynamicLabel) {
                        ++n2;
                        bl = false;
                        for (DynamicLabel dynamicLabel : this.getDynamicLabels()) {
                            if (dynamicLabel != label) continue;
                            bl = true;
                            break;
                        }
                        assert (bl);
                    }
                    boolean bl3 = bl = bl && this.getNodeLabels().containsKey((Object)label.getURI());
                    assert (bl);
                }
            }
        }
        if (this.edges != null) {
            iterator = this.getEdges().values().iterator();
            while (iterator.hasNext() && bl) {
                identifiable2 = (Edge)iterator.next();
                boolean bl4 = bl = bl && identifiable2.sane();
                assert (bl);
                if (!(identifiable2.getLabel() instanceof DynamicLabel)) continue;
                ++n2;
            }
        }
        if (this.nodeLabels != null) {
            iterator = this.getNodeLabels().values().iterator();
            while (iterator.hasNext() && bl) {
                identifiable2 = (NodeLabel)iterator.next();
                boolean bl5 = bl = bl && identifiable2.sane();
                assert (bl);
            }
        }
        if (this.graphLabels != null) {
            for (Identifiable identifiable2 : this.getGraphLabels().values()) {
                boolean bl6 = bl = bl && identifiable2.sane();
                assert (bl);
                if (!(identifiable2 instanceof DynamicLabel)) continue;
                ++n2;
            }
        }
        if (this.dynamicLabels != null) {
            boolean bl7 = bl = n2 == this.getNumDynamicLabels();
            assert (bl);
            iterator = this.getDynamicLabels().iterator();
            while (iterator.hasNext() && bl) {
                identifiable2 = (DynamicLabel)iterator.next();
                boolean bl8 = bl = bl && identifiable2.sane();
                assert (bl);
            }
        }
        return bl;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject internalEObject, int n, NotificationChain notificationChain) {
        switch (n) {
            case 3: {
                return ((InternalEList)this.getEdges()).basicRemove((Object)internalEObject, notificationChain);
            }
            case 4: {
                return ((InternalEList)this.getNodes()).basicRemove((Object)internalEObject, notificationChain);
            }
            case 5: {
                return ((InternalEList)this.getGraphLabels()).basicRemove((Object)internalEObject, notificationChain);
            }
            case 6: {
                return ((InternalEList)this.getNodeLabels()).basicRemove((Object)internalEObject, notificationChain);
            }
            case 13: {
                return ((InternalEList)this.getUnresolvedIdentifiables()).basicRemove((Object)internalEObject, notificationChain);
            }
            case 14: {
                return ((InternalEList)this.getDecorators()).basicRemove((Object)internalEObject, notificationChain);
            }
            case 15: {
                return this.basicSetTime(null, notificationChain);
            }
        }
        return super.eInverseRemove(internalEObject, n, notificationChain);
    }

    @Override
    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 3: {
                if (bl2) {
                    return this.getEdges();
                }
                return this.getEdges().map();
            }
            case 4: {
                if (bl2) {
                    return this.getNodes();
                }
                return this.getNodes().map();
            }
            case 5: {
                if (bl2) {
                    return this.getGraphLabels();
                }
                return this.getGraphLabels().map();
            }
            case 6: {
                if (bl2) {
                    return this.getNodeLabels();
                }
                return this.getNodeLabels().map();
            }
            case 7: {
                return this.getDynamicLabels();
            }
            case 8: {
                return new Integer(this.getNumEdges());
            }
            case 9: {
                return new Integer(this.getNumNodes());
            }
            case 10: {
                return new Integer(this.getNumGraphLabels());
            }
            case 11: {
                return new Integer(this.getNumNodeLabels());
            }
            case 12: {
                return new Integer(this.getNumDynamicLabels());
            }
            case 13: {
                return this.getUnresolvedIdentifiables();
            }
            case 14: {
                return this.getDecorators();
            }
            case 15: {
                return this.getTime();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    @Override
    public void eSet(int n, Object object) {
        switch (n) {
            case 3: {
                ((EStructuralFeature.Setting)this.getEdges()).set(object);
                return;
            }
            case 4: {
                ((EStructuralFeature.Setting)this.getNodes()).set(object);
                return;
            }
            case 5: {
                ((EStructuralFeature.Setting)this.getGraphLabels()).set(object);
                return;
            }
            case 6: {
                ((EStructuralFeature.Setting)this.getNodeLabels()).set(object);
                return;
            }
            case 7: {
                this.getDynamicLabels().clear();
                this.getDynamicLabels().addAll((Collection)object);
                return;
            }
            case 13: {
                this.getUnresolvedIdentifiables().clear();
                this.getUnresolvedIdentifiables().addAll((Collection)object);
                return;
            }
            case 14: {
                this.getDecorators().clear();
                this.getDecorators().addAll((Collection)object);
                return;
            }
            case 15: {
                this.setTime((STEMTime)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    @Override
    public void eUnset(int n) {
        switch (n) {
            case 3: {
                this.getEdges().clear();
                return;
            }
            case 4: {
                this.getNodes().clear();
                return;
            }
            case 5: {
                this.getGraphLabels().clear();
                return;
            }
            case 6: {
                this.getNodeLabels().clear();
                return;
            }
            case 7: {
                this.getDynamicLabels().clear();
                return;
            }
            case 13: {
                this.getUnresolvedIdentifiables().clear();
                return;
            }
            case 14: {
                this.getDecorators().clear();
                return;
            }
            case 15: {
                this.setTime(null);
                return;
            }
        }
        super.eUnset(n);
    }

    @Override
    public boolean eIsSet(int n) {
        switch (n) {
            case 3: {
                return this.edges != null && !this.edges.isEmpty();
            }
            case 4: {
                return this.nodes != null && !this.nodes.isEmpty();
            }
            case 5: {
                return this.graphLabels != null && !this.graphLabels.isEmpty();
            }
            case 6: {
                return this.nodeLabels != null && !this.nodeLabels.isEmpty();
            }
            case 7: {
                return this.dynamicLabels != null && !this.dynamicLabels.isEmpty();
            }
            case 8: {
                return this.getNumEdges() != 0;
            }
            case 9: {
                return this.getNumNodes() != 0;
            }
            case 10: {
                return this.getNumGraphLabels() != 0;
            }
            case 11: {
                return this.getNumNodeLabels() != 0;
            }
            case 12: {
                return this.getNumDynamicLabels() != 0;
            }
            case 13: {
                return this.unresolvedIdentifiables != null && !this.unresolvedIdentifiables.isEmpty();
            }
            case 14: {
                return this.decorators != null && !this.decorators.isEmpty();
            }
            case 15: {
                return this.time != null;
            }
        }
        return super.eIsSet(n);
    }
}

