/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.graph.impl;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.impl.IdentifiableImpl;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.GraphPackage;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeImpl
extends IdentifiableImpl
implements Node {
    static int nodeCounter = 0;
    protected EList<Edge> edges;
    protected EList<NodeLabel> labels;

    protected NodeImpl() {
        this.setURI(STEMURI.createURI("node/" + Integer.toString(nodeCounter++)));
        this.setTypeURI(STEMURI.NODE_TYPE_URI);
    }

    @Override
    protected EClass eStaticClass() {
        return GraphPackage.Literals.NODE;
    }

    @Override
    public EList<Edge> getEdges() {
        if (this.edges == null) {
            this.edges = new EObjectResolvingEList(Edge.class, (InternalEObject)this, 3);
        }
        return this.edges;
    }

    @Override
    public EList<NodeLabel> getLabels() {
        if (this.labels == null) {
            this.labels = new EObjectWithInverseResolvingEList(NodeLabel.class, (InternalEObject)this, 4, 6);
        }
        return this.labels;
    }

    public NotificationChain eInverseAdd(InternalEObject internalEObject, int n, NotificationChain notificationChain) {
        switch (n) {
            case 4: {
                return ((InternalEList)this.getLabels()).basicAdd((Object)internalEObject, notificationChain);
            }
        }
        return super.eInverseAdd(internalEObject, n, notificationChain);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject internalEObject, int n, NotificationChain notificationChain) {
        switch (n) {
            case 4: {
                return ((InternalEList)this.getLabels()).basicRemove((Object)internalEObject, notificationChain);
            }
        }
        return super.eInverseRemove(internalEObject, n, notificationChain);
    }

    @Override
    public boolean sane() {
        boolean bl = super.sane();
        if (this.labels != null) {
            Iterator iterator = this.getLabels().iterator();
            while (iterator.hasNext() && bl) {
                NodeLabel nodeLabel = (NodeLabel)iterator.next();
                boolean bl2 = bl = bl && nodeLabel.getURIOfIdentifiableToBeLabeled().equals((Object)this.getURI());
                assert (bl);
            }
        }
        return bl;
    }

    @Override
    public String toString() {
        String string = this.getDublinCore().getTitle();
        return string != null ? string : super.toString();
    }

    @Override
    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 3: {
                return this.getEdges();
            }
            case 4: {
                return this.getLabels();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    @Override
    public void eSet(int n, Object object) {
        switch (n) {
            case 3: {
                this.getEdges().clear();
                this.getEdges().addAll((Collection)object);
                return;
            }
            case 4: {
                this.getLabels().clear();
                this.getLabels().addAll((Collection)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    @Override
    public void eUnset(int n) {
        switch (n) {
            case 3: {
                this.getEdges().clear();
                return;
            }
            case 4: {
                this.getLabels().clear();
                return;
            }
        }
        super.eUnset(n);
    }

    @Override
    public boolean eIsSet(int n) {
        switch (n) {
            case 3: {
                return this.edges != null && !this.edges.isEmpty();
            }
            case 4: {
                return this.labels != null && !this.labels.isEmpty();
            }
        }
        return super.eIsSet(n);
    }
}

