/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.graph.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationWrapper;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.common.provider.CoreEditPlugin;
import org.eclipse.stem.core.common.provider.IdentifiableItemProvider;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.GraphFactory;
import org.eclipse.stem.core.graph.GraphPackage;
import org.eclipse.stem.core.graph.Label;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.graph.provider.GraphEditPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphItemProvider
extends IdentifiableItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    private List<TransientGraphItemProvider> children;

    public GraphItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addTimePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    public Object getParent(Object object) {
        return super.getParent(object);
    }

    public Collection<?> getChildren(Object object) {
        Graph graph = (Graph)object;
        this.children = new ArrayList<TransientGraphItemProvider>();
        if (graph.getNumEdges() > 0) {
            this.children.add(new EdgesItemProvider(this.adapterFactory, graph));
        }
        if (graph.getNumNodes() > 0) {
            this.children.add(new NodesItemProvider(this.adapterFactory, graph));
        }
        if (graph.getNumNodeLabels() > 0) {
            this.children.add(new NodeLabelsItemProvider(this.adapterFactory, graph));
        }
        if (graph.getNumGraphLabels() > 0) {
            this.children.add(new GraphLabelsItemProvider(this.adapterFactory, graph));
        }
        Collection collection = super.getChildren(object);
        collection.addAll(this.children);
        return collection;
    }

    protected void addTimePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Graph_time_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Graph_time_feature", "_UI_Graph_type"), (EStructuralFeature)GraphPackage.Literals.GRAPH__TIME, false, false, true, null, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(GraphPackage.Literals.GRAPH__UNRESOLVED_IDENTIFIABLES);
            this.childrenFeatures.add(GraphPackage.Literals.GRAPH__DECORATORS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object object2) {
        return super.getChildFeature(object, object2);
    }

    @Override
    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/customobj16/Graph"));
    }

    @Override
    public String getText(Object object) {
        return super.getText(object);
    }

    @Override
    public String getTextGen(Object object) {
        URI uRI = ((Graph)object).getURI();
        String string = uRI == null ? null : uRI.toString();
        return string == null || string.length() == 0 ? this.getString("_UI_Graph_type") : String.valueOf(this.getString("_UI_Graph_type")) + " " + string;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Graph.class)) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public void notifyChangedGen(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Graph.class)) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 13: 
            case 14: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> collection, Object object) {
        super.collectNewChildDescriptors(collection, object);
    }

    @Override
    public ResourceLocator getResourceLocator() {
        return CoreEditPlugin.INSTANCE;
    }

    public void dispose() {
        super.dispose();
        if (this.children != null) {
            Iterator<TransientGraphItemProvider> iterator = this.children.iterator();
            while (iterator.hasNext()) {
                ((IDisposable)iterator.next()).dispose();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EdgesItemProvider
    extends TransientGraphItemProvider {
        public EdgesItemProvider(AdapterFactory adapterFactory, Graph graph) {
            super(adapterFactory, graph);
        }

        public Object getImage(Object object) {
            return this.overlayImage(object, this.getResourceLocator().getImage("full/customobj16/Edge"));
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getFeatureID(Graph.class)) {
                case 3: {
                    this.fireNotifyChanged((Notification)new NotificationWrapper((Object)this, notification));
                    return;
                }
            }
        }

        protected void collectNewChildDescriptors(Collection<Object> collection, Object object) {
            super.collectNewChildDescriptors(collection, object);
            collection.add(this.createChildParameter(GraphPackage.eINSTANCE.getGraph_Edges(), GraphFactory.eINSTANCE.createEdge()));
        }

        @Override
        protected String getText() {
            return "Edges";
        }

        protected EMap<URI, Edge> getIdentifiableMap(Graph graph) {
            return graph.getEdges();
        }

        @Override
        protected EObject getMapEntry(URI uRI, Identifiable identifiable) {
            EObject eObject = GraphFactory.eINSTANCE.create(GraphPackage.Literals.URI_TO_EDGE_MAP_ENTRY);
            eObject.eSet((EStructuralFeature)GraphPackage.Literals.URI_TO_EDGE_MAP_ENTRY__KEY, (Object)uRI);
            eObject.eSet((EStructuralFeature)GraphPackage.Literals.URI_TO_EDGE_MAP_ENTRY__VALUE, (Object)identifiable);
            return eObject;
        }

        @Override
        protected EStructuralFeature getMapEntryValueEReference() {
            return GraphPackage.eINSTANCE.getURIToEdgeMapEntry_Value();
        }

        @Override
        protected EReference getMapReference() {
            return GraphPackage.Literals.GRAPH__EDGES;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class GraphLabelsItemProvider
    extends TransientGraphItemProvider {
        public GraphLabelsItemProvider(AdapterFactory adapterFactory, Graph graph) {
            super(adapterFactory, graph);
        }

        public Object getImage(Object object) {
            return this.overlayImage(object, this.getResourceLocator().getImage("full/customobj16/StaticLabel"));
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getFeatureID(Graph.class)) {
                case 5: {
                    this.fireNotifyChanged((Notification)new NotificationWrapper((Object)this, notification));
                    return;
                }
            }
        }

        protected void collectNewChildDescriptors(Collection<Object> collection, Object object) {
            super.collectNewChildDescriptors(collection, object);
        }

        @Override
        protected String getText() {
            return "Graph Labels";
        }

        protected EMap<URI, Label> getIdentifiableMap(Graph graph) {
            return graph.getGraphLabels();
        }

        @Override
        protected EObject getMapEntry(URI uRI, Identifiable identifiable) {
            EObject eObject = GraphFactory.eINSTANCE.create(GraphPackage.Literals.URI_TO_LABEL_MAP_ENTRY);
            eObject.eSet((EStructuralFeature)GraphPackage.Literals.URI_TO_LABEL_MAP_ENTRY__KEY, (Object)uRI);
            eObject.eSet((EStructuralFeature)GraphPackage.Literals.URI_TO_LABEL_MAP_ENTRY__VALUE, (Object)identifiable);
            return eObject;
        }

        @Override
        protected EStructuralFeature getMapEntryValueEReference() {
            return GraphPackage.eINSTANCE.getURIToLabelMapEntry_Value();
        }

        @Override
        protected EReference getMapReference() {
            return GraphPackage.Literals.GRAPH__GRAPH_LABELS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NodeLabelsItemProvider
    extends TransientGraphItemProvider {
        public NodeLabelsItemProvider(AdapterFactory adapterFactory, Graph graph) {
            super(adapterFactory, graph);
        }

        public Object getImage(Object object) {
            return this.overlayImage(object, this.getResourceLocator().getImage("full/customobj16/StaticLabel"));
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getFeatureID(Graph.class)) {
                case 6: {
                    this.fireNotifyChanged((Notification)new NotificationWrapper((Object)this, notification));
                    return;
                }
            }
        }

        protected void collectNewChildDescriptors(Collection<Object> collection, Object object) {
            super.collectNewChildDescriptors(collection, object);
        }

        @Override
        protected String getText() {
            return "Node Labels";
        }

        protected EMap<URI, NodeLabel> getIdentifiableMap(Graph graph) {
            return graph.getNodeLabels();
        }

        @Override
        protected EObject getMapEntry(URI uRI, Identifiable identifiable) {
            EObject eObject = GraphFactory.eINSTANCE.create(GraphPackage.Literals.URI_TO_NODE_LABEL_MAP_ENTRY);
            eObject.eSet((EStructuralFeature)GraphPackage.Literals.URI_TO_NODE_LABEL_MAP_ENTRY__KEY, (Object)uRI);
            eObject.eSet((EStructuralFeature)GraphPackage.Literals.URI_TO_NODE_LABEL_MAP_ENTRY__VALUE, (Object)identifiable);
            return eObject;
        }

        @Override
        protected EStructuralFeature getMapEntryValueEReference() {
            return GraphPackage.eINSTANCE.getURIToNodeLabelMapEntry_Value();
        }

        @Override
        protected EReference getMapReference() {
            return GraphPackage.Literals.GRAPH__NODE_LABELS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NodesItemProvider
    extends TransientGraphItemProvider {
        public NodesItemProvider(AdapterFactory adapterFactory, Graph graph) {
            super(adapterFactory, graph);
        }

        public Object getImage(Object object) {
            return this.overlayImage(object, this.getResourceLocator().getImage("full/customobj16/Node"));
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getFeatureID(Graph.class)) {
                case 4: {
                    this.fireNotifyChanged((Notification)new NotificationWrapper((Object)this, notification));
                    return;
                }
            }
        }

        protected void collectNewChildDescriptors(Collection<Object> collection, Object object) {
            super.collectNewChildDescriptors(collection, object);
            collection.add(this.createChildParameter(GraphPackage.eINSTANCE.getGraph_Nodes(), GraphFactory.eINSTANCE.createNode()));
        }

        @Override
        protected String getText() {
            return "Nodes";
        }

        protected EMap<URI, Node> getIdentifiableMap(Graph graph) {
            return graph.getNodes();
        }

        @Override
        protected EObject getMapEntry(URI uRI, Identifiable identifiable) {
            EObject eObject = GraphFactory.eINSTANCE.create(GraphPackage.Literals.URI_TO_NODE_MAP_ENTRY);
            eObject.eSet((EStructuralFeature)GraphPackage.Literals.URI_TO_NODE_MAP_ENTRY__KEY, (Object)uRI);
            eObject.eSet((EStructuralFeature)GraphPackage.Literals.URI_TO_NODE_MAP_ENTRY__VALUE, (Object)identifiable);
            return eObject;
        }

        @Override
        protected EStructuralFeature getMapEntryValueEReference() {
            return GraphPackage.eINSTANCE.getURIToNodeMapEntry_Value();
        }

        @Override
        protected EReference getMapReference() {
            return GraphPackage.Literals.GRAPH__NODES;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class TransientGraphItemProvider
    extends ItemProviderAdapter
    implements IEditingDomainItemProvider,
    IStructuredItemContentProvider,
    ITreeItemContentProvider,
    IItemLabelProvider,
    IItemPropertySource {
        public TransientGraphItemProvider(AdapterFactory adapterFactory, Graph graph) {
            super(adapterFactory);
            graph.eAdapters().add((Object)this);
        }

        protected Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
            if (this.childrenFeatures == null) {
                super.getChildrenFeatures(object);
                this.childrenFeatures.add(this.getMapReference());
            }
            return this.childrenFeatures;
        }

        protected Object getFeatureValue(EObject eObject, EStructuralFeature eStructuralFeature) {
            if (eObject == null) {
                return ((Graph)this.target).eGet(eStructuralFeature);
            }
            return super.getFeatureValue(eObject, eStructuralFeature);
        }

        public Object getParent(Object object) {
            return this.target;
        }

        public Collection<Identifiable> getChildren(Object object) {
            Graph graph = (Graph)this.target;
            ArrayList<Identifiable> arrayList = new ArrayList<Identifiable>();
            arrayList.addAll(this.getIdentifiableMap(graph).values());
            Collections.sort(arrayList);
            return arrayList;
        }

        public String getText(Object object) {
            StringBuilder stringBuilder = new StringBuilder(this.getText());
            stringBuilder.append(" (");
            stringBuilder.append(Integer.toString(this.getIdentifiableMap((Graph)this.target).size()));
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        protected String getFeatureText(Object object) {
            return super.getFeatureText((Object)this.target);
        }

        public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain, Object object2) {
            return super.getNewChildDescriptors((Object)this.target, editingDomain, object2);
        }

        public ResourceLocator getResourceLocator() {
            return GraphEditPlugin.INSTANCE;
        }

        protected abstract String getText();

        protected abstract EMap<URI, ? extends Identifiable> getIdentifiableMap(Graph var1);

        protected abstract EObject getMapEntry(URI var1, Identifiable var2);

        protected abstract EStructuralFeature getMapEntryValueEReference();

        protected abstract EReference getMapReference();

        protected Command createRemoveCommand(EditingDomain editingDomain, EObject eObject, EStructuralFeature eStructuralFeature, Collection<?> collection) {
            return this.createWrappedCommand(super.createRemoveCommand(editingDomain, eObject, eStructuralFeature, collection), eObject);
        }

        protected Command createAddCommand(EditingDomain editingDomain, EObject eObject, EStructuralFeature eStructuralFeature, Collection<?> collection, int n) {
            return this.createWrappedCommand(super.createAddCommand(editingDomain, eObject, eStructuralFeature, collection, n), eObject);
        }

        protected Command createDragAndDropCommand(EditingDomain editingDomain, Object object, float f, int n, int n2, Collection<?> collection) {
            Object object2 = null;
            object2 = new AddCommand(editingDomain, (EObject)this.target, (EStructuralFeature)this.getMapReference(), collection).canExecute() ? super.createDragAndDropCommand(editingDomain, (Object)this.target, f, n, n2, collection) : UnexecutableCommand.INSTANCE;
            return object2;
        }

        protected Command createCreateChildCommand(EditingDomain editingDomain, EObject eObject, EStructuralFeature eStructuralFeature, Object object, int n, Collection<?> collection) {
            Object object2 = null;
            object2 = !(object instanceof Identifiable) ? super.createCreateChildCommand(editingDomain, eObject, eStructuralFeature, object, n, collection) : new CreateChildCommand(editingDomain, eObject, eStructuralFeature, object, n, collection, (CreateChildCommand.Helper)this){

                protected Command createCommand() {
                    SetCommand setCommand = null;
                    Graph graph = (Graph)TransientGraphItemProvider.this.target;
                    Identifiable identifiable = (Identifiable)this.child;
                    URI uRI = identifiable.getURI();
                    Identifiable identifiable2 = (Identifiable)TransientGraphItemProvider.this.getIdentifiableMap(graph).get((Object)uRI);
                    if (identifiable2 == null) {
                        EObject eObject = TransientGraphItemProvider.this.getMapEntry(uRI, identifiable);
                        setCommand = new AddCommand(this.domain, (EObject)graph, (EStructuralFeature)TransientGraphItemProvider.this.getMapReference(), (Object)eObject);
                    } else {
                        EObject eObject = identifiable2.eContainer();
                        setCommand = new SetCommand(this.domain, eObject, TransientGraphItemProvider.this.getMapEntryValueEReference(), (Object)identifiable);
                    }
                    return setCommand;
                }
            };
            return object2;
        }

        protected Command createWrappedCommand(Command command, final EObject eObject) {
            return new CommandWrapper(command){

                public Collection<?> getAffectedObjects() {
                    Set<TransientGraphItemProvider> set = super.getAffectedObjects();
                    if (set.contains(eObject)) {
                        set = Collections.singleton(TransientGraphItemProvider.this);
                    }
                    return set;
                }
            };
        }
    }
}

