/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.model.impl;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.common.impl.IdentifiableImpl;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.GraphFactory;
import org.eclipse.stem.core.graph.GraphPackage;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.EdgeDecorator;
import org.eclipse.stem.core.model.GraphDecorator;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.model.ModelPackage;
import org.eclipse.stem.core.model.NodeDecorator;
import org.eclipse.stem.core.scenario.impl.ScenarioImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelImpl
extends IdentifiableImpl
implements Model {
    static int modelCounter = 0;
    protected EList<Model> models;
    protected EList<Graph> graphs;
    protected EList<GraphDecorator> graphDecorators;
    protected EList<NodeDecorator> nodeDecorators;
    protected EList<EdgeDecorator> edgeDecorators;

    protected ModelImpl() {
        this.setURI(STEMURI.createURI("model/" + Integer.toString(modelCounter++)));
        this.setTypeURI(STEMURI.MODEL_TYPE_URI);
    }

    @Override
    protected EClass eStaticClass() {
        return ModelPackage.Literals.MODEL;
    }

    @Override
    public EList<Model> getModels() {
        if (this.models == null) {
            this.models = new EObjectResolvingEList(Model.class, (InternalEObject)this, 3);
        }
        return this.models;
    }

    @Override
    public EList<Graph> getGraphs() {
        if (this.graphs == null) {
            this.graphs = new EObjectResolvingEList(Graph.class, (InternalEObject)this, 4);
        }
        return this.graphs;
    }

    @Override
    public EList<GraphDecorator> getGraphDecorators() {
        if (this.graphDecorators == null) {
            this.graphDecorators = new EObjectResolvingEList(GraphDecorator.class, (InternalEObject)this, 5);
        }
        return this.graphDecorators;
    }

    @Override
    public EList<NodeDecorator> getNodeDecorators() {
        if (this.nodeDecorators == null) {
            this.nodeDecorators = new EObjectResolvingEList(NodeDecorator.class, (InternalEObject)this, 6);
        }
        return this.nodeDecorators;
    }

    @Override
    public EList<EdgeDecorator> getEdgeDecorators() {
        if (this.edgeDecorators == null) {
            this.edgeDecorators = new EObjectResolvingEList(EdgeDecorator.class, (InternalEObject)this, 7);
        }
        return this.edgeDecorators;
    }

    @Override
    public Graph getCanonicalGraph(URI uRI) {
        Graph graph = GraphFactory.eINSTANCE.createGraph();
        graph.setURI(uRI);
        for (Identifiable identifiable : this.getModels()) {
            graph.addGraph(identifiable.getCanonicalGraph(uRI));
        }
        for (Identifiable identifiable : this.getGraphs()) {
            Graph graph2 = (Graph)EcoreUtil.copy((EObject)identifiable);
            graph.addGraph(graph2);
        }
        this.resolveURIs(this, graph);
        this.invokeNodeDecorators(graph);
        this.invokeEdgeDecorators(graph);
        this.invokeGraphDecorators(graph);
        DublinCore dublinCore = graph.getDublinCore();
        dublinCore.populate();
        dublinCore.setFormat("http:///org/eclipse/stem/core/graph.ecore");
        return graph;
    }

    private void resolveURIs(Model model, Graph graph) {
        Object object;
        Node node;
        for (Identifiable identifiable : graph.getEdges().values()) {
            if (!identifiable.eIsSet((EStructuralFeature)GraphPackage.Literals.EDGE__A)) {
                node = graph.getNode(identifiable.getNodeAURI());
                if (node != null) {
                    identifiable.setA(node);
                    node.getEdges().add((Object)identifiable);
                } else {
                    object = GraphFactory.eINSTANCE.createUnresolvedIdentifiable();
                    object.setModel(model);
                    object.setGraph(graph);
                    object.setUnresolvedURI(identifiable.getNodeAURI());
                    object.setIdentifiable(identifiable);
                    object.setFieldName("NODE_A");
                    if (ScenarioImpl.reportDanglingAirTransportEdges || !identifiable.getURI().toString().contains("/pipetransport")) {
                        graph.getUnresolvedIdentifiables().add(object);
                    }
                }
            }
            if (identifiable.eIsSet((EStructuralFeature)GraphPackage.Literals.EDGE__B) || !identifiable.eIsSet((EStructuralFeature)GraphPackage.Literals.EDGE__A)) continue;
            node = graph.getNode(identifiable.getNodeBURI());
            if (node != null) {
                identifiable.setB(node);
                node.getEdges().add((Object)identifiable);
                continue;
            }
            if (identifiable.getA() != null) {
                object = identifiable.getA();
                identifiable.setA(null);
                object.getEdges().remove((Object)identifiable);
            }
            object = GraphFactory.eINSTANCE.createUnresolvedIdentifiable();
            object.setModel(model);
            object.setGraph(graph);
            object.setUnresolvedURI(identifiable.getNodeBURI());
            object.setIdentifiable(identifiable);
            object.setFieldName("NODE_B");
            if (!ScenarioImpl.reportDanglingAirTransportEdges && identifiable.getURI().toString().contains("/pipetransport")) continue;
            graph.getUnresolvedIdentifiables().add(object);
        }
        for (Identifiable identifiable : graph.getNodeLabels().values()) {
            node = graph.getNode(identifiable.getURIOfIdentifiableToBeLabeled());
            if (node != null) {
                node.getLabels().add((Object)identifiable);
                continue;
            }
            object = GraphFactory.eINSTANCE.createUnresolvedIdentifiable();
            object.setModel(model);
            object.setGraph(graph);
            object.setUnresolvedURI(identifiable.getURIOfIdentifiableToBeLabeled());
            object.setIdentifiable(identifiable);
            object.setFieldName("Node");
            graph.getUnresolvedIdentifiables().add(object);
        }
    }

    private void invokeNodeDecorators(Graph graph) {
        for (NodeDecorator nodeDecorator : this.getNodeDecorators()) {
            Decorator decorator = (Decorator)EcoreUtil.copy((EObject)nodeDecorator);
            graph.getDecorators().add((Object)decorator);
            decorator.decorateGraph();
        }
    }

    private void invokeEdgeDecorators(Graph graph) {
        for (EdgeDecorator edgeDecorator : this.getEdgeDecorators()) {
            Decorator decorator = (Decorator)EcoreUtil.copy((EObject)edgeDecorator);
            graph.getDecorators().add((Object)decorator);
            decorator.decorateGraph();
        }
    }

    private void invokeGraphDecorators(Graph graph) {
        for (GraphDecorator graphDecorator : this.getGraphDecorators()) {
            Decorator decorator = (Decorator)EcoreUtil.copy((EObject)graphDecorator);
            graph.getDecorators().add((Object)decorator);
            decorator.decorateGraph();
        }
    }

    @Override
    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 3: {
                return this.getModels();
            }
            case 4: {
                return this.getGraphs();
            }
            case 5: {
                return this.getGraphDecorators();
            }
            case 6: {
                return this.getNodeDecorators();
            }
            case 7: {
                return this.getEdgeDecorators();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    @Override
    public void eSet(int n, Object object) {
        switch (n) {
            case 3: {
                this.getModels().clear();
                this.getModels().addAll((Collection)object);
                return;
            }
            case 4: {
                this.getGraphs().clear();
                this.getGraphs().addAll((Collection)object);
                return;
            }
            case 5: {
                this.getGraphDecorators().clear();
                this.getGraphDecorators().addAll((Collection)object);
                return;
            }
            case 6: {
                this.getNodeDecorators().clear();
                this.getNodeDecorators().addAll((Collection)object);
                return;
            }
            case 7: {
                this.getEdgeDecorators().clear();
                this.getEdgeDecorators().addAll((Collection)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    @Override
    public void eUnset(int n) {
        switch (n) {
            case 3: {
                this.getModels().clear();
                return;
            }
            case 4: {
                this.getGraphs().clear();
                return;
            }
            case 5: {
                this.getGraphDecorators().clear();
                return;
            }
            case 6: {
                this.getNodeDecorators().clear();
                return;
            }
            case 7: {
                this.getEdgeDecorators().clear();
                return;
            }
        }
        super.eUnset(n);
    }

    @Override
    public boolean eIsSet(int n) {
        switch (n) {
            case 3: {
                return this.models != null && !this.models.isEmpty();
            }
            case 4: {
                return this.graphs != null && !this.graphs.isEmpty();
            }
            case 5: {
                return this.graphDecorators != null && !this.graphDecorators.isEmpty();
            }
            case 6: {
                return this.nodeDecorators != null && !this.nodeDecorators.isEmpty();
            }
            case 7: {
                return this.edgeDecorators != null && !this.edgeDecorators.isEmpty();
            }
        }
        return super.eIsSet(n);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("\"" + this.dublinCore.getTitle() + "\"\n");
        stringBuilder.append(this.models != null ? String.valueOf(this.models.size()) + " models\n" : "");
        stringBuilder.append(this.graphs != null ? String.valueOf(this.graphs.size()) + " graphs\n" : "");
        stringBuilder.append(this.graphDecorators != null ? String.valueOf(this.graphDecorators.size()) + " graph decorators\n" : "");
        stringBuilder.append(this.nodeDecorators != null ? String.valueOf(this.nodeDecorators.size()) + " node decorators\n" : "");
        stringBuilder.append(this.edgeDecorators != null ? String.valueOf(this.edgeDecorators.size()) + "edge decorators\n" : "");
        return stringBuilder.toString();
    }

    @Override
    public boolean sane() {
        Identifiable identifiable;
        Iterator iterator;
        boolean bl = super.sane();
        if (bl && this.models != null) {
            iterator = this.models.iterator();
            while (iterator.hasNext() && bl) {
                identifiable = (Model)iterator.next();
                boolean bl2 = bl = bl && identifiable.sane();
                assert (bl);
            }
        }
        if (bl && this.graphs != null) {
            iterator = this.graphs.iterator();
            while (iterator.hasNext() && bl) {
                identifiable = (Graph)iterator.next();
                boolean bl3 = bl = bl && identifiable.sane();
                assert (bl);
            }
        }
        if (bl && this.graphDecorators != null) {
            iterator = this.graphDecorators.iterator();
            while (iterator.hasNext() && bl) {
                identifiable = (GraphDecorator)iterator.next();
                boolean bl4 = bl = bl && identifiable.sane();
                assert (bl);
            }
        }
        if (bl && this.nodeDecorators != null) {
            iterator = this.nodeDecorators.iterator();
            while (iterator.hasNext() && bl) {
                identifiable = (NodeDecorator)iterator.next();
                boolean bl5 = bl = bl && identifiable.sane();
                assert (bl);
            }
        }
        if (bl && this.edgeDecorators != null) {
            iterator = this.edgeDecorators.iterator();
            while (iterator.hasNext() && bl) {
                identifiable = (EdgeDecorator)iterator.next();
                boolean bl6 = bl = bl && identifiable.sane();
                assert (bl);
            }
        }
        return bl;
    }
}

