/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.modifier.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stem.core.CorePlugin;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.common.SanityChecker;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.StaticLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.model.impl.DecoratorImpl;
import org.eclipse.stem.core.modifier.FeatureModifier;
import org.eclipse.stem.core.modifier.Modifier;
import org.eclipse.stem.core.modifier.ModifierPackage;
import org.eclipse.stem.core.scenario.Scenario;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifierImpl
extends DecoratorImpl
implements Modifier {
    protected static final URI TARGET_URI_EDEFAULT = null;
    protected URI targetURI = TARGET_URI_EDEFAULT;
    protected EList<FeatureModifier> featureModifiers;
    private boolean complete = false;
    private static int modifierCounter = 0;
    protected static final boolean COMPLETE_EDEFAULT = false;

    protected ModifierImpl() {
        this.setURI(STEMURI.createURI("modifier/" + Integer.toString(modifierCounter++)));
        this.setTypeURI(STEMURI.MODIFIER_TYPE_URI);
    }

    @Override
    protected EClass eStaticClass() {
        return ModifierPackage.Literals.MODIFIER;
    }

    @Override
    public URI getTargetURI() {
        return this.targetURI;
    }

    @Override
    public void setTargetURI(URI uRI) {
        URI uRI2 = this.targetURI;
        this.targetURI = uRI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)uRI2, (Object)this.targetURI));
        }
    }

    @Override
    public EList<FeatureModifier> getFeatureModifiers() {
        if (this.featureModifiers == null) {
            this.featureModifiers = new EObjectContainmentEList(FeatureModifier.class, (InternalEObject)this, 9);
        }
        return this.featureModifiers;
    }

    @Override
    public boolean isComplete() {
        if (this.complete) {
            return true;
        }
        boolean bl = true;
        for (FeatureModifier featureModifier : this.getFeatureModifiers()) {
            bl = featureModifier.isComplete();
            if (!bl) break;
        }
        return bl;
    }

    @Override
    public void reset() {
        for (FeatureModifier featureModifier : this.getFeatureModifiers()) {
            featureModifier.reset();
        }
    }

    @Override
    public void resetLabels() {
        this.reset();
    }

    @Override
    public void decorateGraph() {
    }

    @Override
    public void updateLabels(STEMTime sTEMTime, long l, int n) {
        this.modifyIdentifiable(this.getIdentifiable(this.getGraph()));
    }

    @Override
    public void updateScenario(Scenario scenario) {
        this.modifyIdentifiable(this.getIdentifiable(scenario));
    }

    private Identifiable getIdentifiable(Scenario scenario) {
        Identifiable identifiable = null;
        if (scenario.getSequencer().getURI().equals((Object)this.targetURI)) {
            identifiable = scenario.getSequencer();
        } else {
            for (Decorator decorator : scenario.getScenarioDecorators()) {
                if (!decorator.getURI().equals((Object)this.targetURI)) continue;
                identifiable = decorator;
                break;
            }
            if (identifiable == null) {
                if (scenario.getCanonicalGraph() == null) {
                    scenario.initialize();
                }
                identifiable = this.getIdentifiable(scenario.getCanonicalGraph());
            }
        }
        return identifiable;
    }

    private Identifiable getIdentifiable(Graph graph) {
        Identifiable identifiable = null;
        for (Identifiable identifiable2 : graph.getDecorators()) {
            if (!identifiable2.getURI().equals((Object)this.targetURI)) continue;
            identifiable = identifiable2;
            break;
        }
        if (identifiable == null) {
            for (Identifiable identifiable2 : graph.getNodeLabels().values()) {
                if (!identifiable2.getURI().equals((Object)this.targetURI)) continue;
                identifiable = identifiable2;
                break;
            }
        }
        if (identifiable == null) {
            for (Identifiable identifiable2 : graph.getEdges().values()) {
                if (!identifiable2.getLabel().getURI().equals((Object)this.targetURI)) continue;
                identifiable = identifiable2.getLabel();
                break;
            }
        }
        return identifiable;
    }

    private void modifyIdentifiable(Identifiable identifiable) {
        if (identifiable != null) {
            for (FeatureModifier featureModifier : this.getFeatureModifiers()) {
                SanityChecker sanityChecker = identifiable;
                if (identifiable instanceof StaticLabel) {
                    StaticLabel staticLabel = (StaticLabel)identifiable;
                    sanityChecker = staticLabel.getCurrentValue();
                }
                featureModifier.setTarget((EObject)sanityChecker);
                featureModifier.updateFeature();
            }
        } else {
            CorePlugin.logError("Modifier \"" + this.getDublinCore().getTitle() + "\" could not find target \"" + this.getTargetURI().toString() + "\"", null);
            this.complete = true;
        }
    }

    @Override
    public List<String> getModificationSummary() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (FeatureModifier featureModifier : this.getFeatureModifiers()) {
            arrayList.add(featureModifier.getModificationSummary());
        }
        return arrayList;
    }

    @Override
    public boolean sane() {
        boolean bl = super.sane();
        assert (bl);
        for (FeatureModifier featureModifier : this.getFeatureModifiers()) {
            boolean bl2 = bl = bl && featureModifier.sane();
            assert (bl);
        }
        return bl;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject internalEObject, int n, NotificationChain notificationChain) {
        switch (n) {
            case 9: {
                return ((InternalEList)this.getFeatureModifiers()).basicRemove((Object)internalEObject, notificationChain);
            }
        }
        return super.eInverseRemove(internalEObject, n, notificationChain);
    }

    @Override
    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 8: {
                return this.getTargetURI();
            }
            case 9: {
                return this.getFeatureModifiers();
            }
            case 10: {
                return this.isComplete() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return super.eGet(n, bl, bl2);
    }

    @Override
    public void eSet(int n, Object object) {
        switch (n) {
            case 8: {
                this.setTargetURI((URI)object);
                return;
            }
            case 9: {
                this.getFeatureModifiers().clear();
                this.getFeatureModifiers().addAll((Collection)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    @Override
    public void eUnset(int n) {
        switch (n) {
            case 8: {
                this.setTargetURI(TARGET_URI_EDEFAULT);
                return;
            }
            case 9: {
                this.getFeatureModifiers().clear();
                return;
            }
        }
        super.eUnset(n);
    }

    @Override
    public boolean eIsSet(int n) {
        switch (n) {
            case 8: {
                return TARGET_URI_EDEFAULT == null ? this.targetURI != null : !TARGET_URI_EDEFAULT.equals((Object)this.targetURI);
            }
            case 9: {
                return this.featureModifiers != null && !this.featureModifiers.isEmpty();
            }
            case 10: {
                return this.isComplete();
            }
        }
        return super.eIsSet(n);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (targetURI: ");
        stringBuffer.append(this.targetURI);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

