/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.scenario.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.core.CorePlugin;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.impl.IdentifiableImpl;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.UnresolvedIdentifiable;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.scenario.ScenarioPackage;
import org.eclipse.stem.core.sequencer.Sequencer;
import org.eclipse.stem.core.solver.Solver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScenarioImpl
extends IdentifiableImpl
implements Scenario {
    private int scenarioCounter = 0;
    protected static final URI CANONICAL_GRAPH_URI = URI.createURI((String)"stem:canonicalgraph");
    public static boolean reportEachUnresolvedIdentifiable = true;
    public static boolean reportDanglingAirTransportEdges = false;
    public static boolean reportNumberofUnresolvedIdentifiables = false;
    protected Model model;
    protected Sequencer sequencer;
    protected EList<Decorator> scenarioDecorators;
    protected Graph canonicalGraph;
    protected static final double PROGRESS_EDEFAULT = 0.0;
    protected double progress = 0.0;
    protected Solver solver;

    protected ScenarioImpl() {
        this.setURI(STEMURI.createURI("scenario/" + Integer.toString(this.scenarioCounter++)));
        this.setTypeURI(STEMURI.SCENARIO_TYPE_URI);
    }

    @Override
    protected EClass eStaticClass() {
        return ScenarioPackage.Literals.SCENARIO;
    }

    @Override
    public Model getModel() {
        if (this.model != null && this.model.eIsProxy()) {
            InternalEObject internalEObject = (InternalEObject)this.model;
            this.model = (Model)this.eResolveProxy(internalEObject);
            if (this.model != internalEObject && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)internalEObject, (Object)this.model));
            }
        }
        return this.model;
    }

    public Model basicGetModel() {
        return this.model;
    }

    @Override
    public void setModel(Model model) {
        Model model2 = this.model;
        this.model = model;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)model2, (Object)this.model));
        }
    }

    @Override
    public Sequencer getSequencer() {
        if (this.sequencer != null && this.sequencer.eIsProxy()) {
            InternalEObject internalEObject = (InternalEObject)this.sequencer;
            this.sequencer = (Sequencer)this.eResolveProxy(internalEObject);
            if (this.sequencer != internalEObject && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 4, (Object)internalEObject, (Object)this.sequencer));
            }
        }
        return this.sequencer;
    }

    public Sequencer basicGetSequencer() {
        return this.sequencer;
    }

    @Override
    public void setSequencer(Sequencer sequencer) {
        Sequencer sequencer2 = this.sequencer;
        this.sequencer = sequencer;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)sequencer2, (Object)this.sequencer));
        }
    }

    @Override
    public Graph getCanonicalGraph() {
        return this.canonicalGraph;
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    @Override
    public void setProgress(double d) {
        double d2 = this.progress;
        this.progress = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, d2, this.progress));
        }
    }

    @Override
    public Solver getSolver() {
        return this.solver;
    }

    public NotificationChain basicSetSolver(Solver solver, NotificationChain notificationChain) {
        Solver solver2 = this.solver;
        this.solver = solver;
        if (this.eNotificationRequired()) {
            ENotificationImpl eNotificationImpl = new ENotificationImpl((InternalEObject)this, 1, 8, (Object)solver2, (Object)solver);
            if (notificationChain == null) {
                notificationChain = eNotificationImpl;
            } else {
                notificationChain.add((Notification)eNotificationImpl);
            }
        }
        return notificationChain;
    }

    @Override
    public void setSolver(Solver solver) {
        if (solver != this.solver) {
            NotificationChain notificationChain = null;
            if (this.solver != null) {
                notificationChain = ((InternalEObject)this.solver).eInverseRemove((InternalEObject)this, -9, null, notificationChain);
            }
            if (solver != null) {
                notificationChain = ((InternalEObject)solver).eInverseAdd((InternalEObject)this, -9, null, notificationChain);
            }
            if ((notificationChain = this.basicSetSolver(solver, notificationChain)) != null) {
                notificationChain.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)solver, (Object)solver));
        }
    }

    @Override
    public boolean step() {
        if (!this.getSequencer().isTimeToStop()) {
            if (this.canonicalGraph == null) {
                this.initialize();
            }
            assert (this.sane());
            STEMTime sTEMTime = this.getSequencer().getNextTime();
            long l = this.getSequencer().getTimeDelta();
            for (Solver[] solverArray : this.canonicalGraph.getDecorators()) {
                solverArray.setProgress(0.0);
            }
            Object object = this.getSolver();
            if (object == null) {
                Solver[] solverArray;
                Solver[] solverArray2 = solverArray = this.getSolvers();
                int n = solverArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Solver solver = solverArray2[n2];
                    if (solver.getClass().getName().equals("org.eclipse.stem.solvers.fd.impl.FiniteDifferenceImpl")) {
                        object = solver;
                        this.setSolver(solver);
                        break;
                    }
                    ++n2;
                }
            }
            if (object.getDecorators() == null) {
                object.setDecorators(this.canonicalGraph.getDecorators());
            }
            object.step(sTEMTime, l, this.getSequencer().getCycle());
            assert (this.sane());
            this.canonicalGraph.switchToNextValue(sTEMTime);
        }
        return !this.getSequencer().isTimeToStop();
    }

    @Override
    public void reset() {
        this.getSequencer().reset();
        for (Decorator decorator : this.canonicalGraph.getDecorators()) {
            if (!decorator.isEnabled()) continue;
            decorator.resetLabels();
        }
        this.solver.reset();
    }

    @Override
    public void initialize() {
        this.getSequencer().reset();
        this.canonicalGraph = this.getModel().getCanonicalGraph(CANONICAL_GRAPH_URI);
        this.canonicalGraph.setTime((STEMTime)EcoreUtil.copy((EObject)this.getSequencer().getCurrentTime()));
        Iterator iterator = this.canonicalGraph.getUnresolvedIdentifiables().iterator();
        while (iterator.hasNext()) {
            UnresolvedIdentifiable unresolvedIdentifiable = (UnresolvedIdentifiable)iterator.next();
            if (this.canonicalGraph.getNodes().get((Object)unresolvedIdentifiable.getUnresolvedURI()) == null && this.canonicalGraph.getEdges().get((Object)unresolvedIdentifiable.getUnresolvedURI()) == null) continue;
            iterator.remove();
        }
        assert (this.canonicalGraph.sane());
        final double d = this.getCanonicalGraph().getDecorators().size();
        final ScenarioImpl scenarioImpl = this;
        for (Decorator decorator : this.getCanonicalGraph().getDecorators()) {
            decorator.eAdapters().add((Object)new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    Decorator cfr_ignored_0 = (Decorator)notification.getNotifier();
                    switch (notification.getFeatureID(Decorator.class)) {
                        case 7: {
                            double d2 = notification.getNewDoubleValue() - notification.getOldDoubleValue();
                            scenarioImpl.setProgress(scenarioImpl.getProgress() + (d2 /= d));
                        }
                    }
                }
            });
        }
        Iterator iterator2 = this.getScenarioDecorators().iterator();
        while (iterator2.hasNext()) {
            Decorator decorator;
            decorator = (Decorator)EcoreUtil.copy((EObject)((EObject)iterator2.next()));
            this.canonicalGraph.getDecorators().add((Object)decorator);
            decorator.decorateGraph();
            decorator.setGraphDecorated(true);
        }
        if (reportEachUnresolvedIdentifiable && this.canonicalGraph.getUnresolvedIdentifiables().size() > 0) {
            this.logUnresolvedIdentifiables();
        }
        if (reportNumberofUnresolvedIdentifiables && this.canonicalGraph.getUnresolvedIdentifiables().size() > 0) {
            this.logNumberOfUnresolvedIdentifiables();
        }
    }

    private Solver[] getSolvers() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.stem.core.solver");
        ArrayList<Solver> arrayList = new ArrayList<Solver>();
        Solver[] solverArray = new Solver[iConfigurationElementArray.length];
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (iConfigurationElement.getName().equals("classdef")) {
                try {
                    arrayList.add((Solver)iConfigurationElement.createExecutableExtension("class"));
                }
                catch (Exception exception) {
                    CorePlugin.logError("Can't create solver", exception);
                }
            }
            ++n;
        }
        solverArray = arrayList.toArray(new Solver[0]);
        return solverArray;
    }

    @Override
    public String produceTitle() {
        String string = "";
        if (this.dublinCore != null) {
            String string2 = this.dublinCore.getTitle();
            string = string2 == null ? "" : string2;
        }
        return string;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject internalEObject, int n, NotificationChain notificationChain) {
        switch (n) {
            case 8: {
                return this.basicSetSolver(null, notificationChain);
            }
        }
        return super.eInverseRemove(internalEObject, n, notificationChain);
    }

    @Override
    public EList<Decorator> getScenarioDecorators() {
        if (this.scenarioDecorators == null) {
            this.scenarioDecorators = new EObjectResolvingEList(Decorator.class, (InternalEObject)this, 5);
        }
        return this.scenarioDecorators;
    }

    private void logUnresolvedIdentifiables() {
        for (UnresolvedIdentifiable unresolvedIdentifiable : this.canonicalGraph.getUnresolvedIdentifiables()) {
            CorePlugin.logInformation("In scenario " + this.produceTitle() + "\", model \"" + unresolvedIdentifiable.getModel().getDublinCore().getTitle() + "\",  the URI \"" + unresolvedIdentifiable.getUnresolvedURI() + "\" was unresolved.", null);
        }
    }

    private void logNumberOfUnresolvedIdentifiables() {
        CorePlugin.logInformation("In scenario \"" + this.produceTitle() + "\", there were " + this.canonicalGraph.getUnresolvedIdentifiables().size() + " unresolved references.", null);
    }

    @Override
    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 3: {
                if (bl) {
                    return this.getModel();
                }
                return this.basicGetModel();
            }
            case 4: {
                if (bl) {
                    return this.getSequencer();
                }
                return this.basicGetSequencer();
            }
            case 5: {
                return this.getScenarioDecorators();
            }
            case 6: {
                return this.getCanonicalGraph();
            }
            case 7: {
                return new Double(this.getProgress());
            }
            case 8: {
                return this.getSolver();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    @Override
    public void eSet(int n, Object object) {
        switch (n) {
            case 3: {
                this.setModel((Model)object);
                return;
            }
            case 4: {
                this.setSequencer((Sequencer)object);
                return;
            }
            case 5: {
                this.getScenarioDecorators().clear();
                this.getScenarioDecorators().addAll((Collection)object);
                return;
            }
            case 7: {
                this.setProgress((Double)object);
                return;
            }
            case 8: {
                this.setSolver((Solver)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    @Override
    public void eUnset(int n) {
        switch (n) {
            case 3: {
                this.setModel(null);
                return;
            }
            case 4: {
                this.setSequencer(null);
                return;
            }
            case 5: {
                this.getScenarioDecorators().clear();
                return;
            }
            case 7: {
                this.setProgress(0.0);
                return;
            }
            case 8: {
                this.setSolver(null);
                return;
            }
        }
        super.eUnset(n);
    }

    @Override
    public boolean eIsSet(int n) {
        switch (n) {
            case 3: {
                return this.model != null;
            }
            case 4: {
                return this.sequencer != null;
            }
            case 5: {
                return this.scenarioDecorators != null && !this.scenarioDecorators.isEmpty();
            }
            case 6: {
                return this.canonicalGraph != null;
            }
            case 7: {
                return this.progress != 0.0;
            }
            case 8: {
                return this.solver != null;
            }
        }
        return super.eIsSet(n);
    }

    @Override
    public String toString() {
        String string = this.getDublinCore().getTitle();
        return string != null ? string : super.toString();
    }

    @Override
    public boolean sane() {
        boolean bl = super.sane();
        if (bl && this.model != null) {
            boolean bl2 = bl = bl && this.model.sane();
            assert (bl);
        }
        if (bl && this.canonicalGraph != null) {
            boolean bl3 = bl = bl && this.canonicalGraph.sane();
            assert (bl);
        }
        if (bl && this.sequencer != null) {
            boolean bl4 = bl = bl && this.sequencer.sane();
            assert (bl);
        }
        return bl;
    }
}

