/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.sequencer.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.CorePlugin;
import org.eclipse.stem.core.model.ModelFactory;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.sequencer.RealTimeSequencer;
import org.eclipse.stem.core.sequencer.SequencerPackage;
import org.eclipse.stem.core.sequencer.impl.SequentialSequencerImpl;

public class RealTimeSequencerImpl
extends SequentialSequencerImpl
implements RealTimeSequencer {
    private boolean getNextCalled = false;

    protected RealTimeSequencerImpl() {
    }

    public STEMTime getStartTime() {
        if (!this.getNextCalled) {
            return RealTimeSequencerImpl.getCurrentSystemTime();
        }
        return super.getStartTime();
    }

    public STEMTime getNextTime() {
        super.getNextTime();
        if (!this.getNextCalled) {
            this.getNextCalled = true;
            this.setStartTime(RealTimeSequencerImpl.getCurrentSystemTime());
        }
        STEMTime sTEMTime = this.getCurrentTime();
        STEMTime sTEMTime2 = super.getNextTime();
        this.sleepUntil(sTEMTime2, sTEMTime);
        this.setCurrentTime(RealTimeSequencerImpl.getCurrentSystemTime());
        return this.getCurrentTime();
    }

    private void sleepUntil(STEMTime sTEMTime, STEMTime sTEMTime2) {
        long l = sTEMTime.getTime().getTime() - sTEMTime2.getTime().getTime();
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            CorePlugin.logInformation("RealTimeSequencer's sleep was interrupted", interruptedException);
        }
    }

    public void setEndTime(STEMTime sTEMTime) {
        STEMTime sTEMTime2 = RealTimeSequencerImpl.getCurrentSystemTime();
        if (!this.isEndTimeBefore(sTEMTime2)) {
            throw new IllegalArgumentException("The new end time \"" + sTEMTime.toString() + "\" is not after the current time of \"" + sTEMTime2.toString() + "\"");
        }
        super.setEndTime(sTEMTime);
    }

    public void reset() {
        super.reset();
        this.getNextCalled = false;
    }

    protected EClass eStaticClass() {
        return SequencerPackage.Literals.REAL_TIME_SEQUENCER;
    }

    protected static STEMTime getCurrentSystemTime() {
        return ModelFactory.eINSTANCE.createSTEMTime();
    }
}

