/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.sequencer.impl;

import java.text.SimpleDateFormat;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.core.common.impl.IdentifiableImpl;
import org.eclipse.stem.core.model.ModelFactory;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.sequencer.Sequencer;
import org.eclipse.stem.core.sequencer.SequencerPackage;

public abstract class SequencerImpl
extends IdentifiableImpl
implements Sequencer {
    protected STEMTime startTime = ModelFactory.eINSTANCE.createSTEMTime();
    protected STEMTime endTime;
    protected STEMTime currentTime;
    protected static final long TIME_DELTA_EDEFAULT = 0L;
    protected long timeDelta = 0L;
    protected static final long DURATION_EDEFAULT = -1L;
    protected long duration = -1L;
    protected static final boolean TIME_TO_STOP_EDEFAULT = false;
    protected static final double WORK_COMPLETE_EDEFAULT = 0.0;
    protected double workComplete = 0.0;
    protected static final int WORK_INCREMENT_EDEFAULT = 0;
    protected static final int CYCLE_EDEFAULT = 0;
    protected int cycle = 0;

    protected SequencerImpl() {
    }

    protected EClass eStaticClass() {
        return SequencerPackage.Literals.SEQUENCER;
    }

    public STEMTime getStartTime() {
        return (STEMTime)EcoreUtil.copy((EObject)this.startTime);
    }

    public NotificationChain basicSetStartTime(STEMTime sTEMTime, NotificationChain notificationChain) {
        STEMTime sTEMTime2 = this.startTime;
        this.startTime = sTEMTime;
        if (this.eNotificationRequired()) {
            ENotificationImpl eNotificationImpl = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)sTEMTime2, (Object)sTEMTime);
            if (notificationChain == null) {
                notificationChain = eNotificationImpl;
            } else {
                notificationChain.add((Notification)eNotificationImpl);
            }
        }
        return notificationChain;
    }

    public void setStartTime(STEMTime sTEMTime) {
        if (sTEMTime != this.startTime) {
            NotificationChain notificationChain = null;
            if (this.startTime != null) {
                notificationChain = ((InternalEObject)this.startTime).eInverseRemove((InternalEObject)this, -4, null, notificationChain);
            }
            if (sTEMTime != null) {
                notificationChain = ((InternalEObject)sTEMTime).eInverseAdd((InternalEObject)this, -4, null, notificationChain);
            }
            if ((notificationChain = this.basicSetStartTime(sTEMTime, notificationChain)) != null) {
                notificationChain.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)sTEMTime, (Object)sTEMTime));
        }
    }

    public STEMTime getEndTime() {
        return this.endTime;
    }

    public NotificationChain basicSetEndTime(STEMTime sTEMTime, NotificationChain notificationChain) {
        STEMTime sTEMTime2 = this.endTime;
        this.endTime = sTEMTime;
        if (this.eNotificationRequired()) {
            ENotificationImpl eNotificationImpl = new ENotificationImpl((InternalEObject)this, 1, 4, (Object)sTEMTime2, (Object)sTEMTime);
            if (notificationChain == null) {
                notificationChain = eNotificationImpl;
            } else {
                notificationChain.add((Notification)eNotificationImpl);
            }
        }
        return notificationChain;
    }

    public void setEndTime(STEMTime sTEMTime) {
        if (sTEMTime != this.endTime) {
            NotificationChain notificationChain = null;
            if (this.endTime != null) {
                notificationChain = ((InternalEObject)this.endTime).eInverseRemove((InternalEObject)this, -5, null, notificationChain);
            }
            if (sTEMTime != null) {
                notificationChain = ((InternalEObject)sTEMTime).eInverseAdd((InternalEObject)this, -5, null, notificationChain);
            }
            if ((notificationChain = this.basicSetEndTime(sTEMTime, notificationChain)) != null) {
                notificationChain.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)sTEMTime, (Object)sTEMTime));
        }
    }

    public STEMTime getCurrentTime() {
        if (this.currentTime == null) {
            this.setCurrentTime((STEMTime)EcoreUtil.copy((EObject)this.getStartTime()));
        }
        return (STEMTime)EcoreUtil.copy((EObject)this.currentTime);
    }

    public NotificationChain basicSetCurrentTime(STEMTime sTEMTime, NotificationChain notificationChain) {
        STEMTime sTEMTime2 = this.currentTime;
        this.currentTime = sTEMTime;
        if (this.eNotificationRequired()) {
            ENotificationImpl eNotificationImpl = new ENotificationImpl((InternalEObject)this, 1, 5, (Object)sTEMTime2, (Object)sTEMTime);
            if (notificationChain == null) {
                notificationChain = eNotificationImpl;
            } else {
                notificationChain.add((Notification)eNotificationImpl);
            }
        }
        return notificationChain;
    }

    public void setCurrentTime(STEMTime sTEMTime) {
        if (sTEMTime != this.currentTime) {
            NotificationChain notificationChain = null;
            if (this.currentTime != null) {
                notificationChain = ((InternalEObject)this.currentTime).eInverseRemove((InternalEObject)this, -6, null, notificationChain);
            }
            if (sTEMTime != null) {
                notificationChain = ((InternalEObject)sTEMTime).eInverseAdd((InternalEObject)this, -6, null, notificationChain);
            }
            if ((notificationChain = this.basicSetCurrentTime(sTEMTime, notificationChain)) != null) {
                notificationChain.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)sTEMTime, (Object)sTEMTime));
        }
    }

    public STEMTime getNextTime() {
        ++this.cycle;
        return null;
    }

    public long getTimeDelta() {
        return this.timeDelta;
    }

    public long getDuration() {
        if (this.duration == -1L && this.getStartTime() != null && this.getEndTime() != null) {
            this.duration = this.getEndTime().getTime().getTime() - this.getStartTime().getTime().getTime();
        }
        return this.duration;
    }

    public void setDuration(long l) {
        long l2 = this.duration;
        this.duration = l;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, l2, this.duration));
        }
    }

    public boolean isTimeToStop() {
        throw new UnsupportedOperationException();
    }

    public double getWorkComplete() {
        return this.workComplete;
    }

    public void setWorkComplete(double d) {
        double d2 = this.workComplete;
        this.workComplete = d;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, d2, this.workComplete));
        }
    }

    public int getWorkIncrement() {
        throw new UnsupportedOperationException();
    }

    public int getCycle() {
        return this.cycle;
    }

    public void setCycle(int n) {
        int n2 = this.cycle;
        this.cycle = n;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, n2, this.cycle));
        }
    }

    public void reset() {
        this.setCurrentTime((STEMTime)EcoreUtil.copy((EObject)this.getStartTime()));
        this.setWorkComplete(0.0);
        this.setCycle(0);
    }

    public NotificationChain eInverseRemove(InternalEObject internalEObject, int n, NotificationChain notificationChain) {
        switch (n) {
            case 3: {
                return this.basicSetStartTime(null, notificationChain);
            }
            case 4: {
                return this.basicSetEndTime(null, notificationChain);
            }
            case 5: {
                return this.basicSetCurrentTime(null, notificationChain);
            }
        }
        return super.eInverseRemove(internalEObject, n, notificationChain);
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 3: {
                return this.getStartTime();
            }
            case 4: {
                return this.getEndTime();
            }
            case 5: {
                return this.getCurrentTime();
            }
            case 6: {
                return this.getNextTime();
            }
            case 7: {
                return new Long(this.getTimeDelta());
            }
            case 8: {
                return new Long(this.getDuration());
            }
            case 9: {
                return this.isTimeToStop() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 10: {
                return new Double(this.getWorkComplete());
            }
            case 11: {
                return new Integer(this.getWorkIncrement());
            }
            case 12: {
                return new Integer(this.getCycle());
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 3: {
                this.setStartTime((STEMTime)object);
                return;
            }
            case 4: {
                this.setEndTime((STEMTime)object);
                return;
            }
            case 5: {
                this.setCurrentTime((STEMTime)object);
                return;
            }
            case 8: {
                this.setDuration((Long)object);
                return;
            }
            case 10: {
                this.setWorkComplete((Double)object);
                return;
            }
            case 12: {
                this.setCycle((Integer)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 3: {
                this.setStartTime(null);
                return;
            }
            case 4: {
                this.setEndTime(null);
                return;
            }
            case 5: {
                this.setCurrentTime(null);
                return;
            }
            case 8: {
                this.setDuration(-1L);
                return;
            }
            case 10: {
                this.setWorkComplete(0.0);
                return;
            }
            case 12: {
                this.setCycle(0);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 3: {
                return this.startTime != null;
            }
            case 4: {
                return this.endTime != null;
            }
            case 5: {
                return this.currentTime != null;
            }
            case 6: {
                return this.getNextTime() != null;
            }
            case 7: {
                return this.timeDelta != 0L;
            }
            case 8: {
                return this.duration != -1L;
            }
            case 9: {
                return this.isTimeToStop();
            }
            case 10: {
                return this.workComplete != 0.0;
            }
            case 11: {
                return this.getWorkIncrement() != 0;
            }
            case 12: {
                return this.cycle != 0;
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM d, yyyy");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(simpleDateFormat.format(this.startTime.getTime()));
        if (this.endTime != null) {
            stringBuffer.append(" to ");
            stringBuffer.append(simpleDateFormat.format(this.endTime.getTime()));
        }
        if (this.currentTime != null) {
            stringBuffer.append(", current=");
            stringBuffer.append(simpleDateFormat.format(this.currentTime.getTime()));
        }
        stringBuffer.append(" (timeDelta: ");
        stringBuffer.append(this.timeDelta);
        stringBuffer.append(" (");
        long l = this.timeDelta / STEMTime.Units.DAY.getMilliseconds();
        stringBuffer.append(l);
        stringBuffer.append(l == 1L ? " day)" : " days)");
        stringBuffer.append(", duration: ");
        stringBuffer.append(this.duration);
        stringBuffer.append(", workComplete: ");
        stringBuffer.append(this.workComplete);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

