/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.sequencer.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.sequencer.SequencerPackage;
import org.eclipse.stem.core.sequencer.SequentialSequencer;
import org.eclipse.stem.core.sequencer.impl.SequencerImpl;

public class SequentialSequencerImpl
extends SequencerImpl
implements SequentialSequencer {
    protected static final long TIME_INCREMENT_EDEFAULT = STEMTime.Units.DAY.getMilliseconds();
    protected long timeIncrement = TIME_INCREMENT_EDEFAULT;
    private double workIncrementRunningTotal = 0.0;
    private boolean endOfSequenceReached = false;
    private boolean getNextTimeNotCalled = true;

    protected SequentialSequencerImpl() {
        this.timeDelta = this.getTimeIncrement();
    }

    protected EClass eStaticClass() {
        return SequencerPackage.Literals.SEQUENTIAL_SEQUENCER;
    }

    public long getTimeIncrement() {
        return this.timeIncrement;
    }

    public boolean isTimeToStop() {
        return this.endOfSequenceReached || this.isEndTimeBefore(this.getCurrentTime());
    }

    public void setTimeIncrement(long l) {
        long l2 = this.timeIncrement;
        this.timeDelta = this.timeIncrement = l;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, l2, this.timeIncrement));
        }
    }

    public STEMTime getNextTime() {
        super.getNextTime();
        STEMTime sTEMTime = null;
        if (this.getNextTimeNotCalled) {
            sTEMTime = this.getStartTime();
            this.getNextTimeNotCalled = false;
        } else {
            STEMTime sTEMTime2 = this.getCurrentTime().addIncrement(this.getTimeIncrement());
            sTEMTime = this.isEndTimeBefore(sTEMTime2) ? (STEMTime)EcoreUtil.copy((EObject)this.getEndTime()) : sTEMTime2;
            if (sTEMTime.equals(this.getEndTime())) {
                this.endOfSequenceReached = true;
            }
        }
        this.setCurrentTime(sTEMTime);
        this.setWorkComplete(Math.min(this.getWorkComplete() + (double)this.getWorkIncrement(), 100.0));
        return this.getCurrentTime();
    }

    protected boolean isEndTimeBefore(STEMTime sTEMTime) {
        return this.getEndTime() != null && this.getEndTime().getTime().before(sTEMTime.getTime());
    }

    public int getWorkIncrement() {
        int n = 0;
        if (this.getDuration() != -1L) {
            this.workIncrementRunningTotal += 100.0 * (double)this.getTimeIncrement() / (double)(this.getDuration() + this.getTimeIncrement());
            if (this.workIncrementRunningTotal >= 1.0) {
                n = (int)this.workIncrementRunningTotal;
                this.workIncrementRunningTotal -= (double)n;
            }
        }
        return n;
    }

    public void reset() {
        super.reset();
        this.workIncrementRunningTotal = 0.0;
        this.getNextTimeNotCalled = true;
        this.endOfSequenceReached = false;
    }

    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 13: {
                return new Long(this.getTimeIncrement());
            }
        }
        return super.eGet(n, bl, bl2);
    }

    public void eSet(int n, Object object) {
        switch (n) {
            case 13: {
                this.setTimeIncrement((Long)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    public void eUnset(int n) {
        switch (n) {
            case 13: {
                this.setTimeIncrement(TIME_INCREMENT_EDEFAULT);
                return;
            }
        }
        super.eUnset(n);
    }

    public boolean eIsSet(int n) {
        switch (n) {
            case 13: {
                return this.timeIncrement != TIME_INCREMENT_EDEFAULT;
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (timeIncrement: ");
        stringBuffer.append(this.timeIncrement);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

