/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.loggers.views;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.adapters.time.TimeProvider;
import org.eclipse.stem.adapters.time.TimeProviderAdapterFactory;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListenerSync;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.stem.util.loggers.views.LogWriter;
import org.eclipse.stem.util.loggers.views.NewCSVLogWriter;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomCSVLogger
implements ISimulationListenerSync {
    protected ISimulation simulation = null;
    protected IntegrationDecorator diseaseModel = null;
    LogWriter logWriter;
    Graph graph = null;
    TimeProvider timeProvider = null;
    protected Map<Node, Integer> nodeLevels;

    public CustomCSVLogger(String string, ISimulation iSimulation, IntegrationDecorator integrationDecorator) {
        this.logWriter = new NewCSVLogWriter(string, iSimulation, integrationDecorator);
        this.setSimulation(iSimulation);
        this.diseaseModel = integrationDecorator;
    }

    public final void setSimulation(ISimulation iSimulation) {
        if (this.simulation == iSimulation) {
            return;
        }
        if (this.simulation != null) {
            this.simulation.removeSimulationListenerSync((ISimulationListenerSync)this);
        }
        this.nodeLevels = this.getNodeLevels(iSimulation);
        this.simulation = iSimulation;
        if (this.simulation != null) {
            this.simulation.addSimulationListenerSync((ISimulationListenerSync)this);
            this.initializeFromSimulation(this.simulation);
        } else {
            this.initializeFromSimulation(null);
        }
        this.flushLoggerData();
    }

    protected void initializeFromSimulation(ISimulation iSimulation) {
        this.graph = iSimulation.getScenario().getCanonicalGraph();
        this.timeProvider = (TimeProvider)TimeProviderAdapterFactory.INSTANCE.adapt((Notifier)this.graph, TimeProvider.class);
    }

    public void flushLoggerData() {
        if (this.logWriter != null) {
            this.logWriter.flushLoggerData();
        }
    }

    public void simulationChangedSync(SimulationEvent simulationEvent) {
        if (simulationEvent.getSimulationState() == SimulationState.RUNNING) {
            if (this.logWriter != null && this.logWriter.needsHeader) {
                this.logWriter.logHeader(this.simulation, this.diseaseModel, this.nodeLevels, this.timeProvider);
            }
        } else if (simulationEvent.getSimulationState() == SimulationState.COMPLETED_CYCLE) {
            Display display = Display.getDefault();
            if (this.logWriter != null && !display.isDisposed() && this.logWriter != null) {
                this.logWriter.logData(this.simulation, this.diseaseModel, this.nodeLevels, this.timeProvider, false);
            }
        } else if (simulationEvent.getSimulationState() == SimulationState.STOPPED) {
            this.close();
        }
    }

    private Map<Node, Integer> getNodeLevels(ISimulation iSimulation) {
        HashMap<Node, Integer> hashMap = new HashMap<Node, Integer>();
        Graph graph = iSimulation.getScenario().getCanonicalGraph();
        if (graph != null) {
            EMap eMap = graph.getNodes();
            Set set = eMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator != null && iterator.hasNext()) {
                URI uRI = (URI)iterator.next();
                Node node = (Node)eMap.get((Object)uRI);
                if (node.getLabels().size() == 0) continue;
                String string = node.getURI().toString();
                int n = this.getAdminLevel(string);
                hashMap.put(node, n);
            }
        }
        return hashMap;
    }

    private int getAdminLevel(String string) {
        int n = 0;
        String string2 = string;
        while (string2.contains("-")) {
            String string3;
            ++n;
            int n2 = string2.indexOf("-");
            string2 = string3 = string2.substring(n2 + 1, string2.length());
        }
        return n;
    }

    public void close() {
        if (this.logWriter != null) {
            this.logWriter.flushLoggerData();
        }
        if (this.logWriter != null) {
            this.logWriter.closeLoggerData();
        }
        this.logWriter = null;
        if (this.simulation != null) {
            this.simulation.removeSimulationListenerSync((ISimulationListenerSync)this);
        }
    }
}

