/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.loggers.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.stem.adapters.time.TimeProvider;
import org.eclipse.stem.adapters.time.TimeProviderAdapterFactory;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListenerSync;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.ui.widgets.PropertySelector;
import org.eclipse.stem.util.loggers.views.LogWriter;
import org.eclipse.stem.util.loggers.views.LoggerControl;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataHistoryLogger
extends LoggerControl
implements ISimulationListenerSync {
    Label loggerTypeLabel;
    Label loggerDiseaseLabel;
    LogWriter logWriter;
    Graph graph = null;
    TimeProvider timeProvider = null;
    PropertySelector propertySelector;
    List<ItemPropertyDescriptor> selectedProperties;
    private final PropertySieve propertySieve = new PropertySieve(){

        @Override
        public List<ItemPropertyDescriptor> sieve(DynamicLabel dynamicLabel) {
            ArrayList<ItemPropertyDescriptor> arrayList = new ArrayList<ItemPropertyDescriptor>();
            RelativeValueProviderAdapter relativeValueProviderAdapter = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)dynamicLabel, RelativeValueProvider.class);
            if (relativeValueProviderAdapter != null) {
                relativeValueProviderAdapter.setTarget((Notifier)dynamicLabel);
                for (Object e : relativeValueProviderAdapter.getProperties()) {
                    ItemPropertyDescriptor itemPropertyDescriptor = (ItemPropertyDescriptor)e;
                    arrayList.add(itemPropertyDescriptor);
                }
            }
            return arrayList;
        }
    };

    public DataHistoryLogger(Composite composite, LogWriter logWriter, ISimulation iSimulation, IntegrationDecorator integrationDecorator) {
        super(composite, 0);
        this.logWriter = logWriter;
        this.setSimulation(iSimulation);
        this.setDiseaseModel(integrationDecorator);
        this.createContents();
    }

    private void createContents() {
        FillLayout fillLayout = new FillLayout(256);
        this.setLayout((Layout)fillLayout);
        Composite composite = new Composite((Composite)this, 0);
        FormLayout formLayout = new FormLayout();
        composite.setLayout((Layout)formLayout);
        Display display = this.getDisplay();
        Color color = new Color((Device)display, new RGB(180, 180, 200));
        Color color2 = new Color((Device)display, new RGB(190, 190, 220));
        Color color3 = new Color((Device)display, new RGB(180, 180, 200));
        Color color4 = new Color((Device)display, new RGB(170, 170, 190));
        composite.setBackground(color4);
        this.propertySelector = new PropertySelector(composite, 0);
        this.loggerTypeLabel = new Label(composite, 0x1000000);
        this.loggerTypeLabel.setBackground(color);
        this.loggerTypeLabel.setText("CSV Logger");
        this.loggerTypeLabel.setAlignment(0x1000000);
        if (this.simulationNameLabel == null) {
            this.simulationNameLabel = new Label(composite, 0x1000000);
            this.simulationNameLabel.setText(this.simulation.getName());
            this.simulationNameLabel.setBackground(color2);
            this.simulationNameLabel.setAlignment(0x1000000);
        }
        this.loggerDiseaseLabel = new Label(composite, 0x1000000);
        this.loggerDiseaseLabel.setBackground(color3);
        String string = null;
        if (this.diseaseModel instanceof DiseaseModel) {
            string = ((DiseaseModel)this.diseaseModel).getDiseaseName();
        } else if (this.diseaseModel instanceof PopulationModel) {
            string = ((PopulationModel)this.diseaseModel).getName();
        }
        this.loggerDiseaseLabel.setText(string);
        this.loggerDiseaseLabel.setAlignment(0x1000000);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(25, 0);
        formData.bottom = new FormAttachment(0, 100);
        this.loggerTypeLabel.setLayoutData((Object)formData);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment(0, 0);
        formData2.left = new FormAttachment(25, 0);
        formData2.right = new FormAttachment(50, 0);
        formData2.bottom = new FormAttachment(0, 100);
        this.simulationNameLabel.setLayoutData((Object)formData2);
        FormData formData3 = new FormData();
        formData3.top = new FormAttachment(0, 0);
        formData3.left = new FormAttachment(50, 0);
        formData3.right = new FormAttachment(90, 0);
        formData3.bottom = new FormAttachment(0, 100);
        this.loggerDiseaseLabel.setLayoutData((Object)formData3);
        this.propertySelector.setSize(0, 0);
        FormData formData4 = new FormData();
        formData4.top = new FormAttachment(0, 0);
        formData4.left = new FormAttachment(100, 0);
        formData4.right = new FormAttachment(100, 0);
        this.propertySelector.setLayoutData((Object)formData4);
        this.propertySelector.setVisible(false);
    }

    List<ItemPropertyDescriptor> getPropertiesToDisplay(Decorator decorator) {
        ArrayList<ItemPropertyDescriptor> arrayList = new ArrayList<ItemPropertyDescriptor>();
        if (decorator != null && !decorator.getLabelsToUpdate().isEmpty()) {
            arrayList.addAll(this.propertySieve.sieve((DynamicLabel)decorator.getLabelsToUpdate().get(0)));
        }
        return arrayList;
    }

    @Override
    public void remove() {
        if (this.logWriter != null) {
            this.logWriter.flushLoggerData();
        }
        if (this.logWriter != null) {
            this.logWriter.closeLoggerData();
        }
        this.logWriter = null;
        this.removeListeners.clear();
        this.propertySelector.setDecorators(Collections.EMPTY_LIST);
        this.dispose();
    }

    public void setIdentifiable() {
    }

    @Override
    protected void initializeFromSimulation(ISimulation iSimulation) {
        this.graph = iSimulation.getScenario().getCanonicalGraph();
        this.timeProvider = (TimeProvider)TimeProviderAdapterFactory.INSTANCE.adapt((Notifier)this.graph, TimeProvider.class);
    }

    @Override
    public void refresh2() {
        if (this.logWriter != null) {
            this.logWriter.flushLoggerData();
        }
    }

    public void simulationChangedSync(SimulationEvent simulationEvent) {
        if (simulationEvent.getSimulationState() == SimulationState.RUNNING) {
            if (this.logWriter != null && this.logWriter.needsHeader) {
                this.logWriter.logHeader(this.simulation, this.diseaseModel, this.nodeLevels, this.timeProvider);
            }
        } else if (simulationEvent.getSimulationState() == SimulationState.COMPLETED_CYCLE) {
            Display display = Display.getDefault();
            if (this.logWriter != null && !display.isDisposed() && this.logWriter != null) {
                this.logWriter.logData(this.simulation, this.diseaseModel, this.nodeLevels, this.timeProvider, false);
            }
        } else if (simulationEvent.getSimulationState() == SimulationState.STOPPED) {
            if (this.logWriter != null) {
                this.logWriter.closeLoggerData();
            }
            this.dispose();
        }
    }

    public void dispose() {
        if (this.logWriter != null) {
            this.logWriter.closeLoggerData();
        }
        this.logWriter = null;
        if (this.simulation != null) {
            this.simulation.removeSimulationListenerSync((ISimulationListenerSync)this);
        }
        super.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PropertySieve {
        public List<ItemPropertyDescriptor> sieve(DynamicLabel var1);
    }
}

