/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.loggers.views;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListenerSync;
import org.eclipse.stem.util.loggers.views.IRemoveListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LoggerControl
extends Composite
implements ISimulationListenerSync,
ISelectionProvider {
    protected RelativeValueProviderAdapter rvp;
    protected Label simulationNameLabel;
    protected ISimulation simulation = null;
    protected IntegrationDecorator diseaseModel = null;
    protected Map<Node, Integer> nodeLevels;
    protected final List<ISelectionChangedListener> listeners = new CopyOnWriteArrayList<ISelectionChangedListener>();
    protected final List<IRemoveListener> removeListeners = new CopyOnWriteArrayList<IRemoveListener>();
    ISelection selection = null;
    protected static final int MARGIN_WIDTH = 5;
    protected static final int MARGIN_HEIGHT = 5;

    public LoggerControl(Composite composite, int n) {
        super(composite, n);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                LoggerControl.this.dispose();
            }
        });
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 5;
        formLayout.marginWidth = 5;
        this.setLayout((Layout)formLayout);
    }

    protected Composite createTopComposite(Composite composite) {
        return composite;
    }

    public abstract void remove();

    public void addIRemoveListener(IRemoveListener iRemoveListener) {
        this.removeListeners.add(iRemoveListener);
    }

    public void removeIRemoveListener(IRemoveListener iRemoveListener) {
        this.removeListeners.remove(iRemoveListener);
    }

    public void fireRemoveEvent(Identifiable identifiable) {
        for (IRemoveListener iRemoveListener : this.removeListeners) {
            iRemoveListener.identifiableRemoved(identifiable);
        }
    }

    public final void setSimulation(ISimulation iSimulation) {
        if (this.simulation == iSimulation) {
            return;
        }
        if (this.simulation != null) {
            this.simulation.removeSimulationListenerSync((ISimulationListenerSync)this);
        }
        this.nodeLevels = this.getNodeLevels(iSimulation);
        this.simulation = iSimulation;
        this.selection = null;
        if (this.simulation != null) {
            this.simulation.addSimulationListenerSync((ISimulationListenerSync)this);
            this.initializeFromSimulation(this.simulation);
        } else {
            this.initializeFromSimulation(null);
        }
        this.refresh2();
    }

    public void setDiseaseModel(IntegrationDecorator integrationDecorator) {
        this.diseaseModel = integrationDecorator;
    }

    protected abstract void initializeFromSimulation(ISimulation var1);

    protected abstract void refresh2();

    public final ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection iSelection) {
        this.selection = iSelection;
        this.fireSelection(iSelection);
    }

    public void fireSelection(ISelection iSelection) {
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, iSelection);
        for (ISelectionChangedListener iSelectionChangedListener : this.listeners) {
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listeners.add(iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listeners.remove(iSelectionChangedListener);
    }

    public Map<Node, Integer> getNodeLevels(ISimulation iSimulation) {
        HashMap<Node, Integer> hashMap = new HashMap<Node, Integer>();
        Graph graph = iSimulation.getScenario().getCanonicalGraph();
        if (graph != null) {
            EMap eMap = graph.getNodes();
            Set set = eMap.keySet();
            Iterator iterator = set.iterator();
            while (iterator != null && iterator.hasNext()) {
                URI uRI = (URI)iterator.next();
                Node node = (Node)eMap.get((Object)uRI);
                if (node.getLabels().size() == 0) continue;
                String string = node.getURI().toString();
                int n = this.getAdminLevel(string);
                hashMap.put(node, n);
            }
        }
        return hashMap;
    }

    private int getAdminLevel(String string) {
        int n = 0;
        String string2 = string;
        while (string2.contains("-")) {
            String string3;
            ++n;
            int n2 = string2.indexOf("-");
            string2 = string3 = string2.substring(n2 + 1, string2.length());
        }
        return n;
    }
}

