/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.loggers.views;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.diseasemodels.standard.AggregatingSIDiseaseModel;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationManagerListenerSync;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.jobs.simulation.SimulationManagerEvent;
import org.eclipse.stem.util.loggers.Activator;
import org.eclipse.stem.util.loggers.util.Util;
import org.eclipse.stem.util.loggers.views.LogWriter;
import org.eclipse.stem.util.loggers.views.LoggerControl;
import org.eclipse.stem.util.loggers.views.LoggerControlFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerViewer
extends Viewer
implements ISelectionChangedListener,
ISimulationManagerListenerSync {
    private static final Map<ISimulation, Set<Identifiable>> identifiablesToDisplayMap = new HashMap<ISimulation, Set<Identifiable>>();
    private static final Collection<ISimulation> simulationsToLog = new ArrayList<ISimulation>();
    SimulationManager simulationManager;
    private ISelection selection = null;
    final Composite composite;
    ScrolledComposite scrolledComposite;
    Composite outerComposite;
    private static final int WIDTH = 400;
    private static final int HEIGHT_MIN = 250;
    private static final int BUTTON_HEIGHT = 25;
    protected Button loggerOnButton = null;
    protected Button loggerOffButton = null;
    protected static Color onColor = null;
    protected static Color offColor = null;
    protected static Label statusLabel = null;
    protected static boolean loggingOn = false;
    protected static final String ON_TEXT = "ON";
    protected static final String OFF_TEXT = "OFF";
    protected static final String MONITOR_ON_TEXT = "MONITOR ON";
    protected static final String MONITOR_OFF_TEXT = "MONITOR OFF";
    private DialogSettings masterSettings = null;
    private final Set monitorSet = new HashSet();
    private static final String ROOT_KEY = "root";
    public static final String REPORTVIEWPREFERENCES_FILENAME = "Preferences.txt";
    public static final String MODIFICATIONS_TEXT = "@ ==  Modifications ==";
    public static final String NODE_NOT_FOUND = "NODENOTFOUND";
    public static final String LOCATION_PREFERENCE_KEY = "location.ids";
    private static final IPath PATH = org.eclipse.stem.diseasemodels.Activator.getDefault().getStateLocation();
    static Label loggerModeHeader;
    static Label loggerScenarioHeader;
    static Label loggerDiseaseHeader;
    private final LoggerControlFactory lcf;

    public LoggerViewer(Composite composite, LoggerControlFactory loggerControlFactory) {
        this.outerComposite = new Composite(composite, 2048);
        FormData formData = new FormData();
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 5;
        formLayout.marginWidth = 5;
        this.outerComposite.setLayout((Layout)formLayout);
        this.outerComposite.setLayoutData((Object)formData);
        Composite composite2 = this.addAllActionButtons(this.outerComposite);
        FormData formData2 = new FormData();
        composite2.setLayoutData((Object)formData2);
        composite2.setSize(-1, 25);
        formData2.left = new FormAttachment(0, 0);
        formData2.right = new FormAttachment(100, 0);
        Composite composite3 = new Composite(this.outerComposite, 0);
        composite3.setLayout((Layout)new FillLayout(512));
        FormData formData3 = new FormData();
        composite3.setLayoutData((Object)formData3);
        formData3.left = new FormAttachment(0, 0);
        formData3.right = new FormAttachment(100, 0);
        formData3.top = new FormAttachment((Control)composite2, 0, 1024);
        formData3.bottom = new FormAttachment(100, 0);
        Color color = composite.getDisplay().getSystemColor(3);
        composite3.setBackground(color);
        this.scrolledComposite = new ScrolledComposite(composite3, 2816);
        FillLayout fillLayout = new FillLayout(512);
        this.scrolledComposite.setLayout((Layout)fillLayout);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(false);
        this.scrolledComposite.setMinSize(-1, 250);
        this.scrolledComposite.setSize(-1, 250);
        this.composite = new Composite((Composite)this.scrolledComposite, 0);
        FillLayout fillLayout2 = new FillLayout(512);
        this.composite.setLayout((Layout)fillLayout2);
        this.scrolledComposite.setContent((Control)this.composite);
        this.lcf = loggerControlFactory;
        this.refresh();
        this.composite.pack();
        LogWriter.reset();
    }

    private Composite addAllActionButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 5;
        formLayout.marginWidth = 5;
        composite2.setLayout((Layout)formLayout);
        composite2.setSize(-1, 25);
        Color color = new Color((Device)composite.getDisplay(), new RGB(170, 170, 190));
        onColor = composite.getDisplay().getSystemColor(5);
        offColor = composite.getDisplay().getSystemColor(4);
        composite2.setBackground(color);
        int n = 120;
        int n2 = 160;
        statusLabel = new Label(composite2, 2048);
        statusLabel.setText(MONITOR_OFF_TEXT);
        statusLabel.setAlignment(0x1000000);
        statusLabel.setSize(n2, 25);
        statusLabel.setText(MONITOR_OFF_TEXT);
        statusLabel.setBackground(offColor);
        this.loggerOnButton = new Button(composite2, 2);
        this.loggerOffButton = new Button(composite2, 2);
        this.loggerOnButton.setText(ON_TEXT);
        this.loggerOffButton.setText(OFF_TEXT);
        this.loggerOnButton.setSize(n, 25);
        this.loggerOffButton.setSize(n, 25);
        this.loggerOnButton.setSelection(false);
        this.loggerOffButton.setSelection(true);
        this.loggerOffButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                LoggerViewer.this.disableLogging();
            }
        });
        this.loggerOnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ISimulation[] iSimulationArray = null;
                List list = LoggerViewer.this.simulationManager.getActiveSimulations();
                if (list != null) {
                    iSimulationArray = new ISimulation[list.size()];
                    int n = 0;
                    while (n < list.size()) {
                        iSimulationArray[n] = (ISimulation)list.get(n);
                        ++n;
                    }
                }
                LoggerViewer.this.enableLogging(iSimulationArray);
            }
        });
        FormData formData = new FormData();
        statusLabel.setLayoutData((Object)formData);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(40, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(0, 25);
        composite2.setLayoutData((Object)formData);
        FormData formData2 = new FormData();
        formData2.left = new FormAttachment(40, 0);
        formData2.right = new FormAttachment(70, 0);
        formData2.top = new FormAttachment(0, 0);
        formData2.bottom = new FormAttachment(0, 25);
        this.loggerOnButton.setLayoutData((Object)formData2);
        FormData formData3 = new FormData();
        formData3.left = new FormAttachment(70, 0);
        formData3.right = new FormAttachment(100, 0);
        formData3.top = new FormAttachment(0, 0);
        formData3.bottom = new FormAttachment(0, 25);
        this.loggerOffButton.setLayoutData((Object)formData3);
        if (loggerModeHeader == null) {
            loggerModeHeader = new Label(composite2, 2048);
            loggerModeHeader.setText("Mode");
            loggerModeHeader.setAlignment(0x1000000);
            loggerScenarioHeader = new Label(composite2, 2048);
            loggerScenarioHeader.setText("Scenario");
            loggerScenarioHeader.setAlignment(0x1000000);
            loggerDiseaseHeader = new Label(composite2, 2048);
            loggerDiseaseHeader.setText("Disease");
            loggerDiseaseHeader.setAlignment(0x1000000);
            FormData formData4 = new FormData();
            formData4.top = new FormAttachment(0, 30);
            formData4.bottom = new FormAttachment(0, 50);
            formData4.left = new FormAttachment(0, 0);
            formData4.right = new FormAttachment(25, 0);
            loggerModeHeader.setLayoutData((Object)formData4);
            FormData formData5 = new FormData();
            formData5.top = new FormAttachment(0, 30);
            formData5.bottom = new FormAttachment(0, 50);
            formData5.left = new FormAttachment(25, 0);
            formData5.right = new FormAttachment(50, 0);
            loggerScenarioHeader.setLayoutData((Object)formData5);
            FormData formData6 = new FormData();
            formData6.top = new FormAttachment(0, 30);
            formData6.bottom = new FormAttachment(0, 50);
            formData6.left = new FormAttachment(50, 0);
            formData6.right = new FormAttachment(90, 0);
            loggerDiseaseHeader.setLayoutData((Object)formData6);
        }
        return composite2;
    }

    public Control getControl() {
        return this.composite;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void refresh() {
        if (this.simulationManager != null) {
            List list = null;
            this.updatePreferenceState(this.simulationManager.getActiveSimulations());
            if (this.simulationManager != null) {
                list = this.simulationManager.getActiveSimulations();
                this.addToDisplayedIdentifiableSet(list);
            }
            identifiablesToDisplayMap.clear();
            this.addAllIdentifiablesBySimulation(this.simulationManager.getActiveSimulations());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableLogging(ISimulation[] iSimulationArray) {
        LoggerViewer loggerViewer = this;
        synchronized (loggerViewer) {
            int n = 0;
            while (n < iSimulationArray.length) {
                ISimulation iSimulation = iSimulationArray[n];
                if (!simulationsToLog.contains(iSimulation)) {
                    simulationsToLog.add(iSimulation);
                    this.populateView(iSimulationArray);
                }
                ++n;
            }
            statusLabel.setText(MONITOR_ON_TEXT);
            statusLabel.setBackground(onColor);
            loggingOn = true;
            this.loggerOnButton.setSelection(true);
            this.loggerOffButton.setSelection(false);
        }
    }

    public void disableLogging() {
        Control[] controlArray;
        simulationsToLog.clear();
        Control[] controlArray2 = controlArray = this.composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray2[n2];
            if (control instanceof LoggerControl) {
                LoggerControl loggerControl = (LoggerControl)control;
                loggerControl.remove();
            } else {
                control.dispose();
            }
            ++n2;
        }
        statusLabel.setText(MONITOR_OFF_TEXT);
        statusLabel.setBackground(offColor);
        loggingOn = false;
        this.loggerOnButton.setSelection(false);
        this.loggerOffButton.setSelection(true);
    }

    public Object getInput() {
        return this.simulationManager;
    }

    public void setInput(Object object) {
        SimulationManager simulationManager = this.simulationManager;
        this.simulationManager = (SimulationManager)object;
        this.inputChanged(object, simulationManager);
    }

    protected void inputChanged(Object object, Object object2) {
        if (object2 != null) {
            ((SimulationManager)object2).removeListenerSync((ISimulationManagerListenerSync)this);
        }
        if (object != null) {
            ((SimulationManager)object).addSimulationManagerListenerSync((ISimulationManagerListenerSync)this);
        }
        this.refresh();
    }

    public void setSelection(ISelection iSelection, boolean bl) {
        this.selection = iSelection;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (selectionChangedEvent.getSelectionProvider() instanceof LoggerControl) {
            this.selection = selectionChangedEvent.getSelection();
            this.fireSelectionChanged(selectionChangedEvent);
        }
    }

    public void simulationsChangedSync(SimulationManagerEvent simulationManagerEvent) {
        this.updatePreferenceState(Arrays.asList(simulationManagerEvent.getSimulationsAdded()));
        List<ISimulation> list = Arrays.asList(simulationManagerEvent.getSimulationsAdded());
        this.addToDisplayedIdentifiableSet(list);
        this.removeFromDisplayedSimulationSet(Arrays.asList(simulationManagerEvent.getSimulationsRemoved()));
        if (loggingOn) {
            this.enableLogging(simulationManagerEvent.getSimulationsAdded());
        } else {
            this.disableLogging();
        }
    }

    private void addToDisplayedIdentifiableSet(List<ISimulation> list) {
        LogWriter.reset();
        if (!list.isEmpty()) {
            int n = 0;
            while (n < list.size()) {
                ISimulation iSimulation = list.get(n);
                Set<Identifiable> set = this.getIdentifiableSet(iSimulation);
                set.addAll(this.getIdentifiablesInSimulation(iSimulation));
                identifiablesToDisplayMap.put(iSimulation, set);
                ++n;
            }
        }
    }

    private void removeFromDisplayedSimulationSet(List<ISimulation> list) {
        if (!list.isEmpty()) {
            int n = 0;
            while (n < list.size()) {
                ISimulation iSimulation = list.get(n);
                Set<Identifiable> set = this.getIdentifiableSet(iSimulation);
                this.cleanup(set, iSimulation);
                set.clear();
                identifiablesToDisplayMap.remove(iSimulation);
                ++n;
            }
        }
    }

    Set<Identifiable> getIdentifiablesInSimulation(ISimulation iSimulation) {
        LinkedHashSet<Identifiable> linkedHashSet = new LinkedHashSet<Identifiable>();
        Graph graph = iSimulation.getScenario().getCanonicalGraph();
        if (graph != null) {
            Iterator iterator = this.monitorSet.iterator();
            while (iterator != null && iterator.hasNext()) {
                String string = (String)iterator.next();
                Node node = null;
                URI uRI = null;
                try {
                    uRI = URI.createURI((String)string);
                    node = graph.getNode(uRI);
                    if (node == null) continue;
                    linkedHashSet.add((Identifiable)node);
                }
                catch (Exception exception) {
                    Activator.logError("LoggerViewer.getIdentifiablesInSimulation() Error setting Identifiable to " + string + " ", exception);
                }
            }
        }
        return linkedHashSet;
    }

    private void cleanup(Set set, ISimulation iSimulation) {
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator != null && iterator.hasNext()) {
                Identifiable identifiable = (Identifiable)iterator.next();
                if (!this.noOtherSimulationContains(identifiable, iSimulation)) continue;
                this.monitorSet.remove(identifiable.getURI().toString());
            }
        }
    }

    protected void removeIdentifiable(Identifiable identifiable) {
        if (identifiable != null) {
            Iterator<ISimulation> iterator = identifiablesToDisplayMap.keySet().iterator();
            while (iterator != null && iterator.hasNext()) {
                ISimulation iSimulation = iterator.next();
                Set<Identifiable> set = identifiablesToDisplayMap.get(iSimulation);
                set.remove(identifiable);
            }
            this.savePreferenceState();
        }
    }

    protected boolean noOtherSimulationContains(Identifiable identifiable, ISimulation iSimulation) {
        if (identifiable != null) {
            Iterator<ISimulation> iterator = identifiablesToDisplayMap.keySet().iterator();
            while (iterator != null && iterator.hasNext()) {
                Set<Identifiable> set;
                ISimulation iSimulation2 = iterator.next();
                if (iSimulation2.getSequenceNumber() == iSimulation.getSequenceNumber() || !(set = identifiablesToDisplayMap.get(iSimulation2)).contains(identifiable)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateView(ISimulation[] iSimulationArray) {
        try {
            if (this.composite.isDisposed()) {
                return;
            }
            this.selection = null;
            if (iSimulationArray != null && iSimulationArray.length >= 1) {
                LoggerViewer loggerViewer = this;
                synchronized (loggerViewer) {
                    int n = 0;
                    while (n < iSimulationArray.length) {
                        ISimulation iSimulation = iSimulationArray[n];
                        String string = iSimulation.getScenario().getURI().toString();
                        String string2 = Util.getLoggingFolder(string);
                        EList eList = iSimulation.getScenario().getCanonicalGraph().getDecorators();
                        for (Decorator decorator : eList) {
                            if (!(decorator instanceof IntegrationDecorator) || decorator instanceof AggregatingSIDiseaseModel) continue;
                            IntegrationDecorator integrationDecorator = (IntegrationDecorator)decorator;
                            LoggerControl loggerControl = this.lcf.create(this.composite, string2, iSimulation, integrationDecorator);
                            loggerControl.addSelectionChangedListener(this);
                            loggerControl.createTopComposite(this.composite);
                        }
                        ++n;
                    }
                }
            }
            this.composite.layout(true, true);
            this.composite.redraw();
        }
        catch (Exception exception) {
            org.eclipse.stem.diseasemodels.Activator.logError((String)"Exception in PopulateView() ", (Throwable)exception);
        }
    }

    private void addAllIdentifiablesBySimulation(List<ISimulation> list) {
        int n = 0;
        while (n < list.size()) {
            ISimulation iSimulation = list.get(n);
            Set<Identifiable> set = this.getIdentifiableSet(iSimulation);
            Graph graph = iSimulation.getScenario().getCanonicalGraph();
            if (graph != null) {
                Iterator iterator = this.monitorSet.iterator();
                while (iterator != null && iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Node node = null;
                    URI uRI = null;
                    try {
                        uRI = URI.createURI((String)string);
                        node = graph.getNode(uRI);
                        if (node == null) continue;
                        set.add((Identifiable)node);
                    }
                    catch (Exception exception) {
                        Activator.logError("LoggerViewer.getIdentifiablesInSimulation() Error setting Identifiable to " + string + " ", exception);
                    }
                }
            }
            ++n;
        }
    }

    protected String getScenarioName(Identifiable identifiable) {
        String string = "NODE_NOT_FOUND";
        List list = this.simulationManager.getActiveSimulations();
        int n = 0;
        while (n < list.size()) {
            Node node;
            ISimulation iSimulation = (ISimulation)list.get(n);
            Graph graph = iSimulation.getScenario().getCanonicalGraph();
            if (graph != null && (node = graph.getNode(identifiable.getURI())) != null) {
                return iSimulation.getScenario().toString();
            }
            ++n;
        }
        return string;
    }

    private void savePreferenceState() {
        List list = null;
        HashSet<String> hashSet = new HashSet<String>();
        if (this.simulationManager != null) {
            list = this.simulationManager.getActiveSimulations();
        }
        if (list != null && list.size() >= 1) {
            int n = 0;
            while (n < list.size()) {
                Node node;
                Identifiable identifiable;
                hashSet.clear();
                ISimulation iSimulation = (ISimulation)list.get(n);
                String string = iSimulation.getScenario().getURI().toString();
                DialogSettings dialogSettings = new DialogSettings(string);
                Graph graph = iSimulation.getScenario().getCanonicalGraph();
                Set<Identifiable> set = this.getIdentifiableSet(iSimulation);
                Iterator<Identifiable> iterator = set.iterator();
                while (iterator != null && iterator.hasNext()) {
                    String string2;
                    identifiable = iterator.next();
                    if (identifiable == null || (node = graph.getNode(identifiable.getURI())) == null || (string2 = identifiable.getURI().toString()) == null) continue;
                    hashSet.add(string2);
                }
                identifiable = new String[hashSet.size()];
                node = hashSet.iterator();
                int n2 = 0;
                while (node != null && node.hasNext()) {
                    identifiable[n2] = (String)node.next();
                    ++n2;
                }
                dialogSettings.put(LOCATION_PREFERENCE_KEY, (String[])identifiable);
                if (this.masterSettings == null) {
                    this.masterSettings = new DialogSettings(ROOT_KEY);
                }
                this.masterSettings.addSection((IDialogSettings)dialogSettings);
                try {
                    this.masterSettings.save(this.getPrefFileName());
                }
                catch (IOException iOException) {
                    Activator.logError("exception writing file [" + iOException.getMessage() + "]", iOException);
                }
                ++n;
            }
        }
    }

    Set<Identifiable> getIdentifiableSet(ISimulation iSimulation) {
        if (!identifiablesToDisplayMap.containsKey(iSimulation)) {
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            identifiablesToDisplayMap.put(iSimulation, linkedHashSet);
        }
        return identifiablesToDisplayMap.get(iSimulation);
    }

    public static String nameFilter(String string) {
        String string2 = string.trim();
        string2 = string2.replace('\"', ' ');
        string2 = string2.replaceAll(" ", "");
        string2 = string2.replace(',', '_');
        string2 = string2.replace('.', '_');
        return string2;
    }

    private void updatePreferenceState(List list) {
        if (this.masterSettings == null) {
            this.readMasterSettingsFromFile();
        }
        if (list != null && list.size() >= 1) {
            int n = 0;
            while (n < list.size()) {
                String[] stringArray;
                ISimulation iSimulation = (ISimulation)list.get(n);
                String string = iSimulation.getScenario().getURI().toString();
                IDialogSettings iDialogSettings = this.masterSettings.getSection(string);
                if (iDialogSettings == null) {
                    iDialogSettings = new DialogSettings(string);
                    this.masterSettings.addSection(iDialogSettings);
                }
                if ((stringArray = iDialogSettings.getArray(LOCATION_PREFERENCE_KEY)) != null) {
                    String[] stringArray2 = stringArray;
                    int n2 = stringArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        String string2 = stringArray2[n3];
                        this.monitorSet.add(string2);
                        ++n3;
                    }
                }
                ++n;
            }
        }
    }

    public void readMasterSettingsFromFile() {
        this.masterSettings = new DialogSettings(ROOT_KEY);
        String string = this.getPrefFileName();
        File file = new File(string);
        if (file.exists()) {
            try {
                this.masterSettings.load(string);
            }
            catch (IOException iOException) {
                Activator.logError("exception loading file [" + iOException.getMessage() + "]", iOException);
            }
        } else {
            try {
                this.masterSettings.save(string);
            }
            catch (IOException iOException) {
                Activator.logError("exception creating file [" + iOException.getMessage() + "]", iOException);
            }
        }
    }

    public String getPrefFileName() {
        String string = this.lcf.getControlType();
        String string2 = PATH.append(String.valueOf(string) + "_" + REPORTVIEWPREFERENCES_FILENAME).toOSString();
        return string2;
    }
}

