/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.loggers.views;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.stem.adapters.time.TimeProvider;
import org.eclipse.stem.core.common.CommonPackage;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.populationmodels.standard.provider.StandardItemProviderAdapterFactory;
import org.eclipse.stem.util.loggers.Activator;
import org.eclipse.stem.util.loggers.views.LogWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewCSVLogWriter
extends LogWriter {
    private static final String DEFAULT_ID = "data";
    private static final String CSV_EXT = ".csv";
    private String directoryName;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("EEE d MMM yy", Locale.getDefault());
    public static final String TIME_LABEL = "time";
    public static final String ITERATION_LABEL = "iteration";
    public static final String RUN_PARAMETER_FILE_NAME = "runparameters.csv";
    private final int FLUSH_EACH_ITERATION = 50;
    private int icount = 0;
    private static org.eclipse.stem.diseasemodels.standard.provider.StandardItemProviderAdapterFactory itemProviderFactory;
    private static StandardItemProviderAdapterFactory populationModelItemProviderFactory;
    private final Map<StateLevelMap, FileWriter> fileWriters;
    private boolean logIntegers = Activator.getDefault().getPreferenceStore().getBoolean("org.eclipse.stem.logging.integers");

    public NewCSVLogWriter(String string, ISimulation iSimulation, IntegrationDecorator integrationDecorator) {
        boolean bl;
        this.needsHeader = true;
        this.done = false;
        this.icount = 0;
        String string2 = DEFAULT_ID;
        if (iSimulation != null) {
            string2 = iSimulation.getUniqueIDString();
            while (string2 == null) {
                string2 = iSimulation.getUniqueIDString();
            }
        }
        String string3 = null;
        if (integrationDecorator instanceof DiseaseModel) {
            string3 = ((DiseaseModel)integrationDecorator).getDiseaseName();
        } else if (integrationDecorator instanceof PopulationModel) {
            string3 = ((PopulationModel)integrationDecorator).getName();
        }
        try {
            this.directoryName = String.valueOf(string) + sep + string2 + sep + string3.trim() + sep;
        }
        catch (Exception exception) {
            Activator.logError("Failed ot create directory for CSV Logger", exception);
        }
        this.directoryName = this.directoryName.replaceAll("\"", "");
        File file = new File(this.directoryName);
        if (!(file.exists() && file.isDirectory() || (bl = file.mkdirs()))) {
            Activator.logError("Failed to Create Driectory" + this.directoryName, new IOException("Failed to Create Driectory" + this.directoryName));
        }
        this.logRunParameters(integrationDecorator);
        this.fileWriters = new HashMap<StateLevelMap, FileWriter>();
    }

    @Override
    public void logHeader(RelativeValueProviderAdapter relativeValueProviderAdapter) {
    }

    @Override
    public void logHeader(ISimulation iSimulation, IntegrationDecorator integrationDecorator, Map<Node, Integer> map, TimeProvider timeProvider) {
        int n;
        String string = this.directoryName;
        File file = new File(string);
        if (!file.exists() && (n = (int)(file.mkdirs() ? 1 : 0)) == 0) {
            Activator.logError("Failed to Create Driectory" + this.directoryName, new IOException("Failed to Create Driectory" + this.directoryName));
        }
        n = Integer.MAX_VALUE;
        int n2 = -1;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            int n3 = iterator.next();
            if (n3 < n) {
                n = n3;
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        try {
            IntegrationLabelValue integrationLabelValue;
            Object object;
            DynamicLabel dynamicLabel2;
            IntegrationLabel integrationLabel = null;
            for (DynamicLabel dynamicLabel2 : ((Decorator)integrationDecorator).getLabelsToUpdate()) {
                if (!(dynamicLabel2 instanceof IntegrationLabel)) continue;
                integrationLabel = (IntegrationLabel)dynamicLabel2;
                break;
            }
            if (integrationLabel == null) {
                Activator.logError("Cannot log, no label found for decorator!", new Exception());
                return;
            }
            dynamicLabel2 = null;
            if (integrationDecorator instanceof DiseaseModel) {
                object = NewCSVLogWriter.getItemProviderFactory();
                integrationLabelValue = (IntegrationLabelValue)integrationLabel.getCurrentValue();
                dynamicLabel2 = (IItemPropertySource)object.adapt((Notifier)integrationLabelValue, IItemPropertySource.class);
            } else if (integrationDecorator instanceof PopulationModel) {
                object = NewCSVLogWriter.getPopulationModelItemProviderFactory();
                integrationLabelValue = (IntegrationLabelValue)integrationLabel.getCurrentValue();
                dynamicLabel2 = (IItemPropertySource)object.adapt((Notifier)integrationLabelValue, IItemPropertySource.class);
            }
            if (dynamicLabel2 == null) {
                Activator.logError("Cannot find property source for logger", null);
            }
            object = dynamicLabel2.getPropertyDescriptors(null);
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                integrationLabelValue = (IItemPropertyDescriptor)iterator2.next();
                int n4 = n;
                while (n4 <= n2) {
                    StateLevelMap stateLevelMap = new StateLevelMap(integrationLabelValue.getDisplayName((Object)integrationLabelValue), n4);
                    String string2 = String.valueOf(string) + sep + integrationLabelValue.getDisplayName((Object)integrationLabelValue) + "_" + n4 + CSV_EXT;
                    FileWriter fileWriter = new FileWriter(string2);
                    this.fileWriters.put(stateLevelMap, fileWriter);
                    Iterator<Node> iterator3 = this.getNodeIterator(n4, map);
                    fileWriter.write(ITERATION_LABEL);
                    fileWriter.write(",");
                    fileWriter.write(TIME_LABEL);
                    fileWriter.write(",");
                    while (iterator3.hasNext()) {
                        Node node = iterator3.next();
                        String string3 = this.filterLocationId(node.getURI().toString());
                        fileWriter.write(string3);
                        if (!iterator3.hasNext()) continue;
                        fileWriter.write(",");
                    }
                    fileWriter.write("\n");
                    ++n4;
                }
            }
            this.needsHeader = false;
        }
        catch (IOException iOException) {
            Activator.logError("Error writing log header ", iOException);
        }
    }

    public void logRunParameters(IntegrationDecorator integrationDecorator) {
        if (integrationDecorator == null) {
            return;
        }
        try {
            FileWriter fileWriter = new FileWriter(String.valueOf(this.directoryName) + RUN_PARAMETER_FILE_NAME);
            ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            IItemPropertySource iItemPropertySource = (IItemPropertySource)composedAdapterFactory.adapt((Notifier)integrationDecorator, IItemPropertySource.class);
            List list = iItemPropertySource.getPropertyDescriptors((Object)integrationDecorator);
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            int n = 0;
            while (n < list.size()) {
                IItemPropertyDescriptor iItemPropertyDescriptor = (IItemPropertyDescriptor)list.get(n);
                EStructuralFeature eStructuralFeature = (EStructuralFeature)iItemPropertyDescriptor.getFeature(null);
                EClass eClass = eStructuralFeature.getEContainingClass();
                if (!eClass.equals(CommonPackage.eINSTANCE.getDublinCore())) {
                    Object object = integrationDecorator.eGet(eStructuralFeature);
                    stringBuilder.append(eStructuralFeature.getName());
                    stringBuilder.append(",");
                    object = object.toString().replace(',', ' ');
                    object = object.toString().replace('\n', ' ');
                    stringBuilder2.append(object.toString().replace(',', ' '));
                    stringBuilder2.append(",");
                }
                ++n;
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            stringBuilder2.setLength(stringBuilder2.length() - 1);
            fileWriter.write(stringBuilder.toString());
            fileWriter.write("\n");
            fileWriter.write(stringBuilder2.toString());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            Activator.logError("Error creating file writer for RUNPARAMETER ", iOException);
        }
    }

    @Override
    public void logData(RelativeValueProviderAdapter relativeValueProviderAdapter, TimeProvider timeProvider) {
    }

    @Override
    public void logData(ISimulation iSimulation, IntegrationDecorator integrationDecorator, Map<Node, Integer> map, TimeProvider timeProvider, boolean bl) {
        ++this.icount;
        try {
            Iterator<Integer> iterator = this.getResolutionIterator(map);
            while (iterator.hasNext()) {
                int n = iterator.next();
                Iterator<Node> iterator2 = this.getNodeIterator(n, map);
                boolean bl2 = true;
                while (iterator2.hasNext()) {
                    Node node = iterator2.next();
                    EList eList = node.getLabels();
                    int n2 = 0;
                    while (n2 < eList.size()) {
                        NodeLabel nodeLabel = (NodeLabel)eList.get(n2);
                        if (nodeLabel instanceof IntegrationLabel) {
                            Object object;
                            Object object2;
                            IItemPropertySource iItemPropertySource = null;
                            IntegrationLabelValue integrationLabelValue = null;
                            if (integrationDecorator instanceof DiseaseModel) {
                                object2 = NewCSVLogWriter.getItemProviderFactory();
                                object = (IntegrationLabel)nodeLabel;
                                integrationLabelValue = (IntegrationLabelValue)object.getCurrentValue();
                                iItemPropertySource = (IItemPropertySource)object2.adapt((Notifier)integrationLabelValue, PropertySource.class);
                            } else if (integrationDecorator instanceof PopulationModel) {
                                object2 = NewCSVLogWriter.getPopulationModelItemProviderFactory();
                                integrationLabelValue = (IntegrationLabelValue)nodeLabel.getCurrentValue();
                                iItemPropertySource = (IItemPropertySource)object2.adapt((Notifier)integrationLabelValue, IItemPropertySource.class);
                            }
                            if (iItemPropertySource != null) {
                                object2 = iItemPropertySource.getPropertyDescriptors(null);
                                object = new StringBuilder();
                                Iterator iterator3 = object2.iterator();
                                while (iterator3.hasNext()) {
                                    EStructuralFeature eStructuralFeature;
                                    IItemPropertyDescriptor iItemPropertyDescriptor = (IItemPropertyDescriptor)iterator3.next();
                                    ((StringBuilder)object).setLength(0);
                                    StateLevelMap stateLevelMap = new StateLevelMap(iItemPropertyDescriptor.getDisplayName((Object)iItemPropertyDescriptor), n);
                                    FileWriter fileWriter = this.fileWriters.get(stateLevelMap);
                                    if (fileWriter == null) {
                                        Activator.logError("Error, no file writer found for " + stateLevelMap, null);
                                        continue;
                                    }
                                    if (bl2) {
                                        ((StringBuilder)object).append(this.icount);
                                        ((StringBuilder)object).append(",");
                                        eStructuralFeature = timeProvider.getTime();
                                        if (eStructuralFeature == null) {
                                            eStructuralFeature = iSimulation.getScenario().getSequencer().getStartTime();
                                        }
                                        if (!bl) {
                                            eStructuralFeature = eStructuralFeature.addIncrement(iSimulation.getScenario().getSequencer().getTimeDelta());
                                        }
                                        String string = dateFormat.format(eStructuralFeature.getTime());
                                        ((StringBuilder)object).append(string);
                                        ((StringBuilder)object).append(",");
                                    }
                                    eStructuralFeature = (EStructuralFeature)iItemPropertyDescriptor.getFeature(null);
                                    double d = (Double)integrationLabelValue.eGet(eStructuralFeature);
                                    if (this.logIntegers) {
                                        ((StringBuilder)object).append((int)d);
                                    } else {
                                        ((StringBuilder)object).append(d);
                                    }
                                    if (iterator2.hasNext()) {
                                        ((StringBuilder)object).append(",");
                                    } else {
                                        ((StringBuilder)object).append("\n");
                                    }
                                    fileWriter.write(((StringBuilder)object).toString());
                                }
                            }
                        }
                        ++n2;
                    }
                    bl2 = false;
                }
            }
            this.needsHeader = false;
        }
        catch (IOException iOException) {
            Activator.logError("Error writing log header ", iOException);
        }
        if (this.icount % 50 == 0) {
            this.flushLoggerData();
        }
    }

    @Override
    public void flushLoggerData() {
        Collection<FileWriter> collection = this.fileWriters.values();
        for (FileWriter fileWriter : collection) {
            try {
                fileWriter.flush();
            }
            catch (IOException iOException) {
                Activator.logError("Cannot flush log file", iOException);
            }
        }
    }

    @Override
    public void closeLoggerData() {
        Collection<FileWriter> collection = this.fileWriters.values();
        for (FileWriter fileWriter : collection) {
            try {
                fileWriter.close();
            }
            catch (IOException iOException) {
                Activator.logError("Cannot close log file", iOException);
            }
        }
    }

    private Iterator<Integer> getResolutionIterator(Map<Node, Integer> map) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Collection<Integer> collection = map.values();
        for (int n : collection) {
            if (arrayList.contains(n)) continue;
            arrayList.add(n);
        }
        return arrayList.iterator();
    }

    private Iterator<Node> getNodeIterator(int n, Map<Node, Integer> map) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Set<Node> set = map.keySet();
        for (Node node : set) {
            if (map.get(node) != n) continue;
            arrayList.add(node);
        }
        Collections.sort(arrayList, new Comparator<Node>(){

            @Override
            public int compare(Node node, Node node2) {
                String string = node.getURI().toString();
                String string2 = node2.getURI().toString();
                return string.compareTo(string2);
            }
        });
        return arrayList.iterator();
    }

    private String filterLocationId(String string) {
        int n = string.indexOf("/node/geo/region/");
        if (n >= 0) {
            return string.substring(n += "/node/geo/region/".length(), string.length());
        }
        return string;
    }

    private static org.eclipse.stem.diseasemodels.standard.provider.StandardItemProviderAdapterFactory getItemProviderFactory() {
        if (itemProviderFactory == null) {
            itemProviderFactory = new org.eclipse.stem.diseasemodels.standard.provider.StandardItemProviderAdapterFactory();
        }
        return itemProviderFactory;
    }

    private static StandardItemProviderAdapterFactory getPopulationModelItemProviderFactory() {
        if (populationModelItemProviderFactory == null) {
            populationModelItemProviderFactory = new StandardItemProviderAdapterFactory();
        }
        return populationModelItemProviderFactory;
    }

    private class StateLevelMap {
        private final String state;
        private final int level;

        public StateLevelMap(String string, int n) {
            this.state = string;
            this.level = n;
        }

        public int getLevel() {
            return this.level;
        }

        public String getState() {
            return this.state;
        }

        public int hashCode() {
            return this.state.hashCode() + this.level;
        }

        public boolean equals(Object object) {
            if (!(object instanceof StateLevelMap)) {
                return false;
            }
            StateLevelMap stateLevelMap = (StateLevelMap)object;
            return stateLevelMap.getState().equals(this.state) && stateLevelMap.getLevel() == this.level;
        }

        public String toString() {
            return String.valueOf(this.state) + "_" + this.level;
        }
    }
}

