/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.geography;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.stem.data.geography.ISOKey;
import org.eclipse.stem.internal.data.PluginFileGenerator;
import org.eclipse.stem.internal.data.geography.specifications.CountryGraphPropertyFileSpecification;
import org.eclipse.stem.internal.data.geography.specifications.GeographicRelationshipPropertyFileSpecification;
import org.eclipse.stem.internal.data.specifications.IdentifiablePropertyFileSpecification;
import org.eclipse.stem.internal.data.specifications.IdentifiableSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeographyPluginFileGenerator
extends PluginFileGenerator {
    public static final String ID_GRAPH_GEOGRAPHY_CATEGORY = "org.eclipse.stem.core.graph.geography";
    public static final String ID_GRAPH_GEOGRAPHY_POLITICAL_CATEGORY = "org.eclipse.stem.core.graph.geography.political";
    public static final String ID_GRAPH_GEOGRAPHY_POLITICAL_COUNTRIES_CATEGORY = "org.eclipse.stem.core.graph.geography.political.countries";
    public static final String UI_GEOGRAPHY_CATEGORY_NAME = "_UI_Geography_category";
    public static final String UI_POLITICAL_CATEGORY_NAME = "_UI_Poltical_category";
    public static final String UI_COUNTRIES_CATEGORY_NAME = "_UI_Countries_category";
    public static final String GEOGRAPHY_CATEGORY_NAME = "Geography";
    public static final String POLITITCAL_CATEGORY_NAME = "Political";
    public static final String COUNTRIES_CATEGORY_NAME = "Country";

    public void generatePluginFiles(List<IdentifiablePropertyFileSpecification> list, String string, boolean bl) {
        System.out.println("rootserial = " + string);
        File file = new File(String.valueOf(string) + File.separator + "plugin.xml");
        File file2 = new File(String.valueOf(string) + File.separator + "plugin.properties");
        System.out.println(file.getAbsolutePath());
        String string2 = System.getProperty("user.dir");
        System.out.println("CWD = " + string2);
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            PrintWriter printWriter2 = new PrintWriter(new BufferedWriter(new FileWriter(file2)));
            this.outputPluginHeader(printWriter);
            this.outputPluginPropertiesHeader(printWriter2);
            printWriter2.println("_UI_Standard_Scenario_category = STEM");
            this.generateGraphExtensions(list, printWriter, printWriter2, bl);
            printWriter.println();
            this.outputPluginFooter(printWriter);
            printWriter.flush();
            printWriter.close();
            printWriter2.flush();
            printWriter2.close();
        }
        catch (IOException iOException) {
            System.err.println("Trouble creating \"plugin.xml\" " + iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    private void generateGraphExtensions(List<IdentifiablePropertyFileSpecification> list, PrintWriter printWriter, PrintWriter printWriter2, boolean bl) {
        Map<ISOKey, List<CountryGraphPropertyFileSpecification>> map = this.extractCountryGraphISOKeyMap(list);
        Map<ISOKey, List<GeographicRelationshipPropertyFileSpecification>> map2 = this.extractGeographicRelationshipISOKeyMap(list);
        HashSet<ISOKey> hashSet = new HashSet<ISOKey>();
        hashSet.addAll(map.keySet());
        hashSet.addAll(map2.keySet());
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList);
        this.outputGraphExtensionsHeader(printWriter, printWriter2, bl);
        for (ISOKey iSOKey : arrayList) {
            List<GeographicRelationshipPropertyFileSpecification> object2;
            String string = this.createISOCategoryID(ID_GRAPH_GEOGRAPHY_POLITICAL_COUNTRIES_CATEGORY, iSOKey);
            printWriter.println("\n<!-- " + iSOKey + " -->");
            printWriter.println("<stem_category id=\"" + string + "\" name=\"" + iSOKey.toString() + "\" parent_id=\"" + ID_GRAPH_GEOGRAPHY_POLITICAL_COUNTRIES_CATEGORY + "\"/>");
            List<CountryGraphPropertyFileSpecification> list2 = map.get(iSOKey);
            if (list2 != null) {
                printWriter.println("\t<!-- Nodes and Labels -->");
                for (CountryGraphPropertyFileSpecification countryGraphPropertyFileSpecification : list2) {
                    this.outputDublinCore((IdentifiableSpecification)countryGraphPropertyFileSpecification, string, printWriter);
                    printWriter.flush();
                }
            }
            if ((object2 = map2.get(iSOKey)) == null) continue;
            printWriter.println("\t<!-- Edges -->");
            for (GeographicRelationshipPropertyFileSpecification geographicRelationshipPropertyFileSpecification : object2) {
                this.outputDublinCore((IdentifiableSpecification)geographicRelationshipPropertyFileSpecification, string, printWriter);
                printWriter.flush();
            }
        }
        this.outputGraphExtensionsFooter(printWriter);
    }

    private Map<ISOKey, List<CountryGraphPropertyFileSpecification>> extractCountryGraphISOKeyMap(List<IdentifiablePropertyFileSpecification> list) {
        HashMap<ISOKey, List<CountryGraphPropertyFileSpecification>> hashMap = new HashMap<ISOKey, List<CountryGraphPropertyFileSpecification>>();
        for (IdentifiablePropertyFileSpecification identifiablePropertyFileSpecification : list) {
            if (!(identifiablePropertyFileSpecification instanceof CountryGraphPropertyFileSpecification)) continue;
            CountryGraphPropertyFileSpecification countryGraphPropertyFileSpecification = (CountryGraphPropertyFileSpecification)identifiablePropertyFileSpecification;
            ArrayList<CountryGraphPropertyFileSpecification> arrayList = (ArrayList<CountryGraphPropertyFileSpecification>)hashMap.get(countryGraphPropertyFileSpecification.getISOKey());
            if (arrayList == null) {
                arrayList = new ArrayList<CountryGraphPropertyFileSpecification>();
                hashMap.put(countryGraphPropertyFileSpecification.getISOKey(), arrayList);
            }
            arrayList.add(countryGraphPropertyFileSpecification);
        }
        return hashMap;
    }

    private Map<ISOKey, List<GeographicRelationshipPropertyFileSpecification>> extractGeographicRelationshipISOKeyMap(List<IdentifiablePropertyFileSpecification> list) {
        HashMap<ISOKey, List<GeographicRelationshipPropertyFileSpecification>> hashMap = new HashMap<ISOKey, List<GeographicRelationshipPropertyFileSpecification>>();
        for (IdentifiablePropertyFileSpecification identifiablePropertyFileSpecification : list) {
            if (!(identifiablePropertyFileSpecification instanceof GeographicRelationshipPropertyFileSpecification)) continue;
            GeographicRelationshipPropertyFileSpecification geographicRelationshipPropertyFileSpecification = (GeographicRelationshipPropertyFileSpecification)identifiablePropertyFileSpecification;
            ArrayList<GeographicRelationshipPropertyFileSpecification> arrayList = (ArrayList<GeographicRelationshipPropertyFileSpecification>)hashMap.get(geographicRelationshipPropertyFileSpecification.getIsoKeyA());
            if (arrayList == null) {
                arrayList = new ArrayList<GeographicRelationshipPropertyFileSpecification>();
                hashMap.put(geographicRelationshipPropertyFileSpecification.getIsoKeyA(), arrayList);
            }
            arrayList.add(geographicRelationshipPropertyFileSpecification);
        }
        return hashMap;
    }

    private String createISOCategoryID(String string, ISOKey iSOKey) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(".");
        stringBuilder.append(iSOKey.getKey().toLowerCase());
        return stringBuilder.toString();
    }

    private void outputPluginPropertiesHeader(PrintWriter printWriter) {
        printWriter.println("# Generated Content. Do not edit.");
        printWriter.println("# Generated: " + this.createGeneratedDateComment());
        printWriter.println("pluginName = STEM Geographic Definitions (Incubation)");
        printWriter.println("providerName = Eclipse.org");
    }

    private void outputGraphExtensionsHeader(PrintWriter printWriter, PrintWriter printWriter2, boolean bl) {
        printWriter.println("<!-- *********** Graphs *********** -->");
        printWriter.println("<extension point=\"org.eclipse.stem.core.graph\">");
        if (bl) {
            printWriter.println("<stem_category id=\"org.eclipse.stem.core.graph\" name=\"%_UI_Standard_Scenario_category\" parent_id=\"/\"/>");
            printWriter.println("<stem_category id=\"org.eclipse.stem.core.graph.geography\" name=\"%_UI_Geography_category\" parent_id=\"org.eclipse.stem.core.graph\"/>");
            printWriter.println("<stem_category id=\"org.eclipse.stem.core.graph.geography.political\" name=\"%_UI_Poltical_category\" parent_id=\"org.eclipse.stem.core.graph.geography\"/>");
            printWriter.println("<stem_category id=\"org.eclipse.stem.core.graph.geography.political.countries\" name=\"%_UI_Countries_category\" parent_id=\"org.eclipse.stem.core.graph.geography.political\"/>");
        }
        printWriter2.println("# *********** Graphs ***********");
        printWriter2.println("_UI_Geography_category = Geography");
        printWriter2.println("_UI_Poltical_category = Political");
        printWriter2.println("_UI_Countries_category = Country");
    }

    private void outputGraphExtensionsFooter(PrintWriter printWriter) {
        printWriter.println("</extension>");
    }
}

