/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.geography.isokeycollector;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.stem.data.geography.ISOKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISOKeyCollector {
    private static final String LEVEL_SUFFIX = "0_node.properties";
    private static final String NAMES_SUFFIX = "names.properties";
    public static final String ROOT_PROPERTY_FILES = "resources" + File.separator + "data";
    public static final String ROOT_SERIALIZED_FILES = "temp" + File.separator + "data";
    private static final String LEVEL_0_PROPERTIES_PATH = String.valueOf(ROOT_SERIALIZED_FILES) + File.separator + "country" + File.separator + ISOKey.EARTH.toString();
    private static final String LEVEL_0_PROPERTIES_FILENAME = String.valueOf(LEVEL_0_PROPERTIES_PATH) + File.separator + "level0ISOKeys.properties";
    private static final String LEVEL_0_NAMES_PROPERTIES_FILENAME = String.valueOf(LEVEL_0_PROPERTIES_PATH) + File.separator + "level0ISONames" + ".properties";

    public static void main(String[] stringArray) {
        Object object;
        ISOKey iSOKey;
        if (stringArray.length == 0) {
            System.err.println("Missing specification of source directory as an argument");
            return;
        }
        String string = stringArray[0];
        String string2 = String.valueOf(string) + File.separator + ROOT_PROPERTY_FILES;
        HashMap<ISOKey, ISOKey> hashMap = new HashMap<ISOKey, ISOKey>();
        HashMap<ISOKey, ISOKey> hashMap2 = new HashMap<ISOKey, ISOKey>();
        HashMap<ISOKey, String> hashMap3 = new HashMap<ISOKey, String>();
        List<File> list = ISOKeyCollector.getPropertyFiles(new File(string2));
        List<File> list2 = ISOKeyCollector.getLevel0NodeFiles(list);
        for (File object32 : list2) {
            Properties properties = ISOKeyCollector.getProperties(object32);
            iSOKey = new ISOKey((String)properties.get("ISOKEY"));
            object = ISOKeyCollector.extractAlpha2(properties.getProperty(iSOKey.toString()));
            hashMap.put((ISOKey)object, iSOKey);
            hashMap2.put(iSOKey, (ISOKey)object);
        }
        ISOKeyCollector.saveProperties(hashMap, String.valueOf(string) + File.separator + LEVEL_0_PROPERTIES_FILENAME);
        List<File> list3 = ISOKeyCollector.getNameFiles(list);
        for (Object file : list3) {
            iSOKey = new ISOKey(((File)file).getName().substring(0, 3));
            object = ISOKeyCollector.getProperties((File)file);
            String string3 = (String)((Properties)object).get(iSOKey.toString());
            hashMap3.put((ISOKey)hashMap2.get(iSOKey), string3 == null ? iSOKey.toString() : string3.trim());
        }
        ISOKeyCollector.saveProperties(hashMap3, String.valueOf(string) + File.separator + LEVEL_0_NAMES_PROPERTIES_FILENAME);
    }

    private static void saveProperties(Map<ISOKey, ? extends Object> map, String string) {
        Properties properties = new Properties();
        for (ISOKey object2 : map.keySet()) {
            properties.setProperty(object2.toString(), map.get(object2).toString());
        }
        File file = new File(string);
        try {
            File file2 = new File(file.getParent());
            file2.mkdirs();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            properties.store(bufferedOutputStream, null);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static ISOKey extractAlpha2(String string) {
        String string2 = string.trim();
        String string3 = string2.substring(string2.length() - 2);
        return new ISOKey(string3);
    }

    private static Properties getProperties(File file) {
        Properties properties = new Properties();
        if (file.isFile() && file.canRead()) {
            Object object = null;
            try {
                object = new BufferedInputStream(new FileInputStream(file));
                properties.load((InputStream)object);
                ((BufferedInputStream)object).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
            }
        } else {
            System.err.println("The file \"" + file.getAbsolutePath() + "\" is not a file or can't be read.");
        }
        for (Object object : properties.keySet()) {
            String string = (String)properties.get(object);
            String string2 = string.trim();
            properties.put(object, string2);
        }
        return properties;
    }

    private static List<File> getPropertyFiles(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file.exists() && file.isDirectory()) {
            File[] fileArray;
            File[] fileArray2 = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    String string = file.getName();
                    boolean bl = file.isFile() && string.endsWith(".properties");
                    return bl;
                }
            });
            Collections.addAll(arrayList, fileArray2);
            File[] fileArray3 = fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() && !file.getName().equals(".svn") && !file.getName().equals("CVS");
                }
            });
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray3[n2];
                arrayList.addAll(ISOKeyCollector.getPropertyFiles(file2));
                ++n2;
            }
        } else {
            System.err.println("The directory \"" + file.getAbsolutePath() + "\" doesn't exist or is not a directory");
        }
        return arrayList;
    }

    private static List<File> getNameFiles(List<File> list) {
        return ISOKeyCollector.filterSuffix(list, NAMES_SUFFIX);
    }

    private static List<File> getLevel0NodeFiles(List<File> list) {
        return ISOKeyCollector.filterPath(ISOKeyCollector.filterSuffix(list, LEVEL_SUFFIX));
    }

    private static List<File> filterSuffix(List<File> list, String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : list) {
            if (!file.getName().endsWith(string)) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    private static List<File> filterPath(List<File> list) {
        ArrayList<File> arrayList = new ArrayList<File>();
        String string = "data" + File.separator + "country";
        for (File file : list) {
            if (!file.getAbsolutePath().contains(string)) continue;
            arrayList.add(file);
        }
        return arrayList;
    }
}

