/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.geography.specifications;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.stem.internal.data.geography.specifications.AdminLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminLevelSet {
    private static final String DELIMITER = "_";
    protected List<AdminLevel> adminLevels = new ArrayList<AdminLevel>();
    protected AdminLevel maxAdminLevel = new AdminLevel(Integer.MIN_VALUE);
    protected AdminLevel minAdminLevel = new AdminLevel(Integer.MAX_VALUE);

    public AdminLevelSet() {
    }

    public AdminLevelSet(AdminLevel adminLevel) {
        this.addAdminLevel(adminLevel);
    }

    public AdminLevelSet(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIMITER);
        while (stringTokenizer.hasMoreElements()) {
            this.addAdminLevel(new AdminLevel(stringTokenizer.nextToken()));
        }
    }

    public final void addAdminLevel(int n) {
        this.addAdminLevel(new AdminLevel(n));
    }

    public final void addAdminLevel(AdminLevel adminLevel) {
        if (!this.adminLevels.contains(adminLevel)) {
            this.adminLevels.add(adminLevel);
            this.maxAdminLevel = this.maxAdminLevel.intValue() >= adminLevel.intValue() ? this.maxAdminLevel : adminLevel;
            this.minAdminLevel = this.minAdminLevel.intValue() <= adminLevel.intValue() ? this.minAdminLevel : adminLevel;
            Collections.sort(this.adminLevels);
        }
    }

    public final void addAdminLevels(List<AdminLevel> list) {
        for (AdminLevel adminLevel : list) {
            this.addAdminLevel(adminLevel);
        }
    }

    public final List<AdminLevel> getAdminLevels() {
        return this.adminLevels;
    }

    public List<AdminLevel> getAdminLevelsMaxToMin() {
        ArrayList<AdminLevel> arrayList = new ArrayList<AdminLevel>(this.adminLevels.size());
        for (AdminLevel adminLevel : this.adminLevels) {
            arrayList.add(adminLevel);
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    public final int getNumAdminLevels() {
        return this.adminLevels.size();
    }

    public final AdminLevel getMaxAdminLevel() {
        return this.maxAdminLevel;
    }

    public final AdminLevel getMinAdminLevel() {
        return this.minAdminLevel;
    }

    public List<AdminLevelSet> makeAllLevelSets() {
        ArrayList<AdminLevelSet> arrayList = new ArrayList<AdminLevelSet>();
        int n = 0;
        while (n < this.getNumAdminLevels()) {
            int n2 = n;
            while (n2 < this.getNumAdminLevels()) {
                AdminLevelSet adminLevelSet = new AdminLevelSet();
                int n3 = n;
                while (n3 <= n2) {
                    adminLevelSet.addAdminLevel(this.adminLevels.get(n3));
                    ++n3;
                }
                arrayList.add(adminLevelSet);
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    public final String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < this.adminLevels.size()) {
            if (n != 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(this.adminLevels.get(n));
            ++n;
        }
        return stringBuilder.toString();
    }

    public final String toString() {
        return this.toString(DELIMITER);
    }
}

