/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.geography.specifications;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.stem.data.geography.ISOKey;
import org.eclipse.stem.internal.data.geography.specifications.AdminLevel;
import org.eclipse.stem.internal.data.geography.specifications.AdminLevelSet;
import org.eclipse.stem.internal.data.specifications.GraphPropertyFileSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CountryGraphPropertyFileSpecification
extends GraphPropertyFileSpecification {
    public static final String ADMIN_LEVEL_PROPERTY = "ADMIN_LEVEL";
    public static final String ISOKEY_PROPERTY = "ISOKEY";
    public static final String COUNTRY_DIR = "country";
    protected ISOKey isoKey = null;
    protected AdminLevel adminLevel = null;

    protected CountryGraphPropertyFileSpecification() {
    }

    public final ISOKey getISOKey() {
        return this.isoKey;
    }

    protected void collectNonDataProperties(Properties properties) {
        super.collectNonDataProperties(properties);
        this.adminLevel = new AdminLevel(properties.getProperty(ADMIN_LEVEL_PROPERTY));
        this.isoKey = new ISOKey(properties.getProperty(ISOKEY_PROPERTY));
        properties.remove(ADMIN_LEVEL_PROPERTY);
        properties.remove(ISOKEY_PROPERTY);
    }

    protected String getTargetPluginId() {
        return "org.eclipse.stem.data.geography";
    }

    protected String getRelativeSerializationPath() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(COUNTRY_DIR);
        stringBuilder.append(File.separatorChar);
        stringBuilder.append(this.isoKey.toString());
        return stringBuilder.toString();
    }

    protected String getSerializationFileNameRoot() {
        StringBuilder stringBuilder = new StringBuilder(this.isoKey.toString());
        stringBuilder.append("_");
        stringBuilder.append(this.adminLevel.toString());
        return stringBuilder.toString();
    }

    protected String createDubinCoreCoverage() {
        AdminLevelSet adminLevelSet = new AdminLevelSet(this.adminLevel);
        HashMap<ISOKey, AdminLevelSet> hashMap = new HashMap<ISOKey, AdminLevelSet>();
        hashMap.put(this.isoKey, adminLevelSet);
        return CountryGraphPropertyFileSpecification.createDublinCoreCoverageString(hashMap);
    }

    public static String createDublinCoreCoverageString(Map<ISOKey, AdminLevelSet> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ISOKey iSOKey : map.keySet()) {
            AdminLevelSet adminLevelSet = map.get(iSOKey);
            stringBuilder.append(iSOKey);
            stringBuilder.append(":");
            stringBuilder.append(adminLevelSet.toString());
            stringBuilder.append("/");
        }
        return stringBuilder.toString();
    }

    public static Map<ISOKey, AdminLevelSet> parseDublinCoreCoverageString(String string) {
        HashMap<ISOKey, AdminLevelSet> hashMap = new HashMap<ISOKey, AdminLevelSet>();
        if (string != null && string != "") {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":/");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = stringTokenizer.nextToken();
                ISOKey iSOKey = new ISOKey(string2);
                String string3 = stringTokenizer.nextToken();
                AdminLevelSet adminLevelSet = new AdminLevelSet(string3);
                hashMap.put(iSOKey, adminLevelSet);
            }
        }
        return hashMap;
    }

    protected String getTitleDescriptor() {
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.isoKey.toString());
        stringBuilder.append(" ");
        stringBuilder.append(this.adminLevel);
        return stringBuilder.toString();
    }
}

