/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.geography.specifications;

import java.util.List;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.GraphPackage;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.data.geography.ISOKey;
import org.eclipse.stem.internal.data.geography.specifications.AdminLevel;
import org.eclipse.stem.internal.data.geography.specifications.CountryGraphPropertyFileSpecification;
import org.eclipse.stem.internal.data.propertydata.PropertyData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CountryLabelPropertyFileSpecification
extends CountryGraphPropertyFileSpecification {
    protected String labelName = null;

    protected CountryLabelPropertyFileSpecification(String string) {
        this.labelName = string;
    }

    protected void initializeIdentifiableFromPropertyDataSet(Identifiable identifiable, List<PropertyData> list) {
        Graph graph = (Graph)identifiable;
        for (PropertyData propertyData : list) {
            graph.putNodeLabel(this.createLabel(this.adminLevel, this.isoKey, propertyData));
        }
    }

    protected abstract NodeLabel createLabel(AdminLevel var1, ISOKey var2, PropertyData var3);

    @Override
    protected String getSerializationFileNameRoot() {
        StringBuilder stringBuilder = new StringBuilder(this.isoKey.toString());
        stringBuilder.append("_");
        stringBuilder.append(this.adminLevel.toString());
        stringBuilder.append("_");
        stringBuilder.append(this.labelName);
        return stringBuilder.toString();
    }

    @Override
    public String getTitleDescriptor() {
        StringBuilder stringBuilder = new StringBuilder(this.isoKey.toString());
        stringBuilder.append(" (");
        stringBuilder.append(this.adminLevel.toString());
        stringBuilder.append(") ");
        stringBuilder.append(this.labelName);
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append(" ");
        stringBuilder.append(this.labelName);
        return stringBuilder.toString();
    }

    protected String createDubinCoreSubject() {
        return CountryLabelPropertyFileSpecification.createDublinCoreSubjectString((String)GraphPackage.Literals.LABEL.getName(), (String)this.labelName);
    }
}

