/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.geography.specifications;

import java.util.List;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.GraphPackage;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.data.geography.ISOKey;
import org.eclipse.stem.definitions.nodes.NodesFactory;
import org.eclipse.stem.definitions.nodes.Region;
import org.eclipse.stem.definitions.nodes.impl.RegionImpl;
import org.eclipse.stem.internal.data.geography.propertydata.RegionPropertyData;
import org.eclipse.stem.internal.data.geography.specifications.CountryGraphPropertyFileSpecification;
import org.eclipse.stem.internal.data.propertydata.PropertyData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountryNodePropertyFileSpecification
extends CountryGraphPropertyFileSpecification {
    private static final String NODE_CONTENT_DESCRIPTOR = "node";

    protected PropertyData createPropertyDataInstanceFromProperty(String string, String string2) {
        return new RegionPropertyData(new ISOKey(string), string2);
    }

    protected void initializeIdentifiableFromPropertyDataSet(Identifiable identifiable, List<PropertyData> list) {
        Graph graph = (Graph)identifiable;
        for (PropertyData propertyData : list) {
            graph.putNode(this.createNode(this.dublinCore.getSpatial(), (RegionPropertyData)propertyData));
        }
    }

    private Node createNode(String string, RegionPropertyData regionPropertyData) {
        String string2 = regionPropertyData.getISOKey().toString();
        Region region = NodesFactory.eINSTANCE.createRegion();
        region.setURI(RegionImpl.createRegionNodeURI((String)string2));
        region.getDublinCore().setTitle(String.valueOf(regionPropertyData.getName()) + " " + string2);
        String string3 = string == null ? null : "stemspatial:" + string + "#" + string2;
        region.getDublinCore().setSpatial(string3);
        return region;
    }

    @Override
    protected String getTitleDescriptor() {
        StringBuilder stringBuilder = new StringBuilder(this.isoKey.toString());
        stringBuilder.append("(");
        stringBuilder.append(this.adminLevel.toString());
        stringBuilder.append(") Nodes");
        return stringBuilder.toString();
    }

    protected String createDubinCoreSubject() {
        return CountryNodePropertyFileSpecification.createDublinCoreSubjectString((String)GraphPackage.Literals.NODE.getName(), (String)"region");
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append(" ");
        stringBuilder.append(NODE_CONTENT_DESCRIPTOR);
        return stringBuilder.toString();
    }
}

