/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.internal.data.geography.specifications;

import java.io.File;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.core.graph.GraphFactory;
import org.eclipse.stem.data.geography.ISOKey;
import org.eclipse.stem.definitions.nodes.impl.RegionImpl;
import org.eclipse.stem.internal.data.geography.propertydata.GeographicRelationshipPropertyData;
import org.eclipse.stem.internal.data.geography.specifications.AdminLevel;
import org.eclipse.stem.internal.data.geography.specifications.AdminLevelSet;
import org.eclipse.stem.internal.data.geography.specifications.CountryGraphPropertyFileSpecification;
import org.eclipse.stem.internal.data.propertydata.RelationshipPropertyData;
import org.eclipse.stem.internal.data.specifications.RelationshipGraphPropertyFileSpecification;

public abstract class GeographicRelationshipPropertyFileSpecification
extends RelationshipGraphPropertyFileSpecification {
    public static final String ISOKEY_0_PROPERTY = "ISOKEY_0";
    public static final String ISOKEY_1_PROPERTY = "ISOKEY_1";
    public static final String ISOKEY_0_LEVEL_PROPERTY = "ISOKEY_0_LEVEL";
    public static final String ISOKEY_1_LEVEL_PROPERTY = "ISOKEY_1_LEVEL";
    protected ISOKey isoKeyA = null;
    protected ISOKey isoKeyB = null;
    protected AdminLevel adminLevel0 = null;
    protected AdminLevel adminLevel1 = null;

    protected void collectNonDataProperties(Properties properties) {
        super.collectNonDataProperties(properties);
        this.isoKeyA = new ISOKey(properties.getProperty(ISOKEY_0_PROPERTY));
        this.isoKeyB = new ISOKey(properties.getProperty(ISOKEY_1_PROPERTY));
        this.adminLevel0 = new AdminLevel(properties.getProperty(ISOKEY_0_LEVEL_PROPERTY));
        this.adminLevel1 = new AdminLevel(properties.getProperty(ISOKEY_1_LEVEL_PROPERTY));
        properties.remove(ISOKEY_0_PROPERTY);
        properties.remove(ISOKEY_1_PROPERTY);
        properties.remove(ISOKEY_0_LEVEL_PROPERTY);
        properties.remove(ISOKEY_1_LEVEL_PROPERTY);
    }

    public String getTitleDescriptor() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.isoKeyA.toString());
        stringBuilder.append(" ");
        stringBuilder.append(this.getRelationshipName());
        stringBuilder.append(" ");
        stringBuilder.append(this.isoKeyB.toString());
        return stringBuilder.toString();
    }

    protected URI createNodeURI(ISOKey iSOKey, ISOKey iSOKey2) {
        URI uRI = null;
        uRI = iSOKey.equals((Object)ISOKey.EARTH) && !iSOKey2.equals((Object)ISOKey.EARTH) ? RegionImpl.createRegionNodeURI((String)iSOKey2.toString()) : RegionImpl.createRegionNodeURI((String)iSOKey2.toString());
        return uRI;
    }

    public URI createRelationshipURI(String string, RelationshipPropertyData relationshipPropertyData) {
        GeographicRelationshipPropertyData geographicRelationshipPropertyData = (GeographicRelationshipPropertyData)relationshipPropertyData;
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append("/");
        stringBuilder.append("relationship");
        stringBuilder.append("/");
        stringBuilder.append(this.getRelationshipName());
        stringBuilder.append("/");
        stringBuilder.append(geographicRelationshipPropertyData.getKeyA().toString());
        stringBuilder.append("_");
        stringBuilder.append(geographicRelationshipPropertyData.getKeyB().toString());
        stringBuilder.append(this.getRelationshipSpecifier(relationshipPropertyData));
        return STEMURI.createURI((String)stringBuilder.toString());
    }

    protected String createEdgeSpecificSpatialURI(String string) {
        return string;
    }

    protected String getTargetPluginId() {
        return "org.eclipse.stem.data.geography";
    }

    protected String getSerializationFileNameRoot() {
        StringBuilder stringBuilder = new StringBuilder(this.isoKeyA.toString());
        stringBuilder.append("_");
        stringBuilder.append(this.adminLevel0.toString());
        stringBuilder.append("_");
        stringBuilder.append(this.isoKeyB.toString());
        stringBuilder.append("_");
        stringBuilder.append(this.adminLevel1.toString());
        return stringBuilder.toString();
    }

    protected String getRelativeSerializationPath() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("relationship");
        stringBuilder.append(File.separatorChar);
        stringBuilder.append(this.getRelationshipName());
        return stringBuilder.toString();
    }

    protected Edge createEdge(RelationshipPropertyData relationshipPropertyData, String string) {
        Edge edge = GraphFactory.eINSTANCE.createEdge();
        GeographicRelationshipPropertyData geographicRelationshipPropertyData = (GeographicRelationshipPropertyData)relationshipPropertyData;
        edge.setDirected(geographicRelationshipPropertyData.isDirected());
        edge.setURI(this.createRelationshipEdgeURI(geographicRelationshipPropertyData));
        if (string != null) {
            edge.getDublinCore().setSpatial(this.createEdgeSpecificSpatialURI(string));
        }
        edge.setNodeAURI(this.createNodeURI(geographicRelationshipPropertyData.getKeyA(), geographicRelationshipPropertyData.getKeyA()));
        edge.setNodeBURI(this.createNodeURI(geographicRelationshipPropertyData.getKeyB(), geographicRelationshipPropertyData.getKeyB()));
        EdgeLabel edgeLabel = this.createEdgeLabel(geographicRelationshipPropertyData);
        edge.setLabel(edgeLabel);
        return edge;
    }

    protected String createDubinCoreCoverage() {
        HashMap<ISOKey, AdminLevelSet> hashMap = new HashMap<ISOKey, AdminLevelSet>();
        if (this.isoKeyA.equals((Object)this.isoKeyB)) {
            AdminLevelSet adminLevelSet = new AdminLevelSet(this.adminLevel0);
            adminLevelSet.addAdminLevel(this.adminLevel1);
            hashMap.put(this.isoKeyA, adminLevelSet);
        } else {
            AdminLevelSet adminLevelSet = new AdminLevelSet(this.adminLevel0);
            AdminLevelSet adminLevelSet2 = new AdminLevelSet(this.adminLevel1);
            hashMap.put(this.isoKeyA, adminLevelSet);
            hashMap.put(this.isoKeyB, adminLevelSet2);
        }
        return CountryGraphPropertyFileSpecification.createDublinCoreCoverageString(hashMap);
    }

    public final ISOKey getIsoKeyA() {
        return this.isoKeyA;
    }

    public final ISOKey getIsoKeyB() {
        return this.isoKeyB;
    }

    public final AdminLevel getAdminLevel0() {
        return this.adminLevel0;
    }

    public final AdminLevel getAdminLevel1() {
        return this.adminLevel1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getRelationshipName());
        stringBuilder.append(" ");
        stringBuilder.append(this.isoKeyA);
        stringBuilder.append("(");
        stringBuilder.append(this.adminLevel0);
        stringBuilder.append(")");
        stringBuilder.append(" -- ");
        stringBuilder.append(this.isoKeyB);
        stringBuilder.append("(");
        stringBuilder.append(this.adminLevel1);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

