/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.common.presentation;

import java.io.File;
import java.net.URL;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.ui.action.WorkbenchWindowActionDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stem.core.common.presentation.CoreEditorPlugin;
import org.eclipse.stem.ui.Activator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.internal.ide.model.WorkbenchAdapterBuilder;
import org.osgi.framework.Bundle;

public final class CoreEditorAdvisor
extends WorkbenchAdvisor {
    private static String getString(String string) {
        return CoreEditorPlugin.INSTANCE.getString(string);
    }

    private static String getString(String string, Object object) {
        return CoreEditorPlugin.INSTANCE.getString(string, new Object[]{object});
    }

    public void initialize(IWorkbenchConfigurer iWorkbenchConfigurer) {
        super.initialize(iWorkbenchConfigurer);
        iWorkbenchConfigurer.setSaveAndRestore(true);
        this.declareWorkbenchImages();
    }

    public IAdaptable getDefaultPageInput() {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        return iWorkspaceRoot;
    }

    public void preStartup() {
        WorkbenchAdapterBuilder.registerAdapters();
    }

    private void declareWorkbenchImages() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.ide");
        this.declareWorkbenchImage(bundle, "IMG_ETOOL_BUILD_EXEC", "$nl$/icons/full/etool16/build_exec.gif", false);
        this.declareWorkbenchImage(bundle, "IMG_ETOOL_BUILD_EXEC_HOVER", "$nl$/icons/full/etool16/build_exec.gif", false);
        this.declareWorkbenchImage(bundle, "IMG_ETOOL_BUILD_EXEC_DISABLED", "$nl$/icons/full/dtool16/build_exec.gif", false);
        this.declareWorkbenchImage(bundle, "IMG_ETOOL_SEARCH_SRC", "$nl$/icons/full/etool16/search_src.gif", false);
        this.declareWorkbenchImage(bundle, "IMG_ETOOL_SEARCH_SRC_HOVER", "$nl$/icons/full/etool16/search_src.gif", false);
        this.declareWorkbenchImage(bundle, "IMG_ETOOL_SEARCH_SRC_DISABLED", "$nl$/icons/full/dtool16/search_src.gif", false);
        this.declareWorkbenchImage(bundle, "IMG_ETOOL_NEXT_NAV", "$nl$/icons/full/etool16/next_nav.gif", false);
        this.declareWorkbenchImage(bundle, "IMG_ETOOL_PREVIOUS_NAV", "$nl$/icons/full/etool16/prev_nav.gif", false);
        this.declareWorkbenchImage(bundle, "IMG_WIZBAN_NEWPRJ_WIZ", "$nl$/icons/full/wizban/newprj_wiz.png", false);
        this.declareWorkbenchImage(bundle, "IMG_WIZBAN_NEWFOLDER_WIZ", "$nl$/icons/full/wizban/newfolder_wiz.png", false);
        this.declareWorkbenchImage(bundle, "IMG_WIZBAN_NEWFILE_WIZ", "$nl$/icons/full/wizban/newfile_wiz.png", false);
        this.declareWorkbenchImage(bundle, "IMG_WIZBAN_IMPORTDIR_WIZ", "$nl$/icons/full/wizban/importdir_wiz.png", false);
        this.declareWorkbenchImage(bundle, "IMG_WIZBAN_IMPORTZIP_WIZ", "$nl$/icons/full/wizban/importzip_wiz.png", false);
        this.declareWorkbenchImage(bundle, "IMG_WIZBAN_EXPORTDIR_WIZ", "$nl$/icons/full/wizban/exportdir_wiz.png", false);
        this.declareWorkbenchImage(bundle, "IMG_WIZBAN_EXPORTZIP_WIZ", "$nl$/icons/full/wizban/exportzip_wiz.png", false);
        this.declareWorkbenchImage(bundle, "IMG_WIZBAN_EXPORTZIP_WIZ", "$nl$/icons/full/wizban/workset_wiz.png", false);
        this.declareWorkbenchImage(bundle, "IMG_DLGBAN_SAVEAS_DLG", "$nl$/icons/full/wizban/saveas_wiz.png", false);
        this.declareWorkbenchImage(bundle, "IMG_DLGBAN_QUICKFIX_DLG", "$nl$/icons/full/wizban/quick_fix.png", false);
        this.declareWorkbenchImage(bundle, "IMG_OBJ_PROJECT", "$nl$/icons/full/obj16/prj_obj.gif", true);
        this.declareWorkbenchImage(bundle, "IMG_OBJ_PROJECT_CLOSED", "$nl$/icons/full/obj16/cprj_obj.gif", true);
        this.declareWorkbenchImage(bundle, "IMG_OPEN_MARKER", "$nl$/icons/full/elcl16/gotoobj_tsk.gif", true);
        this.declareWorkbenchImage(bundle, "IMG_ELCL_QUICK_FIX_ENABLED", "$nl$/icons/full/elcl16/smartmode_co.gif", true);
        this.declareWorkbenchImage(bundle, "IMG_DLCL_QUICK_FIX_DISABLED", "$nl$/icons/full/dlcl16/smartmode_co.gif", true);
        this.declareWorkbenchImage(bundle, "IMG_OBJS_TASK_TSK", "$nl$/icons/full/obj16/taskmrk_tsk.gif", true);
        this.declareWorkbenchImage(bundle, "IMG_OBJS_BKMRK_TSK", "$nl$/icons/full/obj16/bkmrk_tsk.gif", true);
        this.declareWorkbenchImage(bundle, "IMG_OBJS_COMPLETE_TSK", "$nl$/icons/full/obj16/complete_tsk.gif", true);
        this.declareWorkbenchImage(bundle, "IMG_OBJS_INCOMPLETE_TSK", "$nl$/icons/full/obj16/incomplete_tsk.gif", true);
        this.declareWorkbenchImage(bundle, "IMG_OBJS_WELCOME_ITEM", "$nl$/icons/full/obj16/welcome_item.gif", true);
        this.declareWorkbenchImage(bundle, "IMG_OBJS_WELCOME_BANNER", "$nl$/icons/full/obj16/welcome_banner.gif", true);
        this.declareWorkbenchImage(bundle, "IMG_OBJS_ERROR_PATH", "$nl$/icons/full/obj16/error_tsk.gif", true);
        this.declareWorkbenchImage(bundle, "IMG_OBJS_WARNING_PATH", "$nl$/icons/full/obj16/warn_tsk.gif", true);
        this.declareWorkbenchImage(bundle, "IMG_OBJS_INFO_PATH", "$nl$/icons/full/obj16/info_tsk.gif", true);
        this.declareWorkbenchImage(bundle, "IMG_LCL_FLAT_LAYOUT", "$nl$/icons/full/elcl16/flatLayout.gif", true);
        this.declareWorkbenchImage(bundle, "IMG_LCL_HIERARCHICAL_LAYOUT", "$nl$/icons/full/elcl16/hierarchicalLayout.gif", true);
        this.declareWorkbenchImage(bundle, "IMG_ETOOL_PROBLEM_CATEGORY", "$nl$/icons/full/etool16/problem_category.gif", true);
    }

    private void declareWorkbenchImage(Bundle bundle, String string, String string2, boolean bl) {
        URL uRL = FileLocator.find((Bundle)bundle, (IPath)new Path(string2), null);
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
        this.getWorkbenchConfigurer().declareImage(string, imageDescriptor, bl);
    }

    public static String openFilePathDialog(Shell shell, String string, int n) {
        FileDialog fileDialog = new FileDialog(shell, n);
        if (string == null) {
            string = "*." + CoreEditorAdvisor.getString("_UI_CommonEditorFilenameExtension") + ";" + "*." + CoreEditorAdvisor.getString("_UI_GraphEditorFilenameExtension") + ";" + "*." + CoreEditorAdvisor.getString("_UI_ModelEditorFilenameExtension") + ";" + "*." + CoreEditorAdvisor.getString("_UI_ScenarioEditorFilenameExtension") + ";" + "*." + CoreEditorAdvisor.getString("_UI_SequencerEditorFilenameExtension");
        }
        fileDialog.setFilterExtensions(new String[]{string});
        fileDialog.open();
        if (fileDialog.getFileName() != null && fileDialog.getFileName().length() > 0) {
            return String.valueOf(fileDialog.getFilterPath()) + File.separator + fileDialog.getFileName();
        }
        return null;
    }

    public static boolean openEditor(IWorkbench iWorkbench, URI uRI) {
        IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        IEditorDescriptor iEditorDescriptor = iWorkbench.getEditorRegistry().getDefaultEditor(uRI.toFileString());
        if (iEditorDescriptor == null) {
            MessageDialog.openError((Shell)iWorkbenchWindow.getShell(), (String)CoreEditorAdvisor.getString("_UI_Error_title"), (String)CoreEditorAdvisor.getString("_WARN_No_Editor", uRI.toFileString()));
            return false;
        }
        try {
            iWorkbenchPage.openEditor((IEditorInput)new URIEditorInput(uRI), iEditorDescriptor.getId());
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)iWorkbenchWindow.getShell(), (String)CoreEditorAdvisor.getString("_UI_OpenEditorError_label"), (String)partInitException.getMessage());
            return false;
        }
        return true;
    }

    public String getInitialWindowPerspectiveId() {
        return "org.eclipse.stem.ui.STEMSimulationPerspective";
    }

    public String getMainPreferencePageId() {
        return "org.eclipse.stem.ui.preferences.STEMPreferencePage";
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
        return new WindowAdvisor(iWorkbenchWindowConfigurer);
    }

    public static class AboutAction
    extends WorkbenchWindowActionDelegate {
        public void run(IAction iAction) {
            MessageDialog.openInformation((Shell)this.getWindow().getShell(), (String)CoreEditorAdvisor.getString("_UI_About_title"), (String)CoreEditorAdvisor.getString("_UI_About_text"));
        }
    }

    public static class Application
    implements IApplication {
        public Object start(IApplicationContext iApplicationContext) throws Exception {
            CoreEditorAdvisor coreEditorAdvisor = new CoreEditorAdvisor();
            Display display = PlatformUI.createDisplay();
            try {
                int n = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)coreEditorAdvisor);
                if (n == 1) {
                    Integer n2 = IApplication.EXIT_RESTART;
                    return n2;
                }
                Integer n3 = IApplication.EXIT_OK;
                return n3;
            }
            finally {
                display.dispose();
            }
        }

        public void stop() {
        }
    }

    public static class OpenAction
    extends WorkbenchWindowActionDelegate {
        public void run(IAction iAction) {
            String string = CoreEditorAdvisor.openFilePathDialog(this.getWindow().getShell(), null, 4096);
            if (string != null) {
                CoreEditorAdvisor.openEditor(this.getWindow().getWorkbench(), URI.createFileURI((String)string));
            }
        }
    }

    public static class OpenURIAction
    extends WorkbenchWindowActionDelegate {
        public void run(IAction iAction) {
            LoadResourceAction.LoadResourceDialog loadResourceDialog = new LoadResourceAction.LoadResourceDialog(this.getWindow().getShell());
            if (loadResourceDialog.open() == 0) {
                for (URI uRI : loadResourceDialog.getURIs()) {
                    CoreEditorAdvisor.openEditor(this.getWindow().getWorkbench(), uRI);
                }
            }
        }
    }

    public static class Perspective
    implements IPerspectiveFactory {
        public static final String ID_PERSPECTIVE = "org.eclipse.stem.core.common.presentation.CoreEditorAdvisorPerspective";

        public void createInitialLayout(IPageLayout iPageLayout) {
            iPageLayout.setEditorAreaVisible(true);
            iPageLayout.addPerspectiveShortcut(ID_PERSPECTIVE);
            IFolderLayout iFolderLayout = iPageLayout.createFolder("right", 2, 0.66f, iPageLayout.getEditorArea());
            iFolderLayout.addView("org.eclipse.ui.views.ContentOutline");
            IFolderLayout iFolderLayout2 = iPageLayout.createFolder("bottonRight", 4, 0.6f, "right");
            iFolderLayout2.addView("org.eclipse.ui.views.PropertySheet");
        }
    }

    public static class WindowActionBarAdvisor
    extends ActionBarAdvisor {
        public WindowActionBarAdvisor(IActionBarConfigurer iActionBarConfigurer) {
            super(iActionBarConfigurer);
        }

        protected void fillMenuBar(IMenuManager iMenuManager) {
            IWorkbenchWindow iWorkbenchWindow = this.getActionBarConfigurer().getWindowConfigurer().getWindow();
            iMenuManager.add((IContributionItem)this.createFileMenu(iWorkbenchWindow));
            iMenuManager.add((IContributionItem)this.createEditMenu(iWorkbenchWindow));
            iMenuManager.add((IContributionItem)new GroupMarker("additions"));
            iMenuManager.add((IContributionItem)this.createWindowMenu(iWorkbenchWindow));
            iMenuManager.add((IContributionItem)this.createHelpMenu(iWorkbenchWindow));
        }

        protected IMenuManager createFileMenu(IWorkbenchWindow iWorkbenchWindow) {
            MenuManager menuManager = new MenuManager(CoreEditorAdvisor.getString("_UI_Menu_File_label"), "file");
            menuManager.add((IContributionItem)new GroupMarker("fileStart"));
            MenuManager menuManager2 = new MenuManager(CoreEditorAdvisor.getString("_UI_Menu_New_label"), "new");
            menuManager2.add((IContributionItem)new GroupMarker("additions"));
            menuManager.add((IContributionItem)menuManager2);
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IContributionItem)new GroupMarker("additions"));
            menuManager.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menuManager, (IAction)ActionFactory.CLOSE.create(iWorkbenchWindow));
            this.addToMenuAndRegister((IMenuManager)menuManager, (IAction)ActionFactory.CLOSE_ALL.create(iWorkbenchWindow));
            menuManager.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menuManager, (IAction)ActionFactory.SAVE.create(iWorkbenchWindow));
            this.addToMenuAndRegister((IMenuManager)menuManager, (IAction)ActionFactory.SAVE_AS.create(iWorkbenchWindow));
            this.addToMenuAndRegister((IMenuManager)menuManager, (IAction)ActionFactory.SAVE_ALL.create(iWorkbenchWindow));
            menuManager.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menuManager, (IAction)ActionFactory.IMPORT.create(iWorkbenchWindow));
            this.addToMenuAndRegister((IMenuManager)menuManager, (IAction)ActionFactory.EXPORT.create(iWorkbenchWindow));
            menuManager.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menuManager, (IAction)ActionFactory.QUIT.create(iWorkbenchWindow));
            menuManager.add((IContributionItem)new GroupMarker("fileEnd"));
            return menuManager;
        }

        protected IMenuManager createEditMenu(IWorkbenchWindow iWorkbenchWindow) {
            MenuManager menuManager = new MenuManager(CoreEditorAdvisor.getString("_UI_Menu_Edit_label"), "edit");
            menuManager.add((IContributionItem)new GroupMarker("editStart"));
            this.addToMenuAndRegister((IMenuManager)menuManager, (IAction)ActionFactory.UNDO.create(iWorkbenchWindow));
            this.addToMenuAndRegister((IMenuManager)menuManager, (IAction)ActionFactory.REDO.create(iWorkbenchWindow));
            menuManager.add((IContributionItem)new GroupMarker("undo.ext"));
            menuManager.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menuManager, (IAction)ActionFactory.CUT.create(iWorkbenchWindow));
            this.addToMenuAndRegister((IMenuManager)menuManager, (IAction)ActionFactory.COPY.create(iWorkbenchWindow));
            this.addToMenuAndRegister((IMenuManager)menuManager, (IAction)ActionFactory.PASTE.create(iWorkbenchWindow));
            menuManager.add((IContributionItem)new GroupMarker("cut.ext"));
            menuManager.add((IContributionItem)new Separator());
            this.addToMenuAndRegister((IMenuManager)menuManager, (IAction)ActionFactory.DELETE.create(iWorkbenchWindow));
            this.addToMenuAndRegister((IMenuManager)menuManager, (IAction)ActionFactory.SELECT_ALL.create(iWorkbenchWindow));
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IContributionItem)new GroupMarker("add.ext"));
            menuManager.add((IContributionItem)new GroupMarker("editEnd"));
            menuManager.add((IContributionItem)new Separator("additions"));
            return menuManager;
        }

        protected IMenuManager createWindowMenu(IWorkbenchWindow iWorkbenchWindow) {
            MenuManager menuManager = new MenuManager(CoreEditorAdvisor.getString("_UI_Menu_Window_label"), "window");
            this.addToMenuAndRegister((IMenuManager)menuManager, (IAction)ActionFactory.OPEN_PERSPECTIVE_DIALOG.create(iWorkbenchWindow));
            this.addToMenuAndRegister((IMenuManager)menuManager, (IAction)ActionFactory.OPEN_NEW_WINDOW.create(iWorkbenchWindow));
            menuManager.add(ContributionItemFactory.OPEN_WINDOWS.create(iWorkbenchWindow));
            menuManager.add(ContributionItemFactory.VIEWS_SHORTLIST.create(iWorkbenchWindow));
            this.addToMenuAndRegister((IMenuManager)menuManager, (IAction)ActionFactory.PREFERENCES.create(iWorkbenchWindow));
            menuManager.add((IContributionItem)new GroupMarker("additions"));
            return menuManager;
        }

        protected IMenuManager createHelpMenu(IWorkbenchWindow iWorkbenchWindow) {
            MenuManager menuManager = new MenuManager(CoreEditorAdvisor.getString("_UI_Menu_Help_label"), "help");
            ActionFactory.IWorkbenchAction iWorkbenchAction = ActionFactory.ABOUT.create(iWorkbenchWindow);
            ActionFactory.IWorkbenchAction iWorkbenchAction2 = ActionFactory.HELP_CONTENTS.create(iWorkbenchWindow);
            menuManager.add((IContributionItem)new GroupMarker("helpStart"));
            this.addToMenuAndRegister((IMenuManager)menuManager, (IAction)iWorkbenchAction2);
            this.addToMenuAndRegister((IMenuManager)menuManager, (IAction)iWorkbenchAction);
            menuManager.add((IContributionItem)new GroupMarker("helpEnd"));
            menuManager.add((IContributionItem)new GroupMarker("additions"));
            return menuManager;
        }

        protected void addToMenuAndRegister(IMenuManager iMenuManager, IAction iAction) {
            iMenuManager.add(iAction);
            this.getActionBarConfigurer().registerGlobalAction(iAction);
        }
    }

    public static class WindowAdvisor
    extends WorkbenchWindowAdvisor {
        public WindowAdvisor(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
            super(iWorkbenchWindowConfigurer);
        }

        public void preWindowOpen() {
            IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer = this.getWindowConfigurer();
            iWorkbenchWindowConfigurer.setInitialSize(new Point(1024, 768));
            iWorkbenchWindowConfigurer.setShowCoolBar(true);
            iWorkbenchWindowConfigurer.setShowStatusLine(true);
            iWorkbenchWindowConfigurer.setShowFastViewBars(true);
            iWorkbenchWindowConfigurer.setShowProgressIndicator(true);
            iWorkbenchWindowConfigurer.setShowPerspectiveBar(true);
        }

        public boolean preWindowShellClose() {
            try {
                ResourcesPlugin.getWorkspace().save(true, null);
            }
            catch (CoreException coreException) {
                Activator.logError("Failed to save workspace before quitting", coreException);
            }
            return true;
        }

        public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer iActionBarConfigurer) {
            return new WindowActionBarAdvisor(iActionBarConfigurer);
        }
    }
}

