/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.solver;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.stem.core.solver.Solver;
import org.eclipse.stem.core.solver.SolverPropertyEditor;
import org.eclipse.stem.core.solver.SolverPropertyEditorAdapter;
import org.eclipse.stem.core.solver.SolverPropertyEditorAdapterFactory;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SolverPropertyComposite
extends Composite {
    private Map<Solver, SolverPropertyEditor> modelMap = new HashMap<Solver, SolverPropertyEditor>();
    private StackLayout stackLayout = new StackLayout();

    public SolverPropertyComposite(Composite composite, int n, Solver[] solverArray, ModifyListener modifyListener) {
        super(composite, n);
        this.setLayout((Layout)this.stackLayout);
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.getString("SPC1"));
        SolverPropertyEditor solverPropertyEditor = null;
        if (solverArray != null) {
            int n2 = 0;
            while (n2 < solverArray.length) {
                SolverPropertyEditorAdapter solverPropertyEditorAdapter = (SolverPropertyEditorAdapter)SolverPropertyEditorAdapterFactory.INSTANCE.adapt((Notifier)solverArray[n2], SolverPropertyEditorAdapter.class);
                SolverPropertyEditor solverPropertyEditor2 = solverPropertyEditorAdapter.createSolverPropertyEditor(this, 0, modifyListener);
                this.modelMap.put(solverArray[n2], solverPropertyEditor2);
                if (solverPropertyEditor == null) {
                    solverPropertyEditor = solverPropertyEditor2;
                }
                ++n2;
            }
        }
        this.stackLayout.topControl = solverPropertyEditor;
    }

    public void displaySolver(Solver solver) {
        SolverPropertyEditor solverPropertyEditor = this.modelMap.get(solver);
        if (solverPropertyEditor != null) {
            this.stackLayout.topControl = solverPropertyEditor;
            this.layout();
        } else {
            Activator.logError(String.valueOf(Messages.getString("SPC2")) + solver.getClass().getName() + "\"", null);
        }
    }

    public Solver createSolver() {
        SolverPropertyEditor solverPropertyEditor = (SolverPropertyEditor)this.stackLayout.topControl;
        return solverPropertyEditor.createAndPopulateSolver();
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public boolean validate() {
        return ((SolverPropertyEditor)this.stackLayout.topControl).validate();
    }

    public String getErrorMessage() {
        return ((SolverPropertyEditor)this.stackLayout.topControl).getErrorMessage();
    }

    public void populateSolver(Solver solver) {
        ((SolverPropertyEditor)this.stackLayout.topControl).populate(solver);
    }
}

