/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.solver.presentation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stem.core.common.presentation.CoreEditorPlugin;
import org.eclipse.stem.core.common.provider.CoreEditPlugin;
import org.eclipse.stem.core.solver.SolverFactory;
import org.eclipse.stem.core.solver.SolverPackage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolverModelWizard
extends Wizard
implements INewWizard {
    public static final List<String> FILE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(CoreEditorPlugin.INSTANCE.getString("_UI_SolverEditorFilenameExtensions").split("\\s*,\\s*")));
    public static final String FORMATTED_FILE_EXTENSIONS = CoreEditorPlugin.INSTANCE.getString("_UI_SolverEditorFilenameExtensions").replaceAll("\\s*,\\s*", ", ");
    protected SolverPackage solverPackage = SolverPackage.eINSTANCE;
    protected SolverFactory solverFactory = this.solverPackage.getSolverFactory();
    protected SolverModelWizardNewFileCreationPage newFileCreationPage;
    protected SolverModelWizardInitialObjectCreationPage initialObjectCreationPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected List<String> initialObjectNames;

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        this.selection = iStructuredSelection;
        this.setWindowTitle(CoreEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(CoreEditorPlugin.INSTANCE.getImage("full/wizban/NewSolver")));
    }

    protected Collection<String> getInitialObjectNames() {
        if (this.initialObjectNames == null) {
            this.initialObjectNames = new ArrayList<String>();
            for (EClassifier eClassifier : this.solverPackage.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract()) continue;
                this.initialObjectNames.add(eClass.getName());
            }
            Collections.sort(this.initialObjectNames, CommonPlugin.INSTANCE.getComparator());
        }
        return this.initialObjectNames;
    }

    protected EObject createInitialModel() {
        EClass eClass = (EClass)this.solverPackage.getEClassifier(this.initialObjectCreationPage.getInitialObjectName());
        EObject eObject = this.solverFactory.create(eClass);
        return eObject;
    }

    public boolean performFinish() {
        try {
            final IFile iFile = this.getModelFile();
            WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor iProgressMonitor) {
                    try {
                        try {
                            ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
                            URI uRI = URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true);
                            Resource resource = resourceSetImpl.createResource(uRI);
                            EObject eObject = SolverModelWizard.this.createInitialModel();
                            if (eObject != null) {
                                resource.getContents().add((Object)eObject);
                            }
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            hashMap.put("ENCODING", SolverModelWizard.this.initialObjectCreationPage.getEncoding());
                            resource.save(hashMap);
                        }
                        catch (Exception exception) {
                            CoreEditorPlugin.INSTANCE.log(exception);
                            iProgressMonitor.done();
                        }
                    }
                    finally {
                        iProgressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)workspaceModifyOperation);
            IWorkbenchWindow iWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
            final IWorkbenchPart iWorkbenchPart = iWorkbenchPage.getActivePart();
            if (iWorkbenchPart instanceof ISetSelectionTarget) {
                StructuredSelection structuredSelection = new StructuredSelection((Object)iFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)structuredSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    public void run() {
                        ((ISetSelectionTarget)iWorkbenchPart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput(iFile), this.workbench.getEditorRegistry().getDefaultEditor(iFile.getFullPath().toString()).getId());
            }
            catch (PartInitException partInitException) {
                MessageDialog.openError((Shell)iWorkbenchWindow.getShell(), (String)CoreEditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)partInitException.getMessage());
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            CoreEditorPlugin.INSTANCE.log(exception);
            return false;
        }
    }

    public void addPages() {
        Object e;
        this.newFileCreationPage = new SolverModelWizardNewFileCreationPage("Whatever", this.selection);
        this.newFileCreationPage.setTitle(CoreEditorPlugin.INSTANCE.getString("_UI_SolverModelWizard_label"));
        this.newFileCreationPage.setDescription(CoreEditorPlugin.INSTANCE.getString("_UI_SolverModelWizard_description"));
        this.newFileCreationPage.setFileName(String.valueOf(CoreEditorPlugin.INSTANCE.getString("_UI_SolverEditorFilenameDefaultBase")) + "." + FILE_EXTENSIONS.get(0));
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (e = this.selection.iterator().next()) instanceof IResource) {
            IResource iResource = (IResource)e;
            if (iResource.getType() == 1) {
                iResource = iResource.getParent();
            }
            if (iResource instanceof IFolder || iResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(iResource.getFullPath());
                String string = CoreEditorPlugin.INSTANCE.getString("_UI_SolverEditorFilenameDefaultBase");
                String string2 = FILE_EXTENSIONS.get(0);
                String string3 = String.valueOf(string) + "." + string2;
                int n = 1;
                while (((IContainer)iResource).findMember(string3) != null) {
                    string3 = String.valueOf(string) + n + "." + string2;
                    ++n;
                }
                this.newFileCreationPage.setFileName(string3);
            }
        }
        this.initialObjectCreationPage = new SolverModelWizardInitialObjectCreationPage("Whatever2");
        this.initialObjectCreationPage.setTitle(CoreEditorPlugin.INSTANCE.getString("_UI_SolverModelWizard_label"));
        this.initialObjectCreationPage.setDescription(CoreEditorPlugin.INSTANCE.getString("_UI_Wizard_initial_object_description"));
        this.addPage((IWizardPage)this.initialObjectCreationPage);
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SolverModelWizardInitialObjectCreationPage
    extends WizardPage {
        protected Combo initialObjectField;
        protected List<String> encodings;
        protected Combo encodingField;
        protected ModifyListener validator;

        public SolverModelWizardInitialObjectCreationPage(String string) {
            super(string);
            this.validator = new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    SolverModelWizardInitialObjectCreationPage.this.setPageComplete(SolverModelWizardInitialObjectCreationPage.this.validatePage());
                }
            };
        }

        public void createControl(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            gridLayout.verticalSpacing = 12;
            composite2.setLayout((Layout)gridLayout);
            GridData object2 = new GridData();
            object2.verticalAlignment = 4;
            object2.grabExcessVerticalSpace = true;
            object2.horizontalAlignment = 4;
            composite2.setLayoutData((Object)object2);
            gridLayout = new Label(composite2, 16384);
            gridLayout.setText(CoreEditorPlugin.INSTANCE.getString("_UI_ModelObject"));
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridLayout.setLayoutData((Object)gridData);
            this.initialObjectField = new Combo(composite2, 2048);
            GridData gridData2 = new GridData();
            gridData2.horizontalAlignment = 4;
            gridData2.grabExcessHorizontalSpace = true;
            this.initialObjectField.setLayoutData((Object)gridData2);
            for (String string : SolverModelWizard.this.getInitialObjectNames()) {
                this.initialObjectField.add(this.getLabel(string));
            }
            if (this.initialObjectField.getItemCount() == 1) {
                this.initialObjectField.select(0);
            }
            this.initialObjectField.addModifyListener(this.validator);
            Label label = new Label(composite2, 16384);
            label.setText(CoreEditorPlugin.INSTANCE.getString("_UI_XMLEncoding"));
            GridData gridData3 = new GridData();
            gridData3.horizontalAlignment = 4;
            label.setLayoutData((Object)gridData3);
            this.encodingField = new Combo(composite2, 2048);
            GridData gridData4 = new GridData();
            gridData4.horizontalAlignment = 4;
            gridData4.grabExcessHorizontalSpace = true;
            this.encodingField.setLayoutData((Object)gridData4);
            for (String string : this.getEncodings()) {
                this.encodingField.add(string);
            }
            this.encodingField.select(0);
            this.encodingField.addModifyListener(this.validator);
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite2);
        }

        protected boolean validatePage() {
            return this.getInitialObjectName() != null && this.getEncodings().contains(this.encodingField.getText());
        }

        public void setVisible(boolean bl) {
            super.setVisible(bl);
            if (bl) {
                if (this.initialObjectField.getItemCount() == 1) {
                    this.initialObjectField.clearSelection();
                    this.encodingField.setFocus();
                } else {
                    this.encodingField.clearSelection();
                    this.initialObjectField.setFocus();
                }
            }
        }

        public String getInitialObjectName() {
            String string = this.initialObjectField.getText();
            for (String string2 : SolverModelWizard.this.getInitialObjectNames()) {
                if (!this.getLabel(string2).equals(string)) continue;
                return string2;
            }
            return null;
        }

        public String getEncoding() {
            return this.encodingField.getText();
        }

        protected String getLabel(String string) {
            try {
                return CoreEditPlugin.INSTANCE.getString("_UI_" + string + "_type");
            }
            catch (MissingResourceException missingResourceException) {
                CoreEditorPlugin.INSTANCE.log(missingResourceException);
                return string;
            }
        }

        protected Collection<String> getEncodings() {
            if (this.encodings == null) {
                this.encodings = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(CoreEditorPlugin.INSTANCE.getString("_UI_XMLEncodingChoices"));
                while (stringTokenizer.hasMoreTokens()) {
                    this.encodings.add(stringTokenizer.nextToken());
                }
            }
            return this.encodings;
        }
    }

    public class SolverModelWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        public SolverModelWizardNewFileCreationPage(String string, IStructuredSelection iStructuredSelection) {
            super(string, iStructuredSelection);
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String string = new Path(this.getFileName()).getFileExtension();
                if (string == null || !FILE_EXTENSIONS.contains(string)) {
                    String string2 = FILE_EXTENSIONS.size() > 1 ? "_WARN_FilenameExtensions" : "_WARN_FilenameExtension";
                    this.setErrorMessage(CoreEditorPlugin.INSTANCE.getString(string2, new Object[]{FORMATTED_FILE_EXTENSIONS}));
                    return false;
                }
                return true;
            }
            return false;
        }

        public IFile getModelFile() {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
        }
    }
}

