/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapterFactory;
import org.eclipse.stem.ui.adapters.featuremodifiereditcomposite.ExperimentFeatureModifierEditCompositeFactory;
import org.eclipse.stem.ui.adapters.newmodifierpage.GraphNewModifierPageAdapterFactory;
import org.eclipse.stem.ui.adapters.newmodifierpage.LabelsNewModifierPageAdapterFactory;
import org.eclipse.stem.ui.adapters.newmodifierpage.SequencerNewModifierPageAdapterFactory;
import org.eclipse.stem.ui.adapters.propertystrings.LabelsPropertyStringProviderAdapterFactory;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.stem.ui";
    private static Activator plugin;
    private static ColorRegistry colorRegistry;
    private static FontRegistry fontRegistry;

    static {
        colorRegistry = null;
        fontRegistry = null;
    }

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        IConfigurationElement[] iConfigurationElementArray;
        super.start(bundleContext);
        new SequencerNewModifierPageAdapterFactory();
        new GraphNewModifierPageAdapterFactory();
        new LabelsNewModifierPageAdapterFactory();
        new ExperimentFeatureModifierEditCompositeFactory();
        new LabelsPropertyStringProviderAdapterFactory();
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.stem.ui.colorproviders");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            if (!iConfigurationElement.isValid()) {
                Activator.logError("Invalid color provider extension", null);
            } else {
                Bundle bundle = Platform.getBundle((String)iConfigurationElement.getContributor().getName());
                String string = iConfigurationElement.getAttribute("name");
                String string2 = iConfigurationElement.getAttribute("factory");
                String string3 = iConfigurationElement.getAttribute("provider");
                Class clazz = bundle.loadClass(string2);
                Object t = clazz.newInstance();
                Class clazz2 = bundle.loadClass(string3);
                ColorProviderAdapterFactory.INSTANCE.addAdapterFactory((AdapterFactory)t, clazz2, string);
            }
            ++n2;
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        plugin = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public ColorRegistry getColorRegistry() {
        if (colorRegistry == null) {
            colorRegistry = new ColorRegistry();
            this.initializeColorRegistry(colorRegistry);
        }
        return colorRegistry;
    }

    public FontRegistry getFontRegistry() {
        if (fontRegistry == null) {
            fontRegistry = new FontRegistry();
            this.initializeFontRegistry(fontRegistry);
        }
        return fontRegistry;
    }

    protected void initializeImageRegistry(ImageRegistry imageRegistry) {
        imageRegistry.put("graph.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Graph.gif"));
        imageRegistry.put("graph_model_file.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/GraphModelFile.gif"));
        imageRegistry.put("edge.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Edge.gif"));
        imageRegistry.put("dynamic_label.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/DynamicLabel.gif"));
        imageRegistry.put("static_label.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/StaticLabel.gif"));
        imageRegistry.put("node.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Node.gif"));
        imageRegistry.put("model.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Model.gif"));
        imageRegistry.put("model_model_file.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Model.gif"));
        imageRegistry.put("scenario.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Scenario.gif"));
        imageRegistry.put("scenario_model_file.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/ScenarioModelFile.gif"));
        imageRegistry.put("sequencer.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Sequencer.gif"));
        imageRegistry.put("experiment.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Experiment.gif"));
        imageRegistry.put("trigger.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Trigger.gif"));
        imageRegistry.put("predicate.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Predicate.gif"));
        imageRegistry.put("modifier.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Modifier.gif"));
        imageRegistry.put("decorator.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/Decorator.gif"));
        imageRegistry.put("stem_project.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/stem.gif"));
        imageRegistry.put("stem_project.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/StemProject.gif"));
        imageRegistry.put("stem_explorer.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/stemExplorer.gif"));
        imageRegistry.put("simulation_control_view.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/simulationControlView.gif"));
        imageRegistry.put("simulation_control.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/simulationControl.gif"));
        imageRegistry.put("delete.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/delete.gif"));
        imageRegistry.put("generic_file.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/genericFile.gif"));
        imageRegistry.put("scenario_File.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/ScenarioModelFile.gif"));
        imageRegistry.put("scenario_file.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/ScenarioModelFile.gif"));
        imageRegistry.put("run.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/actions16/run.gif"));
        imageRegistry.put("pause.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/actions16/pause.gif"));
        imageRegistry.put("reset.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/actions16/reset.gif"));
        imageRegistry.put("step.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/actions16/step.gif"));
        imageRegistry.put("stop.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/actions16/stop.gif"));
        imageRegistry.put("disabled_run.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/actions16/disabledRun.gif"));
        imageRegistry.put("disabled_pause.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/actions16/disabledPause.gif"));
        imageRegistry.put("disabled_reset.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/actions16/disabledReset.gif"));
        imageRegistry.put("disabled_step.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/actions16/disabledStep.gif"));
        imageRegistry.put("disabled_stop.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/actions16/disabledStop.gif"));
        imageRegistry.put("map.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/map.gif"));
        imageRegistry.put("recorded_simulation.image", Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/full/customobj16/RecordedSimulations.gif"));
    }

    protected void initializeColorRegistry(ColorRegistry colorRegistry) {
        colorRegistry.put("green", new RGB(55, 255, 50));
        colorRegistry.put("yellow", new RGB(255, 255, 0));
        colorRegistry.put("orange", new RGB(255, 170, 30));
        colorRegistry.put("gray", new RGB(217, 217, 217));
    }

    protected void initializeFontRegistry(FontRegistry fontRegistry) {
        int n = JFaceResources.getDefaultFont().getFontData()[0].getHeight();
        FontData fontData = new FontData("Courier New", n, 0);
        fontRegistry.put("default", new FontData[]{fontData});
    }

    public static void logError(String string, Throwable throwable) {
        plugin.getLog().log((IStatus)new Status(4, plugin.getBundle().getSymbolicName(), 0, string, throwable));
    }

    public static void logInformation(String string, Throwable throwable) {
        plugin.getLog().log((IStatus)new Status(1, plugin.getBundle().getSymbolicName(), 0, string, throwable));
    }

    public static void switchToPerspective(String string) {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        try {
            iWorkbench.showPerspective("org.eclipse.stem.ui.STEMSimulationPerspective", iWorkbench.getActiveWorkbenchWindow());
        }
        catch (WorkbenchException workbenchException) {
            Activator.logError("Problem switching to Perspective with ID=\"" + string + "\"", workbenchException);
        }
    }
}

