/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Label;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.ui.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utility {
    public static List<IProject> getSTEMProjectsFromWorkspace() {
        return Utility.getSTEMProjectsFromWorkspace(ResourcesPlugin.getWorkspace());
    }

    public static List<IProject> getSTEMProjectsFromWorkspace(IWorkspace iWorkspace) {
        IProject[] iProjectArray;
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        IProject[] iProjectArray2 = iProjectArray = iWorkspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray2[n2];
            if (Utility.isSTEMProject(iProject)) {
                arrayList.add(iProject);
            }
            ++n2;
        }
        return arrayList;
    }

    public static boolean isSTEMProject(IProject iProject) {
        boolean bl = false;
        try {
            String[] stringArray = iProject.getDescription().getNatureIds();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.equals("org.eclipse.stem.stemnature")) {
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            bl = false;
        }
        return bl;
    }

    public static Identifiable getIdentifiable(IFile iFile) {
        URI uRI = URI.createFileURI((String)iFile.getLocation().toString());
        return Utility.getIdentifiable(uRI);
    }

    public static Identifiable getIdentifiable(URI uRI) {
        Identifiable identifiable = null;
        try {
            ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
            resourceSetImpl.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
            resourceSetImpl.getResourceFactoryRegistry().getProtocolToFactoryMap().put("platform", new XMIResourceFactoryImpl());
            Resource resource = resourceSetImpl.getResource(uRI, true);
            identifiable = (Identifiable)resource.getContents().get(0);
        }
        catch (Exception exception) {
            Activator.logError("The file \"" + uRI.toString() + "\" was not found or was of the wrong format", exception);
            identifiable = null;
        }
        return identifiable;
    }

    public static Label getLabel(URI uRI) {
        NodeLabel nodeLabel = null;
        if (Utility.isAreaLabel(uRI)) {
            URI uRI2 = Utility.createAreaGraphURI(uRI);
            Graph graph = (Graph)Utility.getIdentifiable(uRI2);
            nodeLabel = graph.getNodeLabel(uRI);
        } else if (Utility.isPopulationLabel(uRI)) {
            URI uRI3 = Utility.createPopulationGraphURI(uRI);
            Graph graph = (Graph)Utility.getIdentifiable(uRI3);
            nodeLabel = graph.getNodeLabel(uRI);
        }
        return nodeLabel;
    }

    private static boolean isAreaLabel(URI uRI) {
        return Utility.extractLabelName(uRI.toString()).equals("area");
    }

    private static boolean isPopulationLabel(URI uRI) {
        return Utility.extractLabelName(uRI.toString()).equals("population");
    }

    private static URI createAreaGraphURI(URI uRI) {
        String string = URI.createPlatformPluginURI((String)"org.eclipse.stem.data.geography", (boolean)false).toString();
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(string) + "/resources/data");
        stringBuilder.append("/country/");
        String string2 = uRI.toString();
        String string3 = Utility.extractLabelName(string2);
        String string4 = Utility.extractISOKey(string2, string3);
        String string5 = Utility.extractISOLevel(string2, string4);
        stringBuilder.append(string4);
        stringBuilder.append("/");
        String string6 = Utility.createAreaGraphFileName(string4, string5, string3);
        stringBuilder.append(string6);
        return URI.createURI((String)stringBuilder.toString());
    }

    private static URI createPopulationGraphURI(URI uRI) {
        String string = URI.createPlatformPluginURI((String)"org.eclipse.stem.data.geography.population.human", (boolean)false).toString();
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(string) + "/resources/data");
        stringBuilder.append("/country/");
        String string2 = uRI.toString();
        String string3 = Utility.extractLabelName(string2);
        String string4 = Utility.extractISOKey(string2, string3);
        String string5 = Utility.extractISOLevel(string2, string4);
        String string6 = Utility.extractPopulationName(string2, string5);
        String string7 = Utility.extractPopulationDate(string2, string6);
        stringBuilder.append(string4);
        stringBuilder.append("/");
        stringBuilder.append(Utility.createPopulationGraphFileName(string4, string5, string3, string6, string7));
        return URI.createURI((String)stringBuilder.toString());
    }

    private static String extractPopulationDate(String string, String string2) {
        int n = string.indexOf(string2);
        String string3 = string.substring(n + string2.length() + 1);
        int n2 = string3.indexOf("/");
        return string3.substring(0, n2);
    }

    static String createPopulationGraphFileName(String string, String string2, String string3, String string4, String string5) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append("_");
        stringBuilder.append(string2);
        stringBuilder.append("_");
        stringBuilder.append(string4);
        stringBuilder.append("_");
        stringBuilder.append(string5);
        stringBuilder.append("_");
        stringBuilder.append("population.graph");
        return stringBuilder.toString();
    }

    private static String extractPopulationName(String string, String string2) {
        int n = string.indexOf(string2);
        String string3 = string.substring(n + string2.length() + 1);
        int n2 = string3.indexOf("/");
        return string3.substring(0, n2);
    }

    private static String extractISOLevel(String string, String string2) {
        int n = string.indexOf(string2) + string2.length() + 1;
        return string.substring(n, n + 1);
    }

    private static String createAreaGraphFileName(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append("_");
        stringBuilder.append(string2);
        stringBuilder.append("_");
        stringBuilder.append(string3);
        stringBuilder.append(".graph");
        return stringBuilder.toString();
    }

    private static String extractISOKey(String string, String string2) {
        int n = string.indexOf(string2) + 1 + string2.length();
        int n2 = n + 3;
        return string.substring(n, n2);
    }

    private static String extractLabelName(String string) {
        String string2 = string.substring(string.indexOf("label") + "label".length() + 1);
        return string2.substring(0, string2.indexOf("/"));
    }
}

