/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.adapters.color;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapter;
import org.eclipse.stem.ui.adapters.color.RelativeValueColorProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractRelativeValueColorProviderAdapter
extends ColorProviderAdapter
implements RelativeValueColorProvider {
    private Color max_FillColor;
    private Color range_08_1_FillColor;
    private Color range_06_08_FillColor;
    private Color range_04_06_FillColor;
    private Color range_02_04_FillColor;
    private Color range_0_02_FillColor;
    protected Color zero_FillColor;
    protected Color foregroundFillColor;
    public Color backgroundFillColor;
    protected final float ZERO_RELATIVE_VALUE_THRESHOLD = 1.0E-9f;
    protected Decorator selectedDecorator = null;
    protected RelativeValueProviderAdapter rvp = null;
    protected Device device = null;

    public AbstractRelativeValueColorProviderAdapter() {
        this.updateColorsFromPreferences();
    }

    public Color getColor(Device device) {
        double d = this.getRelativeValue();
        this.device = device;
        return this.getColorForRelativeValue(d);
    }

    public void updateGC(GC gC) {
        this.updateGC(gC, 1.0f, false);
    }

    public void updateGC(GC gC, float f, boolean bl) {
        Color color = this.getColor(gC.getDevice());
        gC.setBackground(color);
    }

    public abstract float getRelativeValue();

    protected Color getColorForRelativeValue(double d) {
        Color color = this.device.getSystemColor(2);
        this.updateColorsFromPreferences();
        if (d == 1.0) {
            color = this.max_FillColor;
        } else if (d > 0.8) {
            color = this.range_08_1_FillColor;
        } else if (d > 0.6) {
            color = this.range_06_08_FillColor;
        } else if (d > 0.4) {
            color = this.range_04_06_FillColor;
        } else if (d > 0.2) {
            color = this.range_02_04_FillColor;
        } else if (d > (double)1.0E-9f) {
            color = this.range_0_02_FillColor;
        } else if (d <= (double)1.0E-9f) {
            color = this.zero_FillColor;
        }
        return color;
    }

    public boolean isAdapterForType(Object object) {
        return object == RelativeValueColorProvider.class;
    }

    private Color getColorFromString(String string) {
        if (string.equals("")) {
            return this.device.getSystemColor(2);
        }
        RGB rGB = StringConverter.asRGB((String)string);
        return new Color(this.device, rGB.red, rGB.green, rGB.blue);
    }

    private void updateColorsFromPreferences() {
        Preferences preferences = Activator.getDefault().getPluginPreferences();
        this.max_FillColor = this.getColorFromString(preferences.getString("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolormaximum"));
        this.range_08_1_FillColor = this.getColorFromString(preferences.getString("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorrange5"));
        this.range_06_08_FillColor = this.getColorFromString(preferences.getString("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorrange4"));
        this.range_04_06_FillColor = this.getColorFromString(preferences.getString("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorrange3"));
        this.range_02_04_FillColor = this.getColorFromString(preferences.getString("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorrange2"));
        this.range_0_02_FillColor = this.getColorFromString(preferences.getString("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorrange1"));
        this.zero_FillColor = this.getColorFromString(preferences.getString("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolorzero"));
        this.foregroundFillColor = this.getColorFromString(preferences.getString("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolor"));
        this.backgroundFillColor = this.getColorFromString(preferences.getString("org.eclipse.stem.ui.views.geographic.map.preferences.backgroundcolor"));
    }

    public void setSelectedDecorator(Decorator decorator) {
        this.selectedDecorator = decorator;
    }

    protected void setRVPTarget(Notifier notifier) {
        if (this.rvp == null) {
            this.rvp = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt(notifier, RelativeValueProvider.class);
        } else {
            this.rvp.setTarget(notifier);
        }
    }
}

