/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.adapters.color;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.stem.ui.Activator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;

public class StandardColorProvider
implements Preferences.IPropertyChangeListener {
    private Map<String, Color> colorIdToColor = new HashMap<String, Color>();
    private Device device = null;

    public StandardColorProvider(Device device) {
        this.device = device;
        Preferences preferences = Activator.getDefault().getPluginPreferences();
        preferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        this.updateColorsFromPreferences();
    }

    public Color getBackgroundColor() {
        return this.colorIdToColor.get("org.eclipse.stem.ui.views.geographic.map.preferences.backgroundcolor");
    }

    public Color getBordersColor() {
        return this.colorIdToColor.get("org.eclipse.stem.ui.views.geographic.map.preferences.borderscolor");
    }

    public Color getEdgesColor() {
        return this.colorIdToColor.get("org.eclipse.stem.ui.views.geographic.map.preferences.edgescolor");
    }

    public Color getForegroundColor() {
        return this.colorIdToColor.get("org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolor");
    }

    public Color getColorFromString(String string) {
        if (string.equals("")) {
            return this.device.getSystemColor(2);
        }
        RGB rGB = StringConverter.asRGB((String)string);
        return new Color(this.device, rGB.red, rGB.green, rGB.blue);
    }

    private void updateColorsFromPreferences() {
        Preferences preferences = Activator.getDefault().getPluginPreferences();
        String string = "org.eclipse.stem.ui.views.geographic.map.preferences.foregroundcolor";
        this.colorIdToColor.put(string, this.getColorFromString(preferences.getString(string)));
        string = "org.eclipse.stem.ui.views.geographic.map.preferences.backgroundcolor";
        this.colorIdToColor.put(string, this.getColorFromString(preferences.getString(string)));
        string = "org.eclipse.stem.ui.views.geographic.map.preferences.borderscolor";
        this.colorIdToColor.put(string, this.getColorFromString(preferences.getString(string)));
        string = "org.eclipse.stem.ui.views.geographic.map.preferences.edgescolor";
        this.colorIdToColor.put(string, this.getColorFromString(preferences.getString(string)));
    }

    public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if (!this.colorIdToColor.containsKey(string)) {
            return;
        }
        Color color = this.getColorFromString((String)propertyChangeEvent.getNewValue());
        this.colorIdToColor.put(string, color);
    }
}

